/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.conf;

import com.tandbergtv.workflow.adaptor.conf.AdaptorConfigurationException;
import com.tandbergtv.workflow.adaptor.conf.DispatcherConfigurationImpl;
import com.tandbergtv.workflow.adaptor.conf.DispatcherParameter;
import com.tandbergtv.workflow.adaptor.conf.HandlerConfigurationImpl;
import com.tandbergtv.workflow.adaptor.conf.HandlerParameter;
import com.tandbergtv.workflow.adaptor.conf.IConfiguration;
import com.tandbergtv.workflow.adaptor.conf.IConfigurationLoader;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.conf.IMessageProcessorConfiguration;
import com.tandbergtv.workflow.adaptor.conf.MessageProcessorConfigurationImpl;
import com.tandbergtv.workflow.comm.DeviceType;
import com.tandbergtv.workflow.comm.HTTPDevice;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.TCPDevice;
import com.tandbergtv.workflow.message.IMessageUID;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginConfigurationLoader
implements IConfigurationLoader {
    private static final String DEFAULT_CONFIGURATION_ROOT_XPATH = "//default-config/default";
    private static final String DEFAULT_OUTGOING_HANDLER_XPATH = "//defaultOutgoing/handler";
    private static final String DEFAULT_OUTGOING_DISPATCHER_XPATH = "//defaultOutgoing/dispatcher";
    private static final String DEFAULT_INCOMING_HANDLER_XPATH = "//defaultIncoming/handler";
    private static final String DEFAULT_INCOMING_DISPATCHER_XPATH = "//defaultIncoming/dispatcher";
    private static final String DEFAULT_PARAMETER_XPATH = "/parameter";
    private static final String HANDLER_PARAMETER_XPATH = "//handler/parameter";
    private static final String DISPATCHER_PARAMETER_XPATH = "//dispatcher/parameter";
    private static final String DESTINATION_XPATH = "//addressing/destination";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String DESTINATION_TYPE_ATTR = "type";
    private static final String IP = "ip";
    private static final String PORT = "port";
    private static final String CONFIG_FILE = "adaptor.xml";
    private static final String DEFAULT_CONFIG_FILE = "default-config.xml";
    private Document defaultConfigDoc = null;
    private String retryInterval = "30";
    private String retryCount = "0";
    private static final Logger LOGGER = Logger.getLogger(PluginConfigurationLoader.class);

    public PluginConfigurationLoader() {
        this.initDefaultConfigDoc();
    }

    public PluginConfigurationLoader(String retryInterval, String retryCount) {
        if (retryInterval != null) {
            this.retryInterval = retryInterval;
        }
        if (retryCount != null) {
            this.retryCount = retryCount;
        }
        this.initDefaultConfigDoc();
    }

    @Override
    public IMessageProcessorConfiguration getConfiguration(ClassLoader loader, IMessageUID uid) {
        IMessageProcessorConfiguration conf = null;
        try {
            conf = this.readConfiguration(loader, uid);
            this.addDefaults(uid, conf);
        }
        catch (Exception e) {
            throw new AdaptorConfigurationException("Failed to read configuration", e);
        }
        return conf;
    }

    private List<IDestination> getDestinations(Node document) {
        ArrayList<IDestination> destinations = new ArrayList<IDestination>();
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nodes = (NodeList)xpath.evaluate(DESTINATION_XPATH, document, XPathConstants.NODESET);
            int i = 0;
            while (i < nodes.getLength()) {
                Element e = (Element)nodes.item(i);
                String type = e.getAttributes().getNamedItem(DESTINATION_TYPE_ATTR).getTextContent();
                IDestination destination = this.getDestination(e, type);
                destinations.add(destination);
                ++i;
            }
        }
        catch (Exception e) {
            throw new AdaptorConfigurationException("Failed to read configuration", e);
        }
        return destinations;
    }

    private void initDefaultConfigDoc() {
        String prefix = this.getClass().getPackage().getName();
        String defaultResource = String.valueOf(prefix.replace('.', '/')) + "/" + DEFAULT_CONFIG_FILE;
        InputStream defaultStream = null;
        try {
            try {
                defaultStream = this.getClass().getClassLoader().getResourceAsStream(defaultResource);
                this.defaultConfigDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(defaultStream);
            }
            catch (IOException e) {
                throw new AdaptorConfigurationException("Failed to read default configuration file - " + defaultResource + ", maybe you haven't bundled it in the JAR?");
            }
            catch (Exception ex) {
                throw new AdaptorConfigurationException("Failed to parse default configuration file - " + defaultResource);
            }
        }
        finally {
            try {
                if (defaultStream != null) {
                    defaultStream.close();
                }
            }
            catch (IOException e) {
                throw new AdaptorConfigurationException("Error closing stream while reading default configuration - " + defaultResource);
            }
        }
    }

    private IMessageProcessorConfiguration readConfiguration(ClassLoader loader, IMessageUID uid) throws XPathExpressionException {
        Document document = this.getConfigDoc(loader, uid);
        HandlerConfigurationImpl handlerConf = new HandlerConfigurationImpl(uid.getUID(), loader);
        DispatcherConfigurationImpl dispatcherConf = new DispatcherConfigurationImpl(uid.getUID(), loader);
        ArrayList<IDestination> destinations = new ArrayList();
        if (document != null) {
            this.getSubConfiguration(HANDLER_PARAMETER_XPATH, document, handlerConf);
            this.getSubConfiguration(DISPATCHER_PARAMETER_XPATH, document, dispatcherConf);
            destinations = this.getDestinations(document);
        }
        dispatcherConf.addParameter(DispatcherParameter.ADAPTOR_RETRY_INTERVAL.toString(), this.retryInterval);
        dispatcherConf.addParameter(DispatcherParameter.ADAPTOR_RETRY_MAX.toString(), this.retryCount);
        return new MessageProcessorConfigurationImpl(handlerConf, dispatcherConf, destinations);
    }

    private void getSubConfiguration(String subConfXPath, Node document, IConfiguration conf) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nodes = null;
        try {
            nodes = (NodeList)xpath.evaluate(subConfXPath, document, XPathConstants.NODESET);
        }
        catch (Exception e) {
            throw new XPathExpressionException("could not evaluate:" + subConfXPath);
        }
        LOGGER.debug((Object)("Parameters[" + subConfXPath + "]:"));
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            String name = node.getAttributes().getNamedItem(NAME_ATTRIBUTE).getNodeValue();
            String value = node.getAttributes().getNamedItem(VALUE_ATTRIBUTE).getNodeValue();
            LOGGER.debug((Object)("\t" + name + ", " + value));
            conf.addParameter(name, value);
            ++i;
        }
    }

    private IDestination getDestination(Element e, String type) {
        HTTPDevice destination = null;
        if (DeviceType.HTTP.toString().equalsIgnoreCase(type)) {
            Node child = e.getElementsByTagName("url").item(0);
            String url = child.getTextContent();
            destination = new HTTPDevice(url);
        } else if (DeviceType.TCP.toString().equalsIgnoreCase(type)) {
            Node child = e.getElementsByTagName("host").item(0);
            String ip = child.getAttributes().getNamedItem(IP).getTextContent();
            String port = child.getAttributes().getNamedItem(PORT).getTextContent();
            destination = new TCPDevice(ip, Integer.parseInt(port));
        }
        return destination;
    }

    private void addDefaults(IMessageUID uid, IMessageProcessorConfiguration conf) throws XPathExpressionException {
        IHandlerConfiguration handlerConf = conf.getHandlerConfiguration();
        IDispatcherConfiguration dispatcherConf = conf.getDispatcherConfiguration();
        this.addDefaultClassName(uid, conf);
        this.addDefaultParameters(uid, handlerConf);
        this.addDefaultParameters(uid, dispatcherConf);
    }

    private void addDefaultClassName(IMessageUID uid, IMessageProcessorConfiguration conf) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        IHandlerConfiguration handlerConf = conf.getHandlerConfiguration();
        IDispatcherConfiguration dispatchConf = conf.getDispatcherConfiguration();
        if (uid.isMessageOutgoing()) {
            Node node;
            String expression;
            if (handlerConf.getParameterValue(HandlerParameter.CLASS_NAME) == null) {
                expression = "//defaultOutgoing/handler/@classname";
                node = (Node)xpath.evaluate(expression, this.defaultConfigDoc, XPathConstants.NODE);
                handlerConf.addParameter(HandlerParameter.CLASS_NAME.toString(), node.getTextContent());
            }
            if (dispatchConf.getParameterValue(DispatcherParameter.CLASS_NAME) == null) {
                expression = "//defaultOutgoing/dispatcher/@classname";
                node = (Node)xpath.evaluate(expression, this.defaultConfigDoc, XPathConstants.NODE);
                dispatchConf.addParameter(DispatcherParameter.CLASS_NAME.toString(), node.getTextContent());
            }
        } else {
            Node node;
            String expression;
            if (handlerConf.getParameterValue(HandlerParameter.CLASS_NAME) == null) {
                expression = "//defaultIncoming/handler/@classname";
                node = (Node)xpath.evaluate(expression, this.defaultConfigDoc, XPathConstants.NODE);
                handlerConf.addParameter(HandlerParameter.CLASS_NAME.toString(), node.getTextContent());
            }
            if (dispatchConf.getParameterValue(DispatcherParameter.CLASS_NAME) == null) {
                expression = "//defaultIncoming/dispatcher/@classname";
                node = (Node)xpath.evaluate(expression, this.defaultConfigDoc, XPathConstants.NODE);
                dispatchConf.addParameter(DispatcherParameter.CLASS_NAME.toString(), node.getTextContent());
            }
        }
    }

    private void addDefaultParameters(IMessageUID uid, IConfiguration conf) throws XPathExpressionException {
        String expression = "//default-config/default[@classname='" + conf.getParameterValue(HandlerParameter.CLASS_NAME.toString()) + "']" + DEFAULT_PARAMETER_XPATH;
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nodes = (NodeList)xpath.evaluate(expression, this.defaultConfigDoc, XPathConstants.NODESET);
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            String name = node.getAttributes().getNamedItem(NAME_ATTRIBUTE).getNodeValue();
            String value = node.getAttributes().getNamedItem(VALUE_ATTRIBUTE).getNodeValue();
            if (conf.getParameterValue(name) == null) {
                LOGGER.debug((Object)("\t Adding default parameter: " + name + ", " + value));
                conf.addParameter(name, value);
            }
            ++i;
        }
    }

    private Document getConfigDoc(ClassLoader loader, IMessageUID uid) {
        Document messageConfig = null;
        String resource = "./adaptor/" + uid.getUID() + "/" + CONFIG_FILE;
        InputStream stream = null;
        try {
            try {
                stream = loader.getResourceAsStream(resource);
                messageConfig = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(stream);
            }
            catch (Exception ex) {
                LOGGER.debug((Object)("Failed to read configuration file - " + resource + " for UID:" + uid), (Throwable)ex);
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    throw new AdaptorConfigurationException("Error closing stream while reading cofiguration - " + resource);
                }
            }
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new AdaptorConfigurationException("Error closing stream while reading cofiguration - " + resource);
            }
        }
        return messageConfig;
    }
}

