/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.api;

import com.tandbergtv.workflow.api.API;
import com.tandbergtv.workflow.api.APIException;
import com.tandbergtv.workflow.api.Activities;
import com.tandbergtv.workflow.api.Processes;
import com.tandbergtv.workflow.api.ResourceGroups;
import com.tandbergtv.workflow.api.Resources;
import com.tandbergtv.workflow.api.Tasks;
import com.tandbergtv.workflow.api.Templates;
import com.tandbergtv.workflow.api.model.process.Activity;
import com.tandbergtv.workflow.api.model.process.ActivityListResponse;
import com.tandbergtv.workflow.api.model.process.Task;
import com.tandbergtv.workflow.api.model.process.TaskListResponse;
import com.tandbergtv.workflow.api.model.process.Template;
import com.tandbergtv.workflow.api.model.process.TemplateListResponse;
import com.tandbergtv.workflow.api.model.resource.Resource;
import com.tandbergtv.workflow.api.model.resource.ResourceGroup;
import com.tandbergtv.workflow.api.model.resource.ResourceGroupListResponse;
import com.tandbergtv.workflow.api.model.resource.ResourceListResponse;
import java.io.IOException;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class APITest
extends Assert {
    @Test
    public void doit() throws IOException {
        Processes client = new API.Builder().build().processes();
        client.query().count(10);
        long total = client.execute().getTotal();
        System.out.println("Total process count is " + total);
    }

    @Test(enabled=false)
    public void rg() throws IOException {
        ResourceGroups client = new API("http://localhost:8081/workflow/").resourceGroups();
        ResourceGroupListResponse response = client.execute();
        APITest.assertEquals((int)response.getTotal(), (int)8);
    }

    @Test(enabled=false)
    public void rgg() throws IOException {
        ResourceGroups client = new API("http://localhost:8081/workflow/").resourceGroups();
        client.query().id("123");
        ResourceGroupListResponse response = client.execute();
        APITest.assertEquals((int)response.getTotal(), (int)1);
        ResourceGroup group = response.getItems().get(0);
        APITest.assertEquals((String)group.getName(), (String)"Content Management");
        APITest.assertTrue((boolean)group.getVisible());
    }

    @Test(enabled=false)
    public void doeeet() throws IOException {
        Templates client = new API.Builder().build().templates();
        client.query().category("Distribution");
        List<Template> response = client.execute().getItems();
        APITest.assertEquals((int)response.size(), (int)2);
    }

    @Test(enabled=false)
    public void r() throws IOException {
        Resources client = new API("http://localhost:8081/workflow/").resources();
        client.query().name("Envivio 1");
        ResourceListResponse response = client.execute();
        APITest.assertEquals((int)response.getTotal(), (int)1);
        Resource resource = response.getItems().get(0);
        APITest.assertEquals((String)resource.getResourceType(), (String)"Envivio Adapter");
    }

    @Test(enabled=false)
    public void rrrr() throws IOException {
        Resources client = new API("http://localhost:8081/workflow/").resources();
        client.query().systemId("ea").detail("full");
        ResourceListResponse response = client.execute();
        APITest.assertEquals((int)response.getTotal(), (int)1);
        Resource resource = response.getItems().get(0);
        APITest.assertEquals((String)resource.getResourceType(), (String)"Envivio Adapter");
    }

    @Test(enabled=false)
    public void r2d2() throws IOException {
        Resources client = new API("http://localhost:8081/workflow/").resources();
        ResourceListResponse response = client.execute();
        APITest.assertEquals((int)response.getTotal(), (int)6);
    }

    @Test(enabled=false)
    public void oooob() throws IOException {
        Templates client = new API("http://localhost:8081/workflow/").templates();
        client.query().start(10).count(10);
        TemplateListResponse response = client.execute();
        APITest.assertEquals((int)response.getItems().size(), (int)10);
        APITest.assertEquals((int)response.getTotal(), (int)65);
        APITest.assertNotNull((Object)response.getNextPageToken());
    }

    @Test(enabled=false)
    public void activity() throws IOException {
        Activities client = new API("https://localhost:8443/workflow/").activities();
        client.query().providerId("ABC.COM");
        ActivityListResponse response = client.execute();
        APITest.assertEquals((String)response.getItems().get(0).getId(), (String)"822128");
        APITest.assertEquals((int)response.getItems().size(), (int)1);
        for (Activity activity : response.getItems()) {
            APITest.assertNotNull((Object)activity.getId());
            APITest.assertNotNull((Object)activity.getStatus());
            APITest.assertNotNull((Object)activity.getAdminStatus());
            APITest.assertNotNull((Object)activity.getPriority());
            APITest.assertNotNull((Object)activity.getUsageStartDate());
            APITest.assertNotNull((Object)activity.getCurrent());
            APITest.assertNotNull((Object)activity.getResource());
            APITest.assertNotNull((Object)activity.getResourceId());
            APITest.assertNotNull((Object)activity.getTemplate());
            APITest.assertNotNull((Object)activity.getProgress());
            APITest.assertNotNull((Object)activity.getTitleId());
            APITest.assertNotNull((Object)activity.getProviderId());
        }
    }

    @Test(enabled=false)
    public void task() throws IOException {
        Tasks client = new API("https://localhost:8443/workflow/").tasks();
        client.query().user("admin");
        TaskListResponse response = client.execute();
        for (Task task : response.getItems()) {
            APITest.assertNotNull((Object)task.getId());
            APITest.assertNotNull((Object)task.getName());
            APITest.assertNotNull((Object)task.getStart());
            APITest.assertNotNull((Object)task.getTaskId());
            APITest.assertNotNull((Object)task.getTemplate());
            APITest.assertNotNull((Object)task.getGroup());
            APITest.assertNotNull((Object)task.getProviderId());
            APITest.assertNotNull((Object)task.getTitleId());
        }
    }

    @Test(enabled=false)
    public void invalidCall() throws IOException {
        Templates client = new API("http://localhost:8081/workflow/").templates();
        client.query().id("fsgsdf");
        TemplateListResponse response = null;
        try {
            response = client.execute();
        }
        catch (APIException e) {
            System.out.println(e.getErrorMessage());
            System.out.println(e.getStatusCode());
        }
    }
}

