/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.api;

import com.google.common.collect.Lists;
import com.tandbergtv.workflow.api.AbstractClientRequest;
import com.tandbergtv.workflow.api.Converters;
import com.tandbergtv.workflow.api.model.process.Process;
import com.tandbergtv.workflow.api.model.process.ProcessListResponse;
import com.tandbergtv.workflow.api.model.process.ProcessQueryBuilder;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class Processes
extends AbstractClientRequest<ProcessListResponse> {
    private String baseUrl;
    private ProcessQueryBuilder query;

    Processes(String baseUrl) {
        this.baseUrl = baseUrl;
        this.query = new ProcessQueryBuilder(this.baseUrl);
    }

    public ProcessQueryBuilder query() {
        return this.query;
    }

    @Override
    public ProcessListResponse execute() throws IOException {
        Map<String, Object> map = this.request();
        List<Process> items = this.getItems((List)map.get("processes"));
        return new ProcessListResponse(items, this.getTotal(), this.getCount());
    }

    @Override
    protected URL url() throws IOException {
        return new URL(this.query.build());
    }

    private List<Process> getItems(List<Map<String, Object>> response) {
        return Lists.transform(response, Converters.forProcess());
    }
}

