/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.api;

import com.google.common.collect.Lists;
import com.tandbergtv.workflow.api.AbstractClientRequest;
import com.tandbergtv.workflow.api.Converters;
import com.tandbergtv.workflow.api.model.process.Task;
import com.tandbergtv.workflow.api.model.process.TaskListResponse;
import com.tandbergtv.workflow.api.model.process.TaskQueryBuilder;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class Tasks
extends AbstractClientRequest<TaskListResponse> {
    private String baseUrl;
    private TaskQueryBuilder query;

    Tasks(String baseUrl) {
        this.baseUrl = baseUrl;
        this.query = new TaskQueryBuilder(this.baseUrl);
    }

    public TaskQueryBuilder query() {
        return this.query;
    }

    @Override
    public TaskListResponse execute() throws IOException {
        Map<String, Object> map = this.request();
        Integer total = this.getTotal();
        List list = (List)map.get("tasks");
        return new TaskListResponse(this.getItems(list), total);
    }

    @Override
    protected URL url() throws IOException {
        return new URL(this.query.build());
    }

    private List<Task> getItems(List<Map<String, Object>> response) {
        return Lists.transform(response, Converters.forTask());
    }
}

