/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.driver.event.ProcessLogEvent;
import com.tandbergtv.workflow.log.EventSerializer;
import com.tandbergtv.workflow.message.event.WorkflowMessageLogEvent;
import com.tandbergtv.workflow.resourcemanager.event.WorkflowProcessStatusLogEvent;
import java.util.concurrent.Callable;

public class LogEventListener
implements IColleague {
    private EventSerializer serializer;
    private ISchedulerService<Void> scheduler;

    public LogEventListener(EventSerializer serializer, int threads) {
        this.serializer = serializer;
        this.scheduler = new Scheduler("log-event-listener", threads, threads);
        this.scheduler.start();
    }

    public String getColleagueName() {
        return this.getClass().getName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.LOW;
    }

    public void receive(final WorkflowEvent event) {
        if (!(event instanceof WorkflowMessageLogEvent || event instanceof WorkflowProcessStatusLogEvent || event instanceof ProcessLogEvent)) {
            return;
        }
        this.scheduler.schedule((Callable)new Callable<Void>(){

            @Override
            public Void call() {
                if (event instanceof WorkflowMessageLogEvent) {
                    LogEventListener.this.serializer.serialize((WorkflowMessageLogEvent)event);
                } else if (event instanceof WorkflowProcessStatusLogEvent) {
                    LogEventListener.this.serializer.serialize((WorkflowProcessStatusLogEvent)event);
                } else if (event instanceof ProcessLogEvent) {
                    LogEventListener.this.serializer.serialize((ProcessLogEvent)event);
                }
                return null;
            }
        });
    }
}

