/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.command;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.IPersistenceService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.command.BaseTokenCommand;
import com.tandbergtv.workflow.driver.command.locate.TokenLocatorException;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.Token;

public class RetryCommand
extends BaseTokenCommand {
    private static final long serialVersionUID = 3370786140355139501L;
    private static final Logger LOGGER = Logger.getLogger(RetryCommand.class);

    public RetryCommand(WorkflowMessage message) {
        super(message);
    }

    @Override
    protected Token getToken() throws TokenLocatorException {
        long tokenId = Long.parseLong(this.message.getKey().toString());
        CustomToken token = ((IPersistenceService)ServiceRegistry.getDefault().lookup(IPersistenceService.class)).getToken((Serializable)Long.valueOf(tokenId));
        if (token == null) {
            throw new TokenLocatorException("Invalid request key " + tokenId);
        }
        if (!token.getProcessInstance().getCanBeRetried()) {
            throw new TokenLocatorException("Retry from status " + token.getStatus() + " is not allowed");
        }
        return token;
    }

    @Override
    protected WorkflowMessage executeImpl(Token token) {
        try {
            ((IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class)).resume((CustomToken)token);
        }
        catch (Exception e) {
            return this.createErrorResponse(e.getMessage());
        }
        return this.createSuccessResponse();
    }

    @Override
    public WorkflowMessage execute() {
        try {
            return this.executeImpl(this.getToken());
        }
        catch (TokenLocatorException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            this.logMessage(this.message);
            return this.createErrorResponse(e.getMessage());
        }
    }
}

