/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.graph;

import com.tandbergtv.workflow.core.AutomaticTaskNode;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.InvalidProcessStateException;
import com.tandbergtv.workflow.core.ManualTaskNode;
import com.tandbergtv.workflow.core.NodeGroup;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.graph.exe.Transitions;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.jpdl.xml.JpdlXmlReader;

public class Loop
extends SuperState {
    private static final long serialVersionUID = -2696666366298339153L;
    private String variable;
    private String index;
    private int initialValue;
    private String expression;
    private static final Logger LOGGER = Logger.getLogger(Loop.class);

    public Loop() {
    }

    public Loop(String name) {
        super(name);
    }

    public void read(Element element, JpdlXmlReader jpdlReader) {
        super.read(element, jpdlReader);
        this.variable = element.attributeValue("variable");
        this.index = element.attributeValue("index");
        if (this.index == null || this.index.isEmpty()) {
            jpdlReader.addError("Node " + this.name + " does not have an index variable");
        }
        this.initialValue = Integer.valueOf(element.attributeValue("initialValue", "0"));
        this.expression = element.attributeValue("expression");
        if (this.nodes == null || this.nodes.isEmpty()) {
            jpdlReader.addError("Node " + this.name + " does not have child nodes");
        }
        LOGGER.debug((Object)(this.index + " from " + this.initialValue + ", list " + this.variable + ", condition " + this.expression));
    }

    public void enter(ExecutionContext context) {
        CustomToken token = (CustomToken)context.getToken();
        if (token.getStatus() != ProcessStatus.RUNNING) {
            throw new InvalidProcessStateException(token.toString());
        }
        LOGGER.info((Object)(token + " (" + this.name + ")"));
        token.setNode((Node)this);
        context.setTransition(null);
        context.setTransitionSource(null);
        context.setVariable(this.index, (Object)this.initialValue);
        this.execute(context);
    }

    public void execute(ExecutionContext context) {
        CustomToken token = (CustomToken)context.getToken();
        if (token.getStatus() != ProcessStatus.RUNNING && token.getStatus() != ProcessStatus.BUSY) {
            throw new InvalidProcessStateException(token.toString());
        }
        LOGGER.info((Object)(token + " (" + this.name + ")"));
        while (token.getNode() != this || this.evaluateExpression(context)) {
            if (this.start(token) || token.isResuming()) {
                Node node = token.getNode() == this ? this.first() : token.getCurrentNode();
                Transition transition = Transitions.createArrivingTransition(node);
                if (transition == null) {
                    transition = (Transition)node.getArrivingTransitions().iterator().next();
                }
                context.setTransition(transition);
                transition.take(context);
            } else if (this.getNodeForEnter(context) != null) {
                this.getNodeForEnter(context).enter(context);
            } else {
                token.getNode().leave(context);
            }
            if (token.getStatus() != ProcessStatus.RUNNING) break;
            this.incrementIndex(context);
            token.setNode((Node)this);
        }
        if (token.getStatus() == ProcessStatus.RUNNING) {
            this.leave(context);
        }
    }

    public void leave(ExecutionContext context, Transition transition) {
        if (this != context.getNode()) {
            LOGGER.warn((Object)(context.getToken() + " " + context.getToken().getNode()));
        }
        LOGGER.info((Object)(context.getToken() + " (" + this.name + ")"));
        context.getToken().setNodeEnter(null);
        super.leave(context, transition);
    }

    public Transition getDefaultLeavingTransition() {
        Transition leaving = Transitions.createDefaultLeavingTransition((Node)this);
        if (leaving != null) {
            return leaving;
        }
        return super.getDefaultLeavingTransition();
    }

    protected Node getNodeForEnter(ExecutionContext context) {
        CustomToken token = (CustomToken)context.getToken();
        Node node = token.getNode();
        if (node.getSuperState() instanceof NodeGroup) {
            return node.getSuperState();
        }
        ProcessStatus status = token.getStatus();
        if (node instanceof AutomaticTaskNode || node instanceof ManualTaskNode && status != ProcessStatus.BUSY) {
            return node;
        }
        return null;
    }

    public Node first() {
        for (Object obj : this.nodes) {
            Node node = (Node)obj;
            if (node.getArrivingTransitions() != null && !node.getArrivingTransitions().isEmpty()) continue;
            return node;
        }
        throw new JbpmException(this.name + " has no nodes to delegate execution");
    }

    protected boolean start(Token token) {
        return token.getNode() == this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementIndex(ExecutionContext context) {
        Number i;
        WorkflowProcess process = (WorkflowProcess)context.getProcessInstance();
        process.lock();
        try {
            i = (Number)context.getVariable(this.index);
            context.setVariable(this.index, (Object)(i.intValue() + 1));
        }
        finally {
            process.unlock();
        }
        LOGGER.debug((Object)(context.getToken() + ", " + this.index + " = " + (i.intValue() + 1)));
    }

    protected boolean evaluateExpression(ExecutionContext context) {
        LOGGER.debug((Object)("Expression " + this.expression));
        return Boolean.parseBoolean(JbpmExpressionEvaluator.evaluate((String)this.expression, (ExecutionContext)context).toString());
    }
}

