/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.internal;

import com.tandbergtv.workflow.core.Selector;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.core.service.internal.ReplicatedCompositeCache;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.template.event.TemplateEvent;
import com.tandbergtv.workflow.driver.template.event.TemplateEvents;
import com.tandbergtv.workflow.driver.template.internal.FinderException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.jdbc.Work;

public class TemplateDAO {
    private ICacheService<WorkflowTemplate> cache;
    private SessionFactory factory;
    private static final String UPDATE_STATEMENT = "update JBPM_PROCESSDEFINITION set PROCESSDEFINITIONTYPEID = 1 where ID_ = ";
    private static final String ROLLBACK_STATEMENT = "update JBPM_PROCESSDEFINITION set PROCESSDEFINITIONTYPEID = 2 where ID_= ";
    private static final Logger LOGGER = Logger.getLogger(TemplateDAO.class);

    public TemplateDAO(SessionFactory factory, String name, int size) {
        this.factory = factory;
        this.cache = new ReplicatedCompositeCache(name, size);
    }

    public ICacheService<WorkflowTemplate> getCache() {
        return this.cache;
    }

    public void load() {
        if (this.getCache().count() > 0) {
            return;
        }
        List templates = new ArrayList();
        Session session = null;
        try {
            session = this.getSession();
            templates = session.createCriteria(WorkflowTemplate.class).list();
        }
        finally {
            this.closeSession(session);
        }
        Collections.sort(templates, new Comparator<WorkflowTemplate>(){

            @Override
            public int compare(WorkflowTemplate o1, WorkflowTemplate o2) {
                return o1.getCreateDate().compareTo(o2.getCreateDate());
            }
        });
        LOGGER.debug((Object)"Loading cache...");
        for (WorkflowTemplate template : templates) {
            this.cache(template);
        }
    }

    public List<WorkflowTemplate> findAll() {
        ArrayList<WorkflowTemplate> templates = new ArrayList<WorkflowTemplate>();
        for (Serializable key : this.getCache().getKeys()) {
            templates.add((WorkflowTemplate)this.getCache().get(key));
        }
        return templates;
    }

    public WorkflowTemplate findByKey(Serializable id) {
        return (WorkflowTemplate)this.getCache().get(id);
    }

    public void create(WorkflowTemplate template) throws DriverException {
        WorkflowTemplate previous = this.getLatestTemplate(template.getName());
        Session session = null;
        Transaction t = null;
        try {
            session = this.getSession();
            t = session.beginTransaction();
            if (previous != null) {
                for (Selector selector : previous.getSelectorKeys()) {
                    template.addSelectorKey(new Selector(selector.getSelectionKey(), template));
                    LOGGER.info((Object)(template + ", added selector " + selector));
                }
                previous.removeSelectorKeys();
                session.saveOrUpdate((Object)previous);
                session.flush();
            }
            session.saveOrUpdate((Object)template);
            session.flush();
            session.refresh((Object)template);
            t.commit();
            LOGGER.info((Object)("Saved template " + template));
            this.fireEvent(template, TemplateEvents.CREATED);
            this.cache(template);
        }
        catch (Exception e) {
            if (t != null) {
                t.rollback();
            }
            throw new DriverException("Failed to create template " + template, e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void update(WorkflowTemplate template) throws DriverException {
        Session session = null;
        Transaction t = null;
        try {
            session = this.getSession();
            t = session.beginTransaction();
            session.saveOrUpdate((Object)template);
            t.commit();
            LOGGER.debug((Object)("Updated template " + template));
            this.cache(template);
            this.fireEvent(template, TemplateEvents.UPDATED);
        }
        catch (Exception e) {
            if (t != null) {
                t.rollback();
            }
            throw new DriverException("Failed to update template " + template, e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void delete(final WorkflowTemplate template) throws DriverException {
        LOGGER.info((Object)("Deleting template " + template));
        Session session = null;
        Transaction t = null;
        try {
            session = this.getSession();
            t = session.beginTransaction();
            session.doWork(new Work(){

                public void execute(Connection connection) throws SQLException {
                    Statement statement = connection.createStatement();
                    statement.executeUpdate(TemplateDAO.UPDATE_STATEMENT + template.getId());
                }
            });
            t.commit();
            this.remove(template);
            this.fireEvent(template, TemplateEvents.DELETED);
        }
        catch (Exception e) {
            if (t != null) {
                t.rollback();
            }
            throw new DriverException("Failed to delete template " + template, e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public WorkflowTemplate rollback(String name, int version, final Long currentId, final Long lastVersionId, WorkflowTemplate currentActiveTemplate) throws DriverException, FinderException {
        Session session = null;
        Transaction t = null;
        WorkflowTemplate rolledBackTemplate = null;
        try {
            session = this.getSession();
            t = session.beginTransaction();
            session.doWork(new Work(){

                public void execute(Connection connection) throws SQLException {
                    PreparedStatement upateStatement = connection.prepareStatement(TemplateDAO.UPDATE_STATEMENT + currentId);
                    PreparedStatement rollbackStatement = connection.prepareStatement(TemplateDAO.ROLLBACK_STATEMENT + lastVersionId);
                    upateStatement.executeUpdate();
                    rollbackStatement.executeUpdate();
                }
            });
            session.flush();
            rolledBackTemplate = this.getRolledBackTemplate(lastVersionId, session);
            if (currentActiveTemplate != null && !currentActiveTemplate.getSelectorKeys().isEmpty()) {
                for (Selector selector : currentActiveTemplate.getSelectorKeys()) {
                    rolledBackTemplate.addSelectorKey(new Selector(selector.getSelectionKey(), rolledBackTemplate));
                    LOGGER.info((Object)(rolledBackTemplate + ", added selector " + selector));
                }
                currentActiveTemplate.removeSelectorKeys();
                session.saveOrUpdate((Object)currentActiveTemplate);
                session.flush();
                session.saveOrUpdate((Object)rolledBackTemplate);
                session.flush();
            }
            session.refresh((Object)rolledBackTemplate);
            t.commit();
            LOGGER.info((Object)("Rolledback to template " + rolledBackTemplate));
            if (this.getCache().get((Serializable)Long.valueOf(rolledBackTemplate.getId())) == null) {
                this.cache(rolledBackTemplate);
            }
            this.remove(currentActiveTemplate);
        }
        catch (Exception e) {
            if (t != null) {
                t.rollback();
            }
            throw new DriverException("Failed to activate template " + name, e);
        }
        finally {
            this.closeSession(session);
        }
        return rolledBackTemplate;
    }

    private WorkflowTemplate getLatestTemplate(String name) {
        List<WorkflowTemplate> templates = this.findAll();
        Collections.sort(templates, new TemplateComparator());
        for (WorkflowTemplate template : templates) {
            if (!name.equals(template.getName())) continue;
            return template;
        }
        return null;
    }

    private void cache(WorkflowTemplate template) {
        LOGGER.debug((Object)("Adding to cache " + template));
        this.getCache().add((Serializable)Long.valueOf(template.getId()), (Object)template);
        this.fireEvent(template, TemplateEvents.CACHED);
    }

    private void remove(WorkflowTemplate template) {
        LOGGER.debug((Object)("Removing from cache " + template));
        this.getCache().remove((Serializable)Long.valueOf(template.getId()));
    }

    private void fireEvent(WorkflowTemplate template, TemplateEvents e) {
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)new TemplateEvent(this, template, e));
    }

    private Session getSession() {
        return this.factory.openSession();
    }

    private void closeSession(Session session) {
        if (session != null) {
            session.close();
        }
    }

    private WorkflowTemplate getRolledBackTemplate(Long id, Session session) {
        return (WorkflowTemplate)session.get(WorkflowTemplate.class, (Serializable)id);
    }

    public Long getPreviousVersionTemplateId(String name, int version, Date createDate) throws DriverException, FinderException {
        Session session = null;
        Transaction t = null;
        long rollbackId = 0L;
        try {
            session = this.getSession();
            t = session.beginTransaction();
            String query = "Select pd.id_ as id, pd.version_ as version from JBPM_PROCESSDEFINITION pd where pd.name_='" + name + "' and pd.createDate < '" + createDate + "' and pd.version_ < " + version + " Order By pd.createdate desc";
            HashMap<Long, Long> idVersions = new HashMap<Long, Long>();
            SQLQuery templateQuery = session.createSQLQuery(query);
            List tRes = templateQuery.list();
            if (tRes.size() < 1) {
                throw new FinderException("Previous inactive versions of the template: " + name + " doesn't exist.");
            }
            rollbackId = ((BigDecimal)((Object[])tRes.get(0))[0]).longValue();
            long rollbackVersion = ((BigDecimal)((Object[])tRes.get(0))[1]).longValue();
            for (Object[] objectArray : tRes) {
                idVersions.put(((BigDecimal)objectArray[0]).longValue(), ((BigDecimal)objectArray[1]).longValue());
            }
            for (Map.Entry entry : idVersions.entrySet()) {
                if (((Long)entry.getKey()).equals(rollbackId) || !((Long)entry.getValue()).equals(rollbackVersion)) continue;
                rollbackId = 0L;
            }
        }
        catch (Exception e) {
            if (t != null) {
                t.rollback();
            }
            throw new DriverException("Failed to activate template " + name, e);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return rollbackId;
    }

    public Long getTemplateIdByVersion(String name, int version, Date createDate) throws DriverException, FinderException {
        Session session = null;
        Transaction t = null;
        long rollbackId = 0L;
        try {
            session = this.getSession();
            t = session.beginTransaction();
            String query = "Select pd.id_ as id from JBPM_PROCESSDEFINITION pd where pd.name_='" + name + "' and pd.version_=" + version;
            SQLQuery templateQuery = session.createSQLQuery(query);
            List tRes = templateQuery.list();
            if (tRes.size() > 1) {
                throw new DriverException("Multiple template exists with version: " + version);
            }
            if (tRes.size() < 1) {
                throw new FinderException("Template with version " + version + " doesn't exist.");
            }
            rollbackId = ((BigDecimal)tRes.get(0)).longValue();
        }
        catch (Exception e) {
            if (t != null) {
                t.rollback();
            }
            throw new DriverException("Failed to activate template " + name, e);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return rollbackId;
    }

    public class TemplateComparator
    implements Comparator<WorkflowTemplate> {
        @Override
        public int compare(WorkflowTemplate t1, WorkflowTemplate t2) {
            if (t1.getName().equals(t2.getName())) {
                return t2.getVersion() - t1.getVersion();
            }
            return t1.getName().compareTo(t2.getName());
        }
    }
}

