/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.driver.internal.CustomTokenSequenceIdGenerator;
import com.tandbergtv.workflow.driver.internal.DBSequenceIdentityGenerator;
import com.tandbergtv.workflow.driver.internal.IEntityIdGenerator;
import com.tandbergtv.workflow.driver.internal.ISequenceIdGenerator;
import com.tandbergtv.workflow.driver.internal.IdGeneratorTimerImpl;
import com.tandbergtv.workflow.driver.internal.ProcessSequenceIdGenerator;
import com.tandbergtv.workflow.driver.internal.TaskInstanceSequenceIdGenerator;
import com.tandbergtv.workflow.driver.internal.TemplateSequenceIdGenerator;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.SessionFactory;

public class IdGeneratorFactory {
    private static IEntityIdGenerator generator;
    private static DBSequenceIdentityGenerator processSequenceIdGenerator;
    private static DBSequenceIdentityGenerator templateSequenceIdGenerator;
    private static DBSequenceIdentityGenerator customTokenSequenceIdGenerator;
    private static DBSequenceIdentityGenerator taskInstanceIdGenerator;
    private static List<DBSequenceIdentityGenerator> binds;

    public static IEntityIdGenerator create() {
        return generator;
    }

    public static void registerGenerator(IEntityIdGenerator generator) {
        IdGeneratorFactory.generator = generator;
    }

    public static ISequenceIdGenerator createProcessIdGenerator() {
        return (ISequenceIdGenerator)((Object)processSequenceIdGenerator);
    }

    public static void setSessionFactory(SessionFactory factory) {
        for (DBSequenceIdentityGenerator generator : binds) {
            generator.setSessionFactory(factory);
        }
    }

    public static ISequenceIdGenerator createTemplateIdGenerator() {
        return (ISequenceIdGenerator)((Object)templateSequenceIdGenerator);
    }

    public static ISequenceIdGenerator createCustomTokenIdGenerator() {
        return (ISequenceIdGenerator)((Object)customTokenSequenceIdGenerator);
    }

    public static ISequenceIdGenerator createTaskInstanceIdGenerator() {
        return (ISequenceIdGenerator)((Object)taskInstanceIdGenerator);
    }

    static {
        binds = new ArrayList<DBSequenceIdentityGenerator>();
        generator = new IdGeneratorTimerImpl();
        processSequenceIdGenerator = new ProcessSequenceIdGenerator();
        templateSequenceIdGenerator = new TemplateSequenceIdGenerator();
        customTokenSequenceIdGenerator = new CustomTokenSequenceIdGenerator();
        taskInstanceIdGenerator = new TaskInstanceSequenceIdGenerator();
        binds.add(processSequenceIdGenerator);
        binds.add(templateSequenceIdGenerator);
        binds.add(customTokenSequenceIdGenerator);
        binds.add(taskInstanceIdGenerator);
    }
}

