/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.tandbergtv.workflow.core.CurrentNodeVisitor;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.Datatype;
import com.tandbergtv.workflow.core.SimpleComment;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.entity.CustomTokenDTO;
import com.tandbergtv.workflow.core.entity.TaskInstanceDTO;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import com.tandbergtv.workflow.core.graph.exe.ListVariableInstance;
import com.tandbergtv.workflow.core.util.Configuration;
import com.tandbergtv.workflow.core.util.JsonObjectMapper;
import com.tandbergtv.workflow.core.util.Reflection;
import com.tandbergtv.workflow.driver.internal.ISequenceIdGenerator;
import com.tandbergtv.workflow.driver.internal.TaskInstanceConvertor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.context.exe.TokenVariableMap;
import org.jbpm.context.exe.VariableInstance;
import org.jbpm.context.exe.variableinstance.ByteArrayInstance;
import org.jbpm.context.exe.variableinstance.DateInstance;
import org.jbpm.context.exe.variableinstance.DoubleInstance;
import org.jbpm.context.exe.variableinstance.LongInstance;
import org.jbpm.context.exe.variableinstance.NullInstance;
import org.jbpm.context.exe.variableinstance.StringInstance;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Comment;
import org.jbpm.graph.exe.Token;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class CustomTokenConvertor {
    private static final String VARIABLE_TYPE = "type";
    private static final String VARIABLE_VALUE = "value";
    private final Logger logger = Logger.getLogger(CustomTokenConvertor.class);
    private TaskInstanceConvertor taskInstanceConvertor;
    private ISequenceIdGenerator idGenerator;

    public CustomTokenConvertor(ISequenceIdGenerator idGenerator, TaskInstanceConvertor taskInstanceConvertor) {
        this.idGenerator = idGenerator;
        this.taskInstanceConvertor = taskInstanceConvertor;
    }

    public CustomTokenDTO toCustomTokenDTO(CustomToken token) {
        CustomTokenDTO dto = new CustomTokenDTO();
        this.setDTOTokenId(token, dto);
        dto.setParentTokenId(token.getParentTokenIdForSubprocess());
        this.convertCommonDTOFields(token, dto);
        return dto;
    }

    private void setDTOTokenId(CustomToken token, CustomTokenDTO dto) {
        long tokenId = token.getId();
        if (token.isNew()) {
            tokenId = this.idGenerator.queryId();
            token.setId(tokenId);
            this.logger.debug((Object)("CustomToken ID generated: " + tokenId));
        }
        dto.setTokenId(tokenId);
    }

    public CustomTokenDTO toChildCustomTokenDTO(CustomToken token) {
        CustomTokenDTO dto = new CustomTokenDTO();
        this.setDTOTokenId(token, dto);
        dto.setParentTokenId(token.getParentTokenIdForChild());
        this.convertCommonDTOFields(token, dto);
        return dto;
    }

    private void convertCommonDTOFields(CustomToken token, CustomTokenDTO dto) {
        if (!token.isNew()) {
            dto.setTokenId(token.getId());
        }
        dto.setProcessId(token.getProcessInstance().getId());
        dto.setTokenName(token.getName());
        dto.setCurrentNodeName(token.getNode().getName());
        dto.setVars(this.getVarsFromCustomToken(token));
        dto.setOperationalStatus(token.getStatus());
        dto.setAdminStatus(token.getRequestedStatus());
        dto.setComments(this.convertComments(token.getComments()));
        dto.setStartTime(token.getStart());
        dto.setEndTime(token.getEnd());
        List<TaskInstanceDTO> taskInstanceDTOs = this.taskInstanceConvertor.findManualTaskInstances(token);
        dto.setTaskInstances(taskInstanceDTOs);
    }

    public String convertComments(List<Comment> comments) {
        if (CollectionUtils.isEmpty(comments)) {
            return null;
        }
        List simpleComments = Lists.transform(comments, (Function)new Function<Comment, SimpleComment>(){

            public SimpleComment apply(Comment comment) {
                SimpleComment simpleComment = new SimpleComment();
                simpleComment.setCommentType(comment.getActorId());
                simpleComment.setTime(comment.getTime());
                simpleComment.setMessage(comment.getMessage());
                return simpleComment;
            }
        });
        String jsonComments = null;
        try {
            jsonComments = new ObjectMapper().writeValueAsString((Object)simpleComments);
        }
        catch (IOException e) {
            this.logger.error((Object)"errors in convert CustomToken Comments to Json: ", (Throwable)e);
        }
        return jsonComments;
    }

    public List<Comment> convertComments(String jsonComments) {
        if (StringUtils.isBlank((String)jsonComments)) {
            return Collections.emptyList();
        }
        List simpleComments = (List)JsonObjectMapper.toList((String)jsonComments, SimpleComment.class);
        List comments = Lists.transform((List)simpleComments, (Function)new Function<SimpleComment, Comment>(){

            public Comment apply(SimpleComment simpleComment) {
                Comment comment = new Comment(simpleComment.getCommentType(), simpleComment.getMessage());
                Reflection.reflectSetProtectedFieldValue((Object)simpleComment.getTime(), (Object)comment, (String)"time");
                return comment;
            }
        });
        return comments;
    }

    public String getVarsFromCustomToken(CustomToken token) {
        WorkflowProcess processInstance = token.getProcessInstance();
        ContextInstance contextInstance = processInstance.getContextInstance();
        String valueReslut = null;
        TokenVariableMap tokenVariableMap = contextInstance.getTokenVariableMap((Token)token);
        if (tokenVariableMap != null) {
            Map variableInstanceMap = tokenVariableMap.getVariableInstances();
            valueReslut = this.tokenVarToJsonString(variableInstanceMap.values());
        }
        return valueReslut;
    }

    public String tokenVarToJsonString(Collection<VariableInstance> vars) {
        if (CollectionUtils.isEmpty(vars)) {
            return null;
        }
        LinkedHashMap<String, Map<String, Object>> convertedVars = new LinkedHashMap<String, Map<String, Object>>();
        for (VariableInstance var : vars) {
            String varName = var.getName();
            Map<String, Object> typeAndValue = this.getVarTypeAndValue(var);
            if (typeAndValue != null) {
                convertedVars.put(varName, typeAndValue);
                continue;
            }
            this.logger.warn((Object)("UNKNOWN TYPE OF THE VARIABLE:" + varName));
        }
        return JsonObjectMapper.toJsonString(convertedVars);
    }

    private Map<String, Object> getVarTypeAndValue(VariableInstance variableInstance) {
        String value = null;
        Datatype type = null;
        Object originalValue = variableInstance.getValue();
        if (variableInstance instanceof NullInstance) {
            type = Datatype.NULL;
        } else if (variableInstance instanceof StringInstance) {
            type = originalValue instanceof Boolean ? Datatype.BOOLEAN : Datatype.STRING;
            value = ObjectUtils.toString((Object)originalValue, null);
        } else if (variableInstance instanceof LongInstance) {
            type = Datatype.LONG;
            value = ObjectUtils.toString((Object)originalValue, null);
        } else if (variableInstance instanceof DoubleInstance) {
            type = Datatype.DOUBLE;
            value = ObjectUtils.toString((Object)originalValue, null);
        } else if (variableInstance instanceof DateInstance) {
            type = Datatype.DATE;
            if (originalValue != null) {
                Date date = (Date)originalValue;
                long timeStamp = date.getTime();
                value = Long.toString(timeStamp);
            }
        } else if (variableInstance instanceof ListVariableInstance || variableInstance instanceof ByteArrayInstance) {
            type = Datatype.LIST;
            value = this.joinListValue(originalValue);
        }
        HashMap<String, String> typeAndValue = null;
        if (type != null) {
            typeAndValue = new HashMap<String, String>();
            typeAndValue.put(VARIABLE_TYPE, type.toString());
            typeAndValue.put(VARIABLE_VALUE, value);
        }
        return typeAndValue;
    }

    private String joinListValue(Object object) {
        return object != null ? "[" + StringUtils.join((Collection)((List)object), (String)",") + "]" : null;
    }

    public void refillVariableInstance(WorkflowProcess process, CustomTokenDTO customTokenDto) {
        String jsonVar = customTokenDto.getVars();
        ContextInstance contextInstance = process.getContextInstance();
        Map denormalizedVars = JsonObjectMapper.toMap((String)jsonVar);
        CustomToken rootToken = process.getRootToken();
        TokenVariableMap tokenVariableMap = contextInstance.getOrCreateTokenVariableMap((Token)rootToken);
        for (Map.Entry<String, Object> entry : denormalizedVars.entrySet()) {
            VariableInstance variableInstance = this.getVariableInstance(entry, rootToken);
            if (variableInstance == null) continue;
            tokenVariableMap.addVariableInstance(variableInstance);
        }
    }

    private VariableInstance getVariableInstance(Map.Entry<String, Object> entry, CustomToken customToken) {
        String name = entry.getKey();
        Map valueMap = (Map)entry.getValue();
        String mapType = (String)valueMap.get(VARIABLE_TYPE);
        String mapValue = (String)valueMap.get(VARIABLE_VALUE);
        VariableInstance variableInstance = this.decideVariableInstance(mapType);
        if (variableInstance == null) {
            this.logger.warn((Object)("UNKNOWN TYPE OF TYPE:" + mapType));
            return null;
        }
        Reflection.reflectSetProtectedFieldValue((Object)name, (Object)variableInstance, (String)"name");
        Reflection.reflectSetProtectedFieldValue((Object)customToken, (Object)variableInstance, (String)"token");
        if (mapValue == null) {
            variableInstance.setValue((Object)mapValue);
            return variableInstance;
        }
        Object convertedValue = mapValue;
        if (variableInstance instanceof ListVariableInstance) {
            convertedValue = Configuration.toStringList((String)mapValue);
        } else if (variableInstance instanceof DateInstance) {
            convertedValue = new Date(Long.valueOf(mapValue));
        } else if (variableInstance instanceof StringInstance) {
            if (mapType.equalsIgnoreCase(Datatype.BOOLEAN.toString())) {
                convertedValue = BooleanUtils.toBoolean((String)mapValue);
            }
        } else if (variableInstance instanceof LongInstance) {
            convertedValue = Long.valueOf(mapValue);
        } else if (variableInstance instanceof DoubleInstance) {
            convertedValue = Double.valueOf(mapValue);
        }
        variableInstance.setValue(convertedValue);
        return variableInstance;
    }

    private VariableInstance decideVariableInstance(String mapType) {
        NullInstance instance = null;
        if (StringUtils.equalsIgnoreCase((String)mapType, (String)Datatype.NULL.toString())) {
            instance = new NullInstance();
        } else if (StringUtils.equalsIgnoreCase((String)mapType, (String)Datatype.STRING.toString())) {
            instance = new StringInstance();
        } else if (StringUtils.equalsIgnoreCase((String)mapType, (String)Datatype.BOOLEAN.toString())) {
            instance = VariableInstance.createVariableInstance((Object)false);
        } else if (StringUtils.equalsIgnoreCase((String)mapType, (String)Datatype.LONG.toString())) {
            instance = new LongInstance();
        } else if (StringUtils.equalsIgnoreCase((String)mapType, (String)Datatype.DATE.toString())) {
            instance = new DateInstance();
        } else if (StringUtils.equalsIgnoreCase((String)mapType, (String)Datatype.DOUBLE.toString())) {
            instance = new DoubleInstance();
        } else if (StringUtils.equalsIgnoreCase((String)mapType, (String)Datatype.LIST.toString())) {
            instance = new ListVariableInstance();
        }
        return instance;
    }

    public void refillProcess(CustomTokenDTO customTokenDto, WorkflowProcess process) {
        Assert.notNull((Object)customTokenDto, (String)"CustomTokenDTO cannot be null");
        Assert.notNull((Object)process, (String)"WorkflowProcess cannot be null");
        process.setStatus(customTokenDto.getOperationalStatus());
        process.setRequestedStatus(customTokenDto.getAdminStatus());
        this.refillVariableInstance(process, customTokenDto);
    }

    public Node findCurrentNode(WorkflowTemplate template, String nodeName) {
        CurrentNodeVisitor visitor = new CurrentNodeVisitor(nodeName);
        template.greedyBreadthFirstTraversal((NodeVisitor)visitor);
        return visitor.getCurrentNode();
    }

    public void refillCustomToken(CustomTokenDTO customTokenDto, CustomToken customToken) {
        customToken.setId(customTokenDto.getTokenId());
        customToken.setStatus(customTokenDto.getOperationalStatus());
        customToken.setRequestedStatus(customTokenDto.getAdminStatus());
        customToken.setStart(customTokenDto.getStartTime());
        customToken.setEnd(customTokenDto.getEndTime());
        WorkflowTemplate template = customToken.getProcessInstance().getProcessDefinition();
        customToken.setNode(this.findCurrentNode(template, customTokenDto.getCurrentNodeName()));
        this.taskInstanceConvertor.rebuildManualTasks(customToken, customTokenDto.getTaskInstances());
        this.refillComment(customTokenDto, customToken);
    }

    private void refillComment(CustomTokenDTO customTokenDto, CustomToken customToken) {
        List<Comment> comments = this.convertComments(customTokenDto.getComments());
        for (Comment comment : comments) {
            customToken.addComment(comment);
        }
    }

    public List<CustomToken> convertChildTokens(List<CustomTokenDTO> children, CustomToken rootToken) {
        ArrayList<CustomToken> childTokens = new ArrayList<CustomToken>();
        for (CustomTokenDTO childDto : children) {
            CustomToken childToken = new CustomToken(rootToken, childDto.getTokenName());
            this.refillCustomToken(childDto, childToken);
            childTokens.add(childToken);
        }
        return childTokens;
    }

    public void setIdGenerator(ISequenceIdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public Object getValueByDataType(Map<String, String> valueMap) {
        String mapType = valueMap.get(VARIABLE_TYPE);
        String mapValue = valueMap.get(VARIABLE_VALUE);
        if (mapValue == null) {
            return null;
        }
        Object value = null;
        if (StringUtils.equalsIgnoreCase((String)mapType, (String)Datatype.STRING.toString())) {
            value = String.valueOf(mapValue);
        } else if (StringUtils.equalsIgnoreCase((String)mapType, (String)Datatype.LONG.toString())) {
            value = Long.valueOf(mapValue);
        } else if (StringUtils.equalsIgnoreCase((String)mapType, (String)Datatype.DATE.toString())) {
            value = new Date(Long.valueOf(mapValue));
        } else if (StringUtils.equalsIgnoreCase((String)mapType, (String)Datatype.DOUBLE.toString())) {
            value = Double.valueOf(mapValue);
        } else if (StringUtils.equalsIgnoreCase((String)mapType, (String)Datatype.LIST.toString())) {
            value = Configuration.toStringList((String)mapValue);
        } else if (StringUtils.equalsIgnoreCase((String)mapType, (String)Datatype.BOOLEAN.toString())) {
            value = Boolean.valueOf(mapValue);
        }
        return value;
    }
}

