/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.tandbergtv.workflow.core.IPersistenceService;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.internal.ConvertorFactory;
import com.tandbergtv.workflow.driver.internal.CustomTokenDTOService;
import com.tandbergtv.workflow.driver.internal.IWorkOrderLoader;
import com.tandbergtv.workflow.driver.internal.JBPMPersistenceService;
import com.tandbergtv.workflow.driver.internal.ProcessPersistenceService;
import com.tandbergtv.workflow.driver.internal.TaskInstanceDTOService;
import com.tandbergtv.workflow.driver.internal.WorkOrderLoaderAdaptor;
import com.tandbergtv.workflow.driver.internal.WorkflowProcessDTOService;
import com.tandbergtv.workflow.driver.process.WorkflowProcessCache;
import com.tandbergtv.workflow.driver.service.ITaskInstanceDTOService;
import com.tandbergtv.workflow.driver.template.ITemplateService;
import com.tandbergtv.workflow.driver.template.TemplateCache;
import com.tandbergtv.workflow.driver.template.TemplateService;
import org.hibernate.SessionFactory;

public class PersistenceServiceFactory {
    public static ProcessPersistenceService createPersistenceService(SessionFactory sessionFactory) {
        ProcessPersistenceService persistenceService = new ProcessPersistenceService(sessionFactory);
        persistenceService.setProcessDtoService(new WorkflowProcessDTOService(sessionFactory));
        persistenceService.setCustomTokenDtoService(new CustomTokenDTOService(sessionFactory));
        persistenceService.setTaskInstanceDTOService(new TaskInstanceDTOService(sessionFactory));
        persistenceService.setProcessCache((WorkflowProcessCache)ServiceRegistry.getDefault().lookup("Process Cache"));
        persistenceService.setCustomTokenConvertor(ConvertorFactory.createCustomTokenConvertor(sessionFactory));
        persistenceService.setProcessConvertor(ConvertorFactory.createProcessConvertor(sessionFactory));
        persistenceService.setTaskInstanceConvertor(ConvertorFactory.createTaskInstanceConvertor());
        persistenceService.setClusterService((IClusterService)ServiceRegistry.getDefault().lookup(IClusterService.class));
        persistenceService.setMediator(DefaultMediator.getInstance());
        return persistenceService;
    }

    public static IWorkOrderLoader createWorkOrderLoader(IPersistenceService persistenceService, SessionFactory factory) {
        return new WorkOrderLoaderAdaptor(new JBPMPersistenceService(factory), (ProcessPersistenceService)persistenceService);
    }

    public static ITaskInstanceDTOService createTaskInstanceService(SessionFactory sessionFactory) {
        return new TaskInstanceDTOService(sessionFactory);
    }

    public static ITemplateService createTemplateService(SessionFactory factory, TemplateCache templateCache) {
        return new TemplateService(templateCache, factory, ConvertorFactory.createTemplateConvertor());
    }
}

