/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search;

import com.tandbergtv.workflow.core.ProcessStatus;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TokenStatusConvertor {
    private static ProcessStatus[] processStatusArray = new ProcessStatus[]{ProcessStatus.CREATED, ProcessStatus.RUNNING, ProcessStatus.ERROR, ProcessStatus.PAUSED, ProcessStatus.QUEUED, ProcessStatus.CANCELLED, ProcessStatus.COMPLETED, ProcessStatus.BUSY, ProcessStatus.BRANCHED};
    private static Map<ProcessStatus, Integer> processStatusMap = new EnumMap<ProcessStatus, Integer>(ProcessStatus.class);

    public static String getStatusPredicate(List<Object> tokenStatus) {
        ArrayList<Integer> statusParams = new ArrayList<Integer>();
        for (Object obj : tokenStatus) {
            String status = obj.toString();
            if (ProcessStatus.ACTIVE.toString().equals(status)) {
                statusParams.add(0);
                statusParams.add(1);
                statusParams.add(7);
                continue;
            }
            statusParams.add(TokenStatusConvertor.getOrdinalFromStatus(status));
        }
        return StringUtils.join(statusParams, (String)",");
    }

    public static int getOrdinalFromStatus(String status) {
        ProcessStatus processStatus = ProcessStatus.valueOf((String)status.toUpperCase());
        Integer statusOrdinal = processStatusMap.get(processStatus);
        if (statusOrdinal != null) {
            return statusOrdinal;
        }
        throw new IllegalArgumentException(status);
    }

    public static ProcessStatus getStatusFromOrdinal(int statusOrdinal) {
        if (statusOrdinal < 0 || statusOrdinal > 8) {
            throw new IllegalArgumentException("statusOrdinal must be 0-8, but the argument is" + statusOrdinal);
        }
        return processStatusArray[statusOrdinal];
    }

    static {
        processStatusMap.put(ProcessStatus.CREATED, 0);
        processStatusMap.put(ProcessStatus.RUNNING, 1);
        processStatusMap.put(ProcessStatus.ERROR, 2);
        processStatusMap.put(ProcessStatus.PAUSED, 3);
        processStatusMap.put(ProcessStatus.QUEUED, 4);
        processStatusMap.put(ProcessStatus.CANCELLED, 5);
        processStatusMap.put(ProcessStatus.COMPLETED, 6);
        processStatusMap.put(ProcessStatus.BUSY, 7);
        processStatusMap.put(ProcessStatus.BRANCHED, 8);
    }
}

