/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.internal;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WFSearchResult;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.elasticsearch.IWFSElasticSearchPersistanceHelper;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.driver.template.IESDeleteService;
import com.tandbergtv.workflow.driver.template.ITemplateService;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ESProcessDeleteService
implements IESDeleteService {
    private static final Logger LOGGER = Logger.getLogger(ESProcessDeleteService.class);
    private static final String SERVICE_NAME = "es-process-deleter";
    private long period = TimeUnit.MINUTES.toMillis(5L);
    private long delay = TimeUnit.MINUTES.toMillis(5L);
    private static final int NUMBER_TO_DELETE = 500;
    private ISchedulerService<Void> scheduler = new Scheduler("es-process-deleter", 1, 1);
    private ICacheService<String> cache = (ICacheService)ServiceRegistry.getDefault().lookup("Delete Template Cache");
    private IClusterService clusterService;

    @Override
    public void start() {
        this.scheduler.start();
        this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                if (!ESProcessDeleteService.this.getClusterService().isMaster() || ESProcessDeleteService.this.cache.count() == 0) {
                    return;
                }
                ITemplateService templateService = (ITemplateService)ServiceRegistry.getDefault().lookup(ITemplateService.class);
                Object[] templateIds = ESProcessDeleteService.this.cache.getKeys().toArray(new Long[0]);
                List results = ESProcessDeleteService.this.search((Long[])templateIds, new ProcessStatus[]{ProcessStatus.COMPLETED, ProcessStatus.CANCELLED});
                LOGGER.info((Object)("Deleting " + results.size() + " processes from obsolete templates [ID:" + Arrays.toString(templateIds) + "]"));
                for (WFSearchResult result : results) {
                    result.setIsActive("false");
                    try {
                        ((IWFSElasticSearchPersistanceHelper)ServiceRegistry.getDefault().lookup(IWFSElasticSearchPersistanceHelper.class)).save(result);
                    }
                    catch (Exception exception) {}
                }
                for (Serializable key : ESProcessDeleteService.this.cache.getKeys()) {
                    long templateId = (Long)key;
                    if (ESProcessDeleteService.this.count(templateId) != 0) continue;
                    templateService.deactivate(templateId);
                    ESProcessDeleteService.this.cache.remove((Serializable)Long.valueOf(templateId));
                }
            }
        }, this.delay, this.period);
    }

    @Override
    public void stop() {
        this.scheduler.stop();
    }

    @Override
    public void addToCache(WorkflowTemplate oldTemplate) {
        LOGGER.debug((Object)("Adding template ID " + oldTemplate.getId() + ", Name " + oldTemplate.getFullName() + " to the cache"));
        this.cache.add((Serializable)Long.valueOf(oldTemplate.getId()), (Object)oldTemplate.getFullName());
    }

    private int count(long id) {
        SearchCriteria criteria = new SearchCriteria();
        this.template(criteria, new Long[]{id});
        this.count(criteria, 1);
        return ((IProcessSearchService)ServiceRegistry.getDefault().lookup(IProcessSearchService.class)).expressCount(criteria);
    }

    private List<WFSearchResult> search(Long[] templateIds, ProcessStatus ... status) {
        SearchCriteria criteria = new SearchCriteria();
        this.template(criteria, templateIds);
        this.count(criteria, 500);
        this.status(criteria, status);
        return ((IProcessSearchService)ServiceRegistry.getDefault().lookup(IProcessSearchService.class)).expressSearch(criteria);
    }

    private SearchCriteria count(SearchCriteria criteria, int count) {
        criteria.setRecordsCount(count);
        return criteria;
    }

    private SearchCriteria template(SearchCriteria criteria, Long[] templateIds) {
        ListParameter parameter = new ListParameter("templateId", SearchType.NUMERIC);
        for (Long templateId : templateIds) {
            parameter.addValue((Object)templateId);
        }
        criteria.addParameter((SearchParameterBase)parameter);
        return criteria;
    }

    private SearchCriteria status(SearchCriteria criteria, ProcessStatus ... status) {
        ListParameter parameter = new ListParameter("status", SearchType.PROCESSSTATUS);
        for (ProcessStatus s : status) {
            parameter.addValue((Object)s.toString());
        }
        criteria.addParameter((SearchParameterBase)parameter);
        return criteria;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    private IClusterService getClusterService() {
        if (this.clusterService == null) {
            this.clusterService = (IClusterService)ServiceRegistry.getDefault().lookup(IClusterService.class);
        }
        return this.clusterService;
    }
}

