/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.monitor;

import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.template.ITemplateService;
import com.tandbergtv.workflow.monitor.core.MetricSample;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;

public class ExecutionTimeMonitor
implements IColleague {
    private static final String MBEAN_NAME_CONTENT_PROCESSING = "com.tandbergtv.watchpoint:type=ExecutionTime,name=contentprocessing_wo_duration";
    private static final String MBEAN_NAME_DISTRIBUTION = "com.tandbergtv.watchpoint:type=ExecutionTime,name=distribution_wo_duration";
    private static final String MBEAN_NAME_TITLE_LIST_PROCESSING = "com.tandbergtv.watchpoint:type=ExecutionTime,name=titlelistprocessing_wo_duration";
    private static final String MBEAN_NAME_INGEST = "com.tandbergtv.watchpoint:type=ExecutionTime,name=ingest_wo_duration";
    public static final String ANNOTATION_DISTRIBUTION = "@Category(\"Distribution\")";
    public static final String ANNOTATION_CONTENT_PROCESSING = "@Category(\"ContentProcessing\")";
    public static final String ANNOTATION_LOCAL_PROCESSING = "@Category(\"LocalContentProcessing\")";
    public static final String ANNOTATION_TITLE_LIST_PROCESSING = "@Category(\"TitleListProcessing\")";
    private final MetricSample timeForIngestTemplates;
    private final MetricSample timeForContentProcessingTemplates = new MetricSample("com.tandbergtv.watchpoint:type=ExecutionTime,name=contentprocessing_wo_duration");
    private final MetricSample timeForDistributionTemplates = new MetricSample("com.tandbergtv.watchpoint:type=ExecutionTime,name=distribution_wo_duration");
    private final MetricSample timeForTitleListProcessingTemplates = new MetricSample("com.tandbergtv.watchpoint:type=ExecutionTime,name=titlelistprocessing_wo_duration");

    public ExecutionTimeMonitor() {
        this.timeForIngestTemplates = new MetricSample(MBEAN_NAME_INGEST);
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(this.timeForContentProcessingTemplates, new ObjectName(this.timeForContentProcessingTemplates.getName()));
            ManagementFactory.getPlatformMBeanServer().registerMBean(this.timeForDistributionTemplates, new ObjectName(this.timeForDistributionTemplates.getName()));
            ManagementFactory.getPlatformMBeanServer().registerMBean(this.timeForTitleListProcessingTemplates, new ObjectName(this.timeForTitleListProcessingTemplates.getName()));
            ManagementFactory.getPlatformMBeanServer().registerMBean(this.timeForIngestTemplates, new ObjectName(this.timeForIngestTemplates.getName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void receive(WorkflowEvent event) {
        if (!(event instanceof WorkflowProcessEvent)) {
            return;
        }
        WorkflowProcessEvent e = (WorkflowProcessEvent)WorkflowProcessEvent.class.cast(event);
        if (e.getType() != WorkflowProcessEventType.STOPPED || !e.getToken().isRoot()) {
            return;
        }
        WorkflowProcess process = e.getProcess();
        WorkflowTemplate template = process.getProcessDefinition();
        List<String> selectorKeys = ((ITemplateService)ServiceRegistry.getDefault().lookup(ITemplateService.class)).getSelectorKeysByTemplateName(template.getName());
        if (!Collections.disjoint(this.getSelectorKeys(), selectorKeys)) {
            this.timeForIngestTemplates.add(TimeUnit.MILLISECONDS.toSeconds(e.getProcess().getEnd().getTime() - e.getProcess().getStart().getTime()));
        } else if (template.getAnnotations("Category").contains(ANNOTATION_DISTRIBUTION)) {
            this.timeForDistributionTemplates.add(TimeUnit.MILLISECONDS.toSeconds(e.getProcess().getEnd().getTime() - e.getProcess().getStart().getTime()));
        } else if (template.getAnnotations("Category").contains(ANNOTATION_CONTENT_PROCESSING) || template.getAnnotations("Category").contains(ANNOTATION_LOCAL_PROCESSING)) {
            this.timeForContentProcessingTemplates.add(TimeUnit.MILLISECONDS.toSeconds(e.getProcess().getEnd().getTime() - e.getProcess().getStart().getTime()));
        } else if (template.getAnnotations("Category").contains(ANNOTATION_TITLE_LIST_PROCESSING)) {
            this.timeForTitleListProcessingTemplates.add(TimeUnit.MILLISECONDS.toSeconds(e.getProcess().getEnd().getTime() - e.getProcess().getStart().getTime()));
        }
    }

    public String getColleagueName() {
        return "execution-timer";
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.LOW;
    }

    private Collection<String> getSelectorKeys() {
        String string = ((IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class)).getProperties().getProperty("com.tandbergtv.workflow.process.runtime.selectorKeys");
        if (string == null || string.isEmpty()) {
            return Collections.emptySet();
        }
        return Arrays.asList(string.split(","));
    }
}

