/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.driver.internal.IWorkOrderLoader;
import com.tandbergtv.workflow.driver.internal.ProcessPersistenceService;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class WorkOrderLoader
implements IWorkOrderLoader {
    private static final Logger LOGGER = Logger.getLogger(ProcessPersistenceService.class);
    private ProcessPersistenceService processPersistenceService;

    public WorkOrderLoader(ProcessPersistenceService processPersistenceService) {
        this.processPersistenceService = processPersistenceService;
    }

    @Override
    public WorkflowProcess get(Serializable id) {
        WorkflowProcess wo = null;
        try {
            wo = this.processPersistenceService.get(id);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Cannot fetch WorkflowProcess object from database and cache: ", (Throwable)e);
        }
        return wo;
    }

    @Override
    public List<WorkflowProcess> getAll(List<Serializable> ids) {
        List<WorkflowProcess> processes = null;
        try {
            processes = this.processPersistenceService.getAll(ids);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Cannot fetch WorkflowProcess object from database and cache: ", (Throwable)e);
        }
        return processes == null ? Collections.emptyList() : processes;
    }

    @Override
    public boolean idExists(Serializable id) {
        return this.processPersistenceService.idExists((Long)id);
    }

    public String getServiceName() {
        return "WorkOrderLoaderService";
    }

    public void start() {
    }

    public void stop() {
    }
}

