/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.internal;

import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.driver.DriverRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.jbpm.util.IoUtil;

public class Files {
    private static final String REJECTED = "rejected";
    private static final String IMPORTED = "imported";
    private static final Logger LOGGER = Logger.getLogger(Files.class);

    public static boolean success(File file) {
        return Files.move(file.getParentFile().getParentFile() + File.separator + IMPORTED, file);
    }

    public static boolean reject(File file) {
        return Files.move(file.getParentFile().getParentFile() + File.separator + REJECTED, file);
    }

    public static void unzipArchive(WorkflowTemplate template, File file) {
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(file));
            try {
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                while (zipEntry != null) {
                    String entryName = zipEntry.getName();
                    byte[] bytes = IoUtil.readBytes((InputStream)zipInputStream);
                    template.getFileDefinition().addFile(entryName, bytes);
                    zipEntry = zipInputStream.getNextEntry();
                }
            }
            catch (IOException e) {
                LOGGER.warn((Object)("Failed to read template entry: " + file.getAbsolutePath()), (Throwable)e);
            }
        }
        catch (FileNotFoundException e) {
            throw new DriverRuntimeException("Failed to read template : " + file.getAbsolutePath(), e);
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static boolean move(String dir, File file) {
        File gpd;
        String time = new SimpleDateFormat("yyyy-MM-dd-HHmmSS").format(new Date());
        String filename = file.getName();
        String basename = filename.substring(0, filename.lastIndexOf("."));
        String extension = filename.substring(filename.lastIndexOf("."), filename.length());
        boolean moved = file.renameTo(new File(dir + File.separator + filename.replace(".", "-") + "-" + time + extension));
        File jpdl = new File(file.getParentFile(), basename + ".jpdl");
        if (jpdl.exists()) {
            jpdl.renameTo(new File(dir, jpdl.getName() + "-" + time));
        }
        if ((gpd = new File(file.getParentFile(), basename + ".gpd")).exists()) {
            gpd.renameTo(new File(dir, gpd.getName() + "-" + time));
        }
        return moved;
    }
}

