/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver;

import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cluster.IClusterService;
import java.io.Serializable;
import java.net.InetSocketAddress;
import org.jbpm.context.exe.ContextInstance;

public class ProcessFinder {
    public static final String LOCATION_VARIABLE = "_host_address";

    public static Serializable getKey(WorkflowProcess process) {
        InetSocketAddress key = ProcessFinder.getLocation(process);
        if (key == null) {
            return Long.valueOf(process.getId());
        }
        return key;
    }

    public static boolean hasOwner(WorkflowProcess process) {
        InetSocketAddress addr = ProcessFinder.getLocation(process);
        return addr != null && ProcessFinder.getClusterService().isMember(addr);
    }

    public static boolean isOwner(WorkflowProcess process) {
        InetSocketAddress addr = ProcessFinder.getLocation(process);
        return addr != null && ProcessFinder.getClusterService().isLocalMember(addr);
    }

    public static void updateOwner(WorkflowProcess process) {
        InetSocketAddress addr = ProcessFinder.getClusterService().getLocalMember().getSocketAddress();
        String location = addr.getAddress().getHostAddress() + ":" + addr.getPort();
        process.getContextInstance().setVariable(LOCATION_VARIABLE, (Object)location);
    }

    private static InetSocketAddress getLocation(WorkflowProcess process) {
        ContextInstance ci = process.getContextInstance();
        Object variable = ci.getVariable(LOCATION_VARIABLE);
        if (variable instanceof String) {
            String address = (String)variable;
            String host = address.split(":")[0];
            int port = Integer.parseInt(address.split(":")[1]);
            return new InetSocketAddress(host, port);
        }
        return null;
    }

    private static IClusterService getClusterService() {
        return (IClusterService)ServiceRegistry.getDefault().lookup(IClusterService.class);
    }
}

