/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.core.AbstractTaskNode;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.graph.IUndoableNode;
import java.io.StringReader;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.jbpm.JbpmConfiguration;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.def.DelegationException;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.instantiation.Delegation;
import org.jbpm.logging.log.ProcessLog;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class AutomaticTaskNode
extends AbstractTaskNode
implements IUndoableNode {
    public static final String EVENTTYPE_NODE_UNDO = "node-undo";
    private static final String START_TOKEN = "<receive>";
    private static final String END_TOKEN = "</receive>";
    private static final long serialVersionUID = 4614455101092538306L;
    private static final Logger LOGGER = Logger.getLogger(AutomaticTaskNode.class);

    public AutomaticTaskNode() {
    }

    public AutomaticTaskNode(String name) {
        super(name);
    }

    public void execute(ExecutionContext context) {
        CustomToken token;
        block10: {
            token = (CustomToken)context.getToken();
            LOGGER.info((Object)(token + " (" + this.name + ")"));
            if (this.action != null && this.action.getActionDelegation() != null) {
                context.setTask(this.getTask(this.name));
                try {
                    try {
                        ActionHandler handler = this.createActionHandler(context, this.action.getActionDelegation());
                        token.setActionHandler(handler);
                        handler.execute(context);
                    }
                    catch (StackOverflowError e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        try {
                            this.raiseException(t, context);
                        }
                        catch (DelegationException e) {
                            LOGGER.warn((Object)(token + ", no exception handler defined for template - " + this.processDefinition.getName()), t);
                            token.fail(e);
                        }
                        token.setActionHandler(null);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    token.setActionHandler(null);
                    throw throwable;
                }
                token.setActionHandler(null);
            }
        }
        if (token.getStatus() == ProcessStatus.BUSY) {
            super.leave(context);
        }
    }

    @Override
    public void undo(ExecutionContext context) {
        CustomToken token = (CustomToken)context.getToken();
        LOGGER.info((Object)(token + " (" + this.name + ")"));
        this.fireEvent(EVENTTYPE_NODE_UNDO, context);
        token.addLog((ProcessLog)new NodeLog((org.jbpm.graph.def.Node)this, new Date(), new Date()));
    }

    @Override
    public boolean canUndo() {
        return this.hasEvent(EVENTTYPE_NODE_UNDO);
    }

    protected ActionHandler createActionHandler(ExecutionContext context, Delegation d) {
        Delegation delegation = (Delegation)JbpmConfiguration.Configs.getObject((String)"jbpm.action.delegation");
        delegation.setClassName(d.getClassName());
        delegation.setConfiguration(d.getConfiguration());
        delegation.setConfigType(d.getConfigType());
        delegation.setProcessDefinition(d.getProcessDefinition());
        ActionHandler handler = (ActionHandler)delegation.instantiate();
        if (handler == null) {
            throw new RuntimeException(context.getToken() + ", cannot instantiate " + d.getClassName() + ".");
        }
        return handler;
    }

    public String getMessage() {
        String configuration = this.getConfiguration();
        if (configuration == null) {
            return null;
        }
        int from = configuration.indexOf(START_TOKEN);
        int to = configuration.indexOf(END_TOKEN);
        if (from == -1 || to == -1) {
            return null;
        }
        return configuration.substring(from + START_TOKEN.length(), to).trim();
    }

    public Map<String, String> getCorrelationKeys() {
        HashMap<String, String> keys = new HashMap<String, String>();
        String configuration = this.getConfiguration();
        if (configuration == null) {
            return keys;
        }
        int from = configuration.indexOf("<keys>");
        int to = configuration.indexOf("</keys>");
        if (from == -1 || to == -1) {
            return keys;
        }
        try {
            XPath path = XPathFactory.newInstance().newXPath();
            String tmp = configuration.substring(from, to + 7);
            Node document = this.getNode(tmp);
            NodeList nodes = (NodeList)path.evaluate("//keys/entry", document, XPathConstants.NODESET);
            int i = 0;
            while (i < nodes.getLength()) {
                Node n = nodes.item(i);
                keys.put(n.getFirstChild().getTextContent(), n.getLastChild().getTextContent());
                ++i;
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return keys;
    }

    private Node getNode(String xml) {
        Document node = null;
        try {
            node = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create valid DOM: " + xml, e);
        }
        return node;
    }

    private String getConfiguration() {
        if (this.action == null) {
            return null;
        }
        Delegation delegation = this.action.getActionDelegation();
        if (delegation == null) {
            return null;
        }
        return delegation.getConfiguration();
    }
}

