/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.core.WFSInterpreter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class DurationUtility {
    private static final String ZERO_TIME = "00:00:00";
    private static final long ONE_DAY_MILLIS = 86400000L;
    private final long zero;
    private static final Logger LOGGER = Logger.getLogger(DurationUtility.class);

    public DurationUtility() {
        try {
            this.zero = this.shortFormat().parse(ZERO_TIME).getTime();
        }
        catch (ParseException e) {
            throw new Error();
        }
    }

    public String addDates(String str1, String str2) {
        Date date = null;
        try {
            long t1 = this.convertToMillis(this.shortFormat(), str1);
            long t2 = this.convertToMillis(this.shortFormat(), str2);
            date = new Date(t1 + t2 + this.zero);
            LOGGER.debug((Object)(String.valueOf(str1) + " + " + str2 + " -> " + date));
        }
        catch (ParseException e) {
            LOGGER.error((Object)("Failed to add dates " + str1 + ", " + str2), (Throwable)e);
        }
        return this.longFormat().format(date);
    }

    public String multiplyDate(String str, double factor) {
        Date date = null;
        try {
            long t = this.convertToMillis(this.shortFormat(), str);
            long resultMillis = new Double((double)t * factor).longValue();
            date = new Date(resultMillis + this.zero);
            LOGGER.debug((Object)(String.valueOf(str) + " * " + factor + " -> " + date));
        }
        catch (ParseException e) {
            LOGGER.error((Object)("Failed to multiply date " + str), (Throwable)e);
        }
        return this.longFormat().format(date);
    }

    public long getDurationInMillis(String str) throws ParseException {
        long time = 0L;
        try {
            time = this.convertToMillis(this.shortFormat(), str);
        }
        catch (ParseException e) {
            time = this.convertToMillis(this.longFormat(), str) + 86400000L;
        }
        LOGGER.debug((Object)(String.valueOf(str) + " -> " + time / 1000L + " seconds"));
        return time;
    }

    public long getDurationInMillis(String str, WFSInterpreter interpreter) throws Exception {
        long time = this.evaluateExpression(interpreter, str);
        LOGGER.debug((Object)(String.valueOf(str) + " -> " + time / 1000L + " seconds"));
        return time;
    }

    private long convertToMillis(DateFormat formatter, String duration) throws ParseException {
        return formatter.parse(duration).getTime() - this.zero;
    }

    private long evaluateExpression(WFSInterpreter interpreter, String expression) throws ParseException {
        long time = 0L;
        String duration = interpreter.evaluate(expression).toString();
        try {
            time = this.convertToMillis(this.shortFormat(), duration);
        }
        catch (ParseException e2) {
            time = this.convertToMillis(this.longFormat(), duration);
        }
        return time;
    }

    private DateFormat shortFormat() {
        return new SimpleDateFormat("HH:mm:ss");
    }

    private DateFormat longFormat() {
        return new SimpleDateFormat("dd'T'HH:mm:ss");
    }
}

