/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.core.AutomaticTaskNode;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ResourceGroupAware;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.logging.log.ProcessLog;

public class NodeGroup
extends SuperState
implements ResourceGroupAware {
    private static final long serialVersionUID = 1214915925481664560L;
    private Long resourceGroupID;
    private static final Long DEFAULT_RESOURCE_GROUP_ID = -1L;
    private static final Logger LOGGER = Logger.getLogger(NodeGroup.class);

    public List<Node> getNodes() {
        return super.getNodes();
    }

    @Override
    public Long getResourceGroupID() {
        if (DEFAULT_RESOURCE_GROUP_ID.equals(this.resourceGroupID)) {
            return null;
        }
        return this.resourceGroupID;
    }

    @Override
    public void setResourceGroupID(Long resourceGroupID) {
        this.resourceGroupID = resourceGroupID == null ? DEFAULT_RESOURCE_GROUP_ID : resourceGroupID;
    }

    public void read(Element element, JpdlXmlReader jpdlReader) {
        this.action = jpdlReader.readSingleAction(element);
        super.read(element, jpdlReader);
    }

    public void enter(ExecutionContext context) {
        LOGGER.info((Object)(context.getToken() + " (" + this.name + ")"));
        this.fireEvent("superstate-enter", context);
        CustomToken token = (CustomToken)context.getToken();
        token.setSuperStateEnter(new Date());
        this.execute(context);
    }

    public void execute(ExecutionContext executionContext) {
        if (this.nodes == null || this.nodes.isEmpty()) {
            throw new JbpmException("Transition enters superstate '" + this + "' and there is no first child-node to delegate to.");
        }
        Node startNode = this.first();
        if (startNode == null) {
            throw new JbpmException("Super state '" + this.name + "' does not have an entry node " + "(any node with an incoming transition from outside the super-state).");
        }
        LOGGER.debug((Object)("First Node of super-state " + this.name + " is " + startNode.getName()));
        startNode.enter(executionContext);
    }

    public void leave(ExecutionContext context) {
        LOGGER.info((Object)(context.getToken() + " (" + this.name + ")"));
        this.fireEvent("superstate-leave", context);
        CustomToken token = (CustomToken)context.getToken();
        if (token.getSuperStateEnter() != null) {
            token.addLog((ProcessLog)new NodeLog((Node)this, token.getSuperStateEnter(), new Date()));
        }
    }

    public Node first() {
        for (Object obj : this.nodes) {
            Node node = (Node)obj;
            if (node.getArrivingTransitions() == null || node.getArrivingTransitions().isEmpty()) {
                return node;
            }
            for (Object transObj : node.getArrivingTransitions()) {
                Transition transition = (Transition)transObj;
                SuperState superstate = transition.getFrom().getSuperState();
                if (superstate != null && superstate.equals((Object)this)) continue;
                return node;
            }
        }
        return null;
    }

    public Node last() {
        for (Object obj : this.nodes) {
            Node node = (Node)obj;
            if (!(node instanceof AutomaticTaskNode) || ((AutomaticTaskNode)AutomaticTaskNode.class.cast(node)).getMessage() == null) continue;
            return node;
        }
        return (Node)this.nodes.get(this.nodes.size() - 1);
    }

    public List<?> getLeavingTransitions() {
        ArrayList<Transition> list = new ArrayList<Transition>();
        for (Node child : this.getNodes()) {
            if (child.getLeavingTransitions() == null) continue;
            for (Transition transition : child.getLeavingTransitions()) {
                if (this.equals(transition.getTo().getSuperState())) continue;
                list.add(transition);
            }
        }
        return list;
    }

    public Set<?> getArrivingTransitions() {
        HashSet<Transition> set = new HashSet<Transition>();
        Node first = this.first();
        if (first.getArrivingTransitions() == null) {
            return set;
        }
        for (Object obj : first.getArrivingTransitions()) {
            Transition transition = (Transition)Transition.class.cast(obj);
            if (this.equals(transition.getFrom().getSuperState())) continue;
            set.add(transition);
        }
        return set;
    }

    public boolean hasAsyncMessages() {
        for (Node child : this.getNodes()) {
            AutomaticTaskNode tasknode;
            if (!(child instanceof AutomaticTaskNode) || (tasknode = (AutomaticTaskNode)AutomaticTaskNode.class.cast(child)).getMessage() == null) continue;
            return true;
        }
        return false;
    }
}

