/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.util;

import java.util.HashMap;
import java.util.Map;

public class ErrorMessages {
    private static final Map<String, String> ERROR_MESSAGES = new HashMap<String, String>();

    static {
        ErrorMessages.initializeErrorMessages();
    }

    private ErrorMessages() {
    }

    public static String getErrorMessage(String errorCode) {
        String message = ERROR_MESSAGES.get(errorCode);
        return message;
    }

    private static void initializeErrorMessages() {
        String code = null;
        String message = null;
        code = "FE-100";
        message = "The Resource Entity Key specified to find the Resource Entity does not exist.";
        ERROR_MESSAGES.put(code, message);
        code = "DO-100";
        message = "Failed to perform the Data Operation.";
        ERROR_MESSAGES.put(code, message);
        code = "VR-100";
        message = "The Resource being validated cannot be null.";
        ERROR_MESSAGES.put(code, message);
        code = "VR-101";
        message = "The Resource Type is not defined.";
        ERROR_MESSAGES.put(code, message);
        code = "VR-102";
        message = "The Resource Connection String cannot be blank.";
        ERROR_MESSAGES.put(code, message);
        code = "VR-103";
        message = "The Resource Connection String specified does not match the expected Resource Connection Type.";
        ERROR_MESSAGES.put(code, message);
        code = "VR-104";
        message = "The Resource must belong to at least one Resource Group.";
        ERROR_MESSAGES.put(code, message);
        code = "VR-105";
        message = "The Resource cannot belong to a Resource Group of a different Resource Type.";
        ERROR_MESSAGES.put(code, message);
        code = "VR-112";
        message = "The Resource Functional Type does not match the Functional Type of the Resource Groups to which it belongs.";
        ERROR_MESSAGES.put(code, message);
        code = "VR-113";
        message = "The Resource contains Resource Groups for which the Protection Keys are not identical.";
        ERROR_MESSAGES.put(code, message);
        code = "VR-106";
        message = "The Resource Name cannot be blank.";
        ERROR_MESSAGES.put(code, message);
        code = "VR-107";
        message = "The Resource Heartbeat Connection String cannot be blank.";
        ERROR_MESSAGES.put(code, message);
        code = "VR-108";
        message = "The Resource HeartBeat Connection String specified does not match the expected HeartBeat Connection Type.";
        ERROR_MESSAGES.put(code, message);
        code = "VR-109";
        message = "The Resource Heartbeat Frequency must be greater than 0.";
        ERROR_MESSAGES.put(code, message);
        code = "VR-110";
        message = "The maxiumum number of Concurrent Users for the Resource must be greater than 0 or 0 for infinite users.";
        ERROR_MESSAGES.put(code, message);
        code = "VR-111";
        message = "The Administration State can only be Offline or Online.";
        ERROR_MESSAGES.put(code, message);
        code = "VR-200";
        message = "The Resource Name must be unique for all Resources.";
        ERROR_MESSAGES.put(code, message);
        code = "VR-201";
        message = "The Resource Type cannot be changed for an existing Resource.";
        ERROR_MESSAGES.put(code, message);
        code = "VR-202";
        message = "The Connection String must be unique for all Resources with matching Resource Types.";
        ERROR_MESSAGES.put(code, message);
        code = "VR-203";
        message = "The Resource Id must be set to the default value when creating a new Resource.";
        ERROR_MESSAGES.put(code, message);
        code = "VR-204";
        message = "The Resource must belong to a Resource Type that is active.";
        ERROR_MESSAGES.put(code, message);
        code = "AE-100";
        message = "The Resource currently has users and cannot be modified / deleted.";
        ERROR_MESSAGES.put(code, message);
        code = "AE-102";
        message = "The Resource Operational State is not Offline and cannot be modified / deleted.";
        ERROR_MESSAGES.put(code, message);
        code = "AE-103";
        message = "The Resource Administration State is not Offline and cannot be modified / deleted.";
        ERROR_MESSAGES.put(code, message);
        code = "QE-100";
        message = "The workorder you wanted to move is not in the queue any longer.";
        ERROR_MESSAGES.put(code, message);
    }
}

