/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat;

import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.ResourceHeartBeatEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class ResourceHeartBeatEventLogger {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String FILE_TIME_FORMAT = "HH-mm-ss";
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String PRODUCT_DIR_PROPERTY = "com.tandbergtv.cms.product.dir";
    private static final String BASE_RESOURCE_HISTORY_DIR = "workflow" + File.separator + "history" + File.separator + "resources";
    private static final String EVENT_TIME_SEPARATOR = "@";
    private static final String FILE_EXT = ".json";
    private static final String FILE_PATTERN = ResourceHeartBeatEvent.class.getSimpleName() + "@" + "\\d{2}-\\d{2}-\\d{2}" + ".json";
    private static final Logger LOGGER = Logger.getLogger(ResourceHeartBeatEventLogger.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logEvent(ResourceHeartBeatEvent event) {
        Calendar cal = Calendar.getInstance();
        String resourceId = Long.toString(event.getParentResource().getId());
        String resourceHistoryDir = this.getResourceHistoryPathForDateAndId(cal.getTime(), resourceId);
        File resourceHistoryFolder = new File(resourceHistoryDir);
        if (!resourceHistoryFolder.exists() && !resourceHistoryFolder.mkdirs()) {
            LOGGER.error((Object)("Unable to create history the logging directory for resource " + resourceId));
            return;
        }
        Writer writer = null;
        try {
            String filePath = resourceHistoryFolder + File.separator + this.getFileName(event, cal.getTime());
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "utf-8"));
            HashMap<String, String> valueMap = new HashMap<String, String>();
            valueMap.put("date", this.getTimestampString(cal.getTime()));
            valueMap.put("eventType", event.getClass().getName());
            valueMap.put("resourceId", resourceId);
            valueMap.put("resourceStatus", event.getParentResource().getOperationalState().toString());
            valueMap.put("message", event.getMessage());
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue(writer, valueMap);
        }
        catch (IOException ex) {
            LOGGER.error((Object)"An error occurred while logging the ResourceHeartBeatEvent", (Throwable)ex);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"An error occurred while logging the ResourceHeartBeatEvent", (Throwable)e);
            }
        }
    }

    public Integer countFailureEventsForDate(long resourceId, Date date) {
        String resourceDatePath = this.getResourceHistoryPathForDateAndId(date, Long.toString(resourceId));
        int counter = 0;
        File resourceHistoryFolder = new File(resourceDatePath);
        if (resourceHistoryFolder.exists() && resourceHistoryFolder.isDirectory()) {
            File[] eventFiles = resourceHistoryFolder.listFiles();
            for (int i = 0; i < eventFiles.length; ++i) {
                File event = eventFiles[i];
                if (!event.getName().matches(FILE_PATTERN)) continue;
                ++counter;
            }
        }
        return counter;
    }

    public String getBaseResourceHistoryPath() {
        return System.getProperty(PRODUCT_DIR_PROPERTY) + File.separator + BASE_RESOURCE_HISTORY_DIR;
    }

    public String getResourceHistoryPathForDate(String date) {
        return this.getBaseResourceHistoryPath() + File.separator + date;
    }

    public String getResourceHistoryPathForDateAndId(Date date, String resourceId) {
        return this.getResourceHistoryPathForDate(this.getDateString(date)) + File.separator + resourceId;
    }

    private String getFileName(ResourceHeartBeatEvent event, Date date) {
        return event.getClass().getSimpleName() + EVENT_TIME_SEPARATOR + this.getTimeString(date) + FILE_EXT;
    }

    public String getDateString(Date date) {
        return this.getSimpleDateFormatter(DATE_FORMAT).format(date);
    }

    public String getTimeString(Date date) {
        return this.getSimpleDateFormatter(FILE_TIME_FORMAT).format(date);
    }

    public String getTimestampString(Date date) {
        return this.getSimpleDateFormatter(TIMESTAMP_FORMAT).format(date);
    }

    private SimpleDateFormat getSimpleDateFormatter(String format) {
        return new SimpleDateFormat(format);
    }
}

