/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.pluginmanager.internal;

import com.tandbergtv.workflow.pluginmanager.entities.WatchPointDescriptor;
import com.tandbergtv.workflow.pluginmanager.event.PluginChangeEvent;
import com.tandbergtv.workflow.pluginmanager.internal.PluginChangeResult;
import com.tandbergtv.workflow.pluginmanager.internal.PluginExtensionHandler;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.java.plugin.JpfException;
import org.java.plugin.PluginManager;
import org.java.plugin.boot.DefaultPluginsCollector;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.registry.ManifestInfo;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.registry.Version;
import org.java.plugin.util.ExtendedProperties;

public class PluginChangeHandler {
    private static final Logger LOGGER = Logger.getLogger(PluginChangeHandler.class);
    private static final String JPF_PLUGIN_REPOSITORY_PROPERTY = "org.java.plugin.boot.pluginsRepositories";
    private final PluginExtensionHandler extensionHandler = new PluginExtensionHandler();

    public PluginChangeResult processEvents(PluginManager manager, List<PluginChangeEvent> events) {
        PluginChangeResult result = new PluginChangeResult();
        LOGGER.debug((Object)("Processing plugin change events for " + events.size() + " plugins."));
        PluginRegistry registry = manager.getRegistry();
        ArrayList<PluginManager.PluginLocation> locations = new ArrayList<PluginManager.PluginLocation>();
        for (PluginChangeEvent event : events) {
            this.readPluginLocations(registry, event, locations);
        }
        Map map = null;
        try {
            PluginManager.PluginLocation[] locationsArray = locations.toArray(new PluginManager.PluginLocation[0]);
            map = manager.publishPlugins(locationsArray);
        }
        catch (JpfException e) {
            LOGGER.error((Object)("Failed to publish updated plugin locations: " + locations), (Throwable)e);
            return result;
        }
        IntegrityCheckReport report = this.extensionHandler.getReport(manager);
        this.processExtensions(manager, map, "resourcetype", report, result.getResourceTypeDescriptors());
        this.processExtensions(manager, map, "resourcegroup", report, result.getResourceGroupDescriptors());
        return result;
    }

    private void readPluginLocations(PluginRegistry registry, PluginChangeEvent event, List<PluginManager.PluginLocation> locations) {
        String defaultName = this.getPluginName(event, null);
        String fileFolder = event.getPluginFolder();
        ExtendedProperties properties = new ExtendedProperties(System.getProperties());
        properties.setProperty(JPF_PLUGIN_REPOSITORY_PROPERTY, fileFolder);
        try {
            DefaultPluginsCollector collector = new DefaultPluginsCollector();
            collector.configure(properties);
            Collection pluginLocations = collector.collectPluginLocations();
            for (PluginManager.PluginLocation pluginLocation : pluginLocations) {
                URL manifestLocation = pluginLocation.getManifestLocation();
                ManifestInfo manifest = registry.readManifestInfo(manifestLocation);
                String name = this.getPluginName(event, manifest);
                String pluginId = manifest.getId();
                Version version = manifest.getVersion();
                Version oldVersion = null;
                if (registry.isPluginDescriptorAvailable(pluginId)) {
                    oldVersion = registry.getPluginDescriptor(pluginId).getVersion();
                    if (version.compareTo(oldVersion) <= 0) {
                        String versionString = version.toString();
                        String oldVersionString = oldVersion.toString();
                        String msg = "Received update for " + name + ", but new plugin version[" + versionString + "] is not larger than old version[" + oldVersionString + "], ignoring plugin.";
                        LOGGER.warn((Object)msg);
                        continue;
                    }
                    registry.unregister(new String[]{pluginId});
                }
                locations.add(pluginLocation);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Failed to handle update for " + defaultName), (Throwable)e);
        }
    }

    private String getPluginName(PluginChangeEvent event, ManifestInfo manifest) {
        String desc = "plugin[" + event.getPluginFolder() + ", id: ";
        desc = desc + (manifest != null ? manifest.getId() : "UNKNOWN");
        desc = desc + "]";
        return desc;
    }

    private void processExtensions(PluginManager pluginManager, Map<String, Identity> pluginMap, String extensionPointId, IntegrityCheckReport report, List<WatchPointDescriptor> descriptors) {
        for (String key : pluginMap.keySet()) {
            Identity identity = pluginMap.get(key);
            if (!(identity instanceof PluginDescriptor)) continue;
            PluginDescriptor descriptor = (PluginDescriptor)identity;
            for (Extension extension : descriptor.getExtensions()) {
                if (!this.isMatchingExtension(extension, extensionPointId)) continue;
                this.processExtension(pluginManager, extension, report, descriptors);
            }
        }
    }

    private boolean isMatchingExtension(Extension extension, String extensionPointId) {
        String pluginId = extension.getExtendedPluginId();
        String pointId = extension.getExtendedPointId();
        return pluginId.equals("com.tandbergtv.workflow") && pointId.equals(extensionPointId);
    }

    private void processExtension(PluginManager pluginManager, Extension extension, IntegrityCheckReport report, List<WatchPointDescriptor> descriptors) {
        descriptors.add(this.extensionHandler.buildDescriptor(pluginManager, extension, report));
    }
}

