/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.resourcegroup;

import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.core.service.cache.IDistributedCache;
import com.tandbergtv.workflow.core.service.cache.IMultiValueCacheService;
import com.tandbergtv.workflow.resourcemanager.ActionException;
import com.tandbergtv.workflow.resourcemanager.DataOperationException;
import com.tandbergtv.workflow.resourcemanager.FinderException;
import com.tandbergtv.workflow.resourcemanager.IResourceGroupService;
import com.tandbergtv.workflow.resourcemanager.ResourceGroupContainer;
import com.tandbergtv.workflow.resourcemanager.dataaccess.DataAccessObjectFactory;
import com.tandbergtv.workflow.resourcemanager.dataaccess.ResourceGroupDAI;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.internal.ICloneService;
import com.tandbergtv.workflow.resourcemanager.internal.IHibernatePersistenceService;
import com.tandbergtv.workflow.resourcemanager.internal.ILocatorService;
import com.tandbergtv.workflow.resourcemanager.internal.IResourceTypeIdAware;
import com.tandbergtv.workflow.resourcemanager.internal.ResourceManagementService;
import com.tandbergtv.workflow.resourcemanager.internal.allocation.IResourceAllocationService;
import com.tandbergtv.workflow.resourcemanager.internal.container.IContainerService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class LocalResourceGroupService
extends ResourceManagementService
implements IResourceGroupService,
IResourceTypeIdAware {
    private final ThreadLocal<Long> localResourceTypeId = new ThreadLocal();
    private static final Logger LOGGER = Logger.getLogger(LocalResourceGroupService.class);

    @Override
    public List<ResourceGroup> getAllResourceGroups() {
        ArrayList<ResourceGroup> resourceGroupList = new ArrayList<ResourceGroup>();
        Collection localKeys = this.getResourceTypeCache().localKeySet();
        IMultiValueCacheService<ResourceGroup> cache = this.getResourceGroupCache();
        for (Serializable key : localKeys) {
            Collection groups = cache.get(key);
            if (groups == null) continue;
            for (ResourceGroup cachedGroup : groups) {
                resourceGroupList.add(this.clone(cachedGroup));
            }
        }
        return resourceGroupList;
    }

    @Override
    public List<ResourceGroup> getVisibleResourceGroups() {
        ArrayList<ResourceGroup> resourceGroupList = new ArrayList<ResourceGroup>();
        Collection localKeys = this.getResourceTypeCache().localKeySet();
        IMultiValueCacheService<ResourceGroup> cache = this.getResourceGroupCache();
        for (Serializable key : localKeys) {
            Collection groups = cache.get(key);
            if (groups == null) continue;
            for (ResourceGroup group : groups) {
                if (!group.isVisible()) continue;
                resourceGroupList.add(this.clone(group));
            }
        }
        return resourceGroupList;
    }

    @Override
    public ResourceGroup getResourceGroup(long resourceGroupId) throws FinderException {
        ResourceGroup match = this.getResourceGroupById(resourceGroupId);
        return this.clone(match);
    }

    private ResourceGroup getResourceGroupById(long resourceGroupId) throws FinderException {
        ResourceGroup match = null;
        Long resourceTypeId = this.getResourceTypeIdForRequest();
        IMultiValueCacheService<ResourceGroup> cache = this.getResourceGroupCache();
        if (resourceTypeId == null) {
            Serializable key;
            Iterator i$ = this.getResourceTypeCache().localKeySet().iterator();
            while (i$.hasNext() && (match = this.getResourceGroup(cache.get(key = (Serializable)i$.next()), resourceGroupId)) == null) {
            }
        } else if (this.getResourceTypeCache().localKeySet().contains(resourceTypeId)) {
            match = this.getResourceGroup(cache.get((Serializable)resourceTypeId), resourceGroupId);
        }
        if (match == null) {
            String msg = "Could not find Resource Group with Id: " + resourceGroupId;
            throw new FinderException(msg);
        }
        return match;
    }

    private ResourceGroup getResourceGroup(Collection<ResourceGroup> groups, long resourceGroupId) {
        if (groups != null) {
            for (ResourceGroup group : groups) {
                if (group.getId() != resourceGroupId) continue;
                return group;
            }
        }
        return null;
    }

    @Override
    public List<ResourceGroup> getResourceGroupsByResourceType(long resourceTypeId) {
        Collection groups;
        ArrayList<ResourceGroup> resourceGroupList = new ArrayList<ResourceGroup>();
        if (this.getResourceTypeCache().localKeySet().contains(resourceTypeId) && (groups = this.getResourceGroupCache().get((Serializable)Long.valueOf(resourceTypeId))) != null) {
            for (ResourceGroup cachedGroup : groups) {
                resourceGroupList.add(this.clone(cachedGroup));
            }
        }
        return resourceGroupList;
    }

    @Override
    public List<ResourceGroup> getResourceGroupsByResource(long resourceId) {
        ArrayList<ResourceGroup> resourceGroupList = new ArrayList<ResourceGroup>();
        Long resourceTypeId = this.getResourceTypeIdForRequest();
        Resource resource = new Resource(resourceId);
        IMultiValueCacheService<ResourceGroup> cache = this.getResourceGroupCache();
        if (resourceTypeId == null) {
            for (Serializable key : this.getResourceTypeCache().localKeySet()) {
                if (!this.getResourceGroupsByResource(cache.get(key), resource, resourceGroupList)) continue;
                return resourceGroupList;
            }
        } else if (this.getResourceTypeCache().localKeySet().contains(resourceTypeId)) {
            this.getResourceGroupsByResource(cache.get((Serializable)resourceTypeId), resource, resourceGroupList);
        }
        return resourceGroupList;
    }

    private boolean getResourceGroupsByResource(Collection<ResourceGroup> groups, Resource resource, List<ResourceGroup> result) {
        boolean added = false;
        if (groups != null) {
            for (ResourceGroup group : groups) {
                if (!group.getResources().contains(resource)) continue;
                result.add(this.clone(group));
                added = true;
            }
        }
        return added;
    }

    @Override
    public ResourceGroup getResourceGroupByToken(long tokenId) {
        Collection localKeys = this.getResourceTypeCache().localKeySet();
        for (Serializable localKey : localKeys) {
            Collection groups = this.getResourceGroupCache().get(localKey);
            if (groups == null) continue;
            for (ResourceGroup group : groups) {
                if (group.getQueue().findItem(tokenId) == null) continue;
                return this.clone(group);
            }
        }
        return null;
    }

    @Override
    public List<ResourceGroup> getExternallyAcquiredResourceGroupsByUser(String userName) {
        ArrayList<ResourceGroup> result = new ArrayList<ResourceGroup>();
        Long resourceTypeId = this.getResourceTypeIdForRequest();
        if (resourceTypeId == null && (resourceTypeId = this.getLocatorService().getResourceTypeIdForDevice("04")) == null) {
            return result;
        }
        if (this.getResourceTypeCache().localKeySet().contains(resourceTypeId)) {
            Long resourceId = this.getResourceIdForUser(userName, resourceTypeId);
            if (resourceId == null) {
                return result;
            }
            Resource resource = new Resource(resourceId);
            Collection humanGroups = this.getResourceGroupCache().get((Serializable)resourceTypeId);
            if (humanGroups != null) {
                for (ResourceGroup group : humanGroups) {
                    if (group.isInternallyAcquired() || !group.getResources().contains(resource)) continue;
                    result.add(this.cloneWithQueueProxy(group));
                }
            }
        }
        return result;
    }

    private Long getResourceIdForUser(String userName, long resourceTypeId) {
        if (userName == null) {
            return null;
        }
        IMultiValueCacheService<Resource> cache = this.getResourceCache();
        Collection humanResources = cache.get((Serializable)Long.valueOf(resourceTypeId));
        if (humanResources != null) {
            for (Resource resource : humanResources) {
                if (!userName.equals(resource.getUserName())) continue;
                return resource.getId();
            }
        }
        return null;
    }

    @Override
    public boolean isExternallyAcquiredResourceGroup(long resourceGroupId) throws FinderException {
        ResourceGroup match = this.getResourceGroupById(resourceGroupId);
        return !match.isInternallyAcquired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceGroup setResourceGroupQueueUIVisibility(long resourceGroupId, boolean visible) throws FinderException, DataOperationException {
        ResourceGroupContainer container = (ResourceGroupContainer)this.getResourceGroupContainerCache().get((Serializable)Long.valueOf(resourceGroupId));
        this.verifyContainerReady(resourceGroupId, container);
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            ResourceGroup resourceGroup = (ResourceGroup)container.getEntity();
            if (resourceGroup.isVisible() == visible) {
                ResourceGroup resourceGroup2 = this.clone(resourceGroup);
                return resourceGroup2;
            }
            Session session = this.getPersistenceService().getCurrentSession();
            DataAccessObjectFactory factory = this.getPersistenceService().getDataAccessObjectFactory();
            ResourceGroupDAI dao = factory.getResourceGroupDAO();
            this.getPersistenceService().beginTransaction(session);
            try {
                ResourceGroup clone = this.getCloneService().cloneResourceGroup(resourceGroup, false);
                clone.setVisible(visible);
                dao.update(clone);
                this.getPersistenceService().commitTransaction(session);
            }
            catch (RuntimeException e) {
                this.getPersistenceService().rollbackTransaction(session);
                throw e;
            }
            resourceGroup.setVisible(visible);
            container.updateEntity();
            ResourceGroup resourceGroup3 = this.clone((ResourceGroup)container.getEntity());
            return resourceGroup3;
        }
        finally {
            container.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ResourceGroup> setResourceGroupQueueAllocatability(long resourceGroupId, boolean allocatable) throws FinderException, DataOperationException {
        ResourceGroupContainer container = (ResourceGroupContainer)this.getResourceGroupContainerCache().get((Serializable)Long.valueOf(resourceGroupId));
        if (container == null) {
            return null;
        }
        this.verifyContainerReady(resourceGroupId, container);
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            ResourceGroup resourceGroup = (ResourceGroup)container.getEntity();
            ArrayList<ResourceGroup> resourceGroupList = new ArrayList<ResourceGroup>();
            if (resourceGroup.isAllocatable() == allocatable) {
                resourceGroupList.add(this.clone(resourceGroup));
                ArrayList<ResourceGroup> arrayList = resourceGroupList;
                return arrayList;
            }
            Session session = this.getPersistenceService().getCurrentSession();
            DataAccessObjectFactory factory = this.getPersistenceService().getDataAccessObjectFactory();
            ResourceGroupDAI dao = factory.getResourceGroupDAO();
            this.getPersistenceService().beginTransaction(session);
            try {
                ResourceGroup clone = this.getCloneService().cloneResourceGroup(resourceGroup, false);
                clone.setAllocatable(allocatable);
                dao.update(clone);
                this.getPersistenceService().commitTransaction(session);
            }
            catch (RuntimeException e) {
                this.getPersistenceService().rollbackTransaction(session);
                throw e;
            }
            resourceGroup.setAllocatable(allocatable);
            container.updateEntity();
            resourceGroupList.add(this.clone((ResourceGroup)container.getEntity()));
            ArrayList<ResourceGroup> arrayList = resourceGroupList;
            return arrayList;
        }
        finally {
            container.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceGroup moveQueueItemToTop(long resourceGroupId, long resourceGroupItemId) throws ActionException {
        ResourceGroupContainer container = (ResourceGroupContainer)this.getResourceGroupContainerCache().get((Serializable)Long.valueOf(resourceGroupId));
        this.verifyContainerReady(resourceGroupId, container);
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            if (this.getAllocationService().moveQueueItemToTop(resourceGroupId, resourceGroupItemId)) {
                container.updateEntity();
            } else {
                this.failQueueOperation();
            }
            ResourceGroup resourceGroup = this.clone((ResourceGroup)container.getEntity());
            return resourceGroup;
        }
        finally {
            container.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceGroup moveQueueItemToBottom(long resourceGroupId, long resourceGroupItemId) throws ActionException {
        ResourceGroupContainer container = (ResourceGroupContainer)this.getResourceGroupContainerCache().get((Serializable)Long.valueOf(resourceGroupId));
        this.verifyContainerReady(resourceGroupId, container);
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            if (this.getAllocationService().moveQueueItemToBottom(resourceGroupId, resourceGroupItemId)) {
                container.updateEntity();
            } else {
                this.failQueueOperation();
            }
            ResourceGroup resourceGroup = this.clone((ResourceGroup)container.getEntity());
            return resourceGroup;
        }
        finally {
            container.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceGroup moveQueueItemUp(long resourceGroupId, long queueItemId, long neighborQueueItemId) throws ActionException {
        ResourceGroupContainer container = (ResourceGroupContainer)this.getResourceGroupContainerCache().get((Serializable)Long.valueOf(resourceGroupId));
        this.verifyContainerReady(resourceGroupId, container);
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            if (this.getAllocationService().moveQueueItemUp(resourceGroupId, queueItemId, neighborQueueItemId)) {
                container.updateEntity();
            } else {
                this.failQueueOperation();
            }
            ResourceGroup resourceGroup = this.clone((ResourceGroup)container.getEntity());
            return resourceGroup;
        }
        finally {
            container.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceGroup moveQueueItemDown(long resourceGroupId, long queueItemId, long neighborQueueItemId) throws ActionException {
        ResourceGroupContainer container = (ResourceGroupContainer)this.getResourceGroupContainerCache().get((Serializable)Long.valueOf(resourceGroupId));
        this.verifyContainerReady(resourceGroupId, container);
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            if (this.getAllocationService().moveQueueItemDown(resourceGroupId, queueItemId, neighborQueueItemId)) {
                container.updateEntity();
            } else {
                this.failQueueOperation();
            }
            ResourceGroup resourceGroup = this.clone((ResourceGroup)container.getEntity());
            return resourceGroup;
        }
        finally {
            container.getWriteLock().unlock();
        }
    }

    private boolean verifyContainerReady(long resourceGroupId, ResourceGroupContainer container) {
        Long resourceTypeId;
        if ((container == null || container.isStopped()) && (resourceTypeId = this.getLocatorService().getResourceTypeIdForGroup(resourceGroupId)) == null) {
            return false;
        }
        String name = "resource group[" + resourceGroupId + "]";
        this.getContainerService().verifyContainerReady(name, container);
        return true;
    }

    private void failQueueOperation() throws ActionException {
        String message = "The workorder selected to move is no longer in the queue.";
        throw new ActionException(message, "QE-100");
    }

    private Long getResourceTypeIdForRequest() {
        return this.localResourceTypeId.get();
    }

    @Override
    public void setResourceTypeIdForRequest(Long resourceTypeId) {
        this.localResourceTypeId.set(resourceTypeId);
    }

    @Override
    public void removeResourceTypeIdForRequest() {
        this.localResourceTypeId.remove();
    }

    private ResourceGroup clone(ResourceGroup group) {
        return this.getCloneService().cloneResourceGroup(group);
    }

    private ResourceGroup cloneWithQueueProxy(ResourceGroup group) {
        return this.getCloneService().cloneResourceGroup(group, true, true);
    }

    @Override
    public String getServiceName() {
        return "LocalResourceGroupService";
    }

    private IDistributedCache<ResourceType> getResourceTypeCache() {
        return (IDistributedCache)this.getService("WFS:ResourceTypeCache");
    }

    private IMultiValueCacheService<ResourceGroup> getResourceGroupCache() {
        return (IMultiValueCacheService)this.getService("WFS:ResourceGroupCache");
    }

    private IMultiValueCacheService<Resource> getResourceCache() {
        return (IMultiValueCacheService)this.getService("WFS:ResourceCache");
    }

    private ICacheService<ResourceGroupContainer> getResourceGroupContainerCache() {
        return (ICacheService)this.getService("ResourceGroupContainerCache");
    }

    private ILocatorService getLocatorService() {
        return this.getService(ILocatorService.class);
    }

    private IHibernatePersistenceService getPersistenceService() {
        return this.getService(IHibernatePersistenceService.class);
    }

    private ICloneService getCloneService() {
        return this.getService(ICloneService.class);
    }

    private IResourceAllocationService getAllocationService() {
        return this.getService(IResourceAllocationService.class);
    }

    private IContainerService getContainerService() {
        return this.getService(IContainerService.class);
    }
}

