/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.cluster;

import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.core.Partition;
import com.tandbergtv.workflow.core.service.cluster.IClusterService;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Set;

public class ClusterService
implements IClusterService {
    private volatile HazelcastInstance instance;
    private final Config config;

    public ClusterService(Config config) {
        this.config = config;
    }

    @Override
    public String getServiceName() {
        return ClusterService.class.getName();
    }

    @Override
    public void start() {
        this.instance = Hazelcast.newHazelcastInstance((Config)this.config);
    }

    @Override
    public void stop() {
        if (this.instance != null) {
            this.instance.shutdown();
        }
    }

    @Override
    public HazelcastInstance getInstance() {
        return this.instance;
    }

    @Override
    public Member getMaster() {
        return (Member)this.instance.getCluster().getMembers().iterator().next();
    }

    @Override
    public Member getLocalMember() {
        return this.instance.getCluster().getLocalMember();
    }

    @Override
    public Member getMemberByAddress(InetSocketAddress address) {
        for (Member member : this.instance.getCluster().getMembers()) {
            if (!member.getSocketAddress().equals(address)) continue;
            return member;
        }
        return null;
    }

    @Override
    public Partition getPartition(Object key) {
        return this.instance.getPartitionService().getPartition(key);
    }

    @Override
    public boolean owner(Object key) {
        return this.getLocalMember().equals(this.getPartition(key).getOwner());
    }

    @Override
    public int getPartitionId(Object key) {
        return this.getPartition(key).getPartitionId();
    }

    @Override
    public String getMemberName(Object key) {
        return this.getPartition(key).getOwner().toString();
    }

    @Override
    public Set<Member> members() {
        HashSet<Member> members = new HashSet<Member>(this.instance.getCluster().getMembers());
        members.remove(this.getLocalMember());
        return members;
    }

    @Override
    public boolean isMember(InetSocketAddress address) {
        return this.getMemberByAddress(address) != null;
    }

    @Override
    public boolean isMember(Member member) {
        return this.instance.getCluster().getMembers().contains(member);
    }

    @Override
    public boolean isLocalMember(InetSocketAddress address) {
        return this.getLocalMember().getSocketAddress().equals(address);
    }

    @Override
    public boolean isMaster() {
        return this.getMaster().equals(this.getLocalMember());
    }

    @Override
    public long generateId(String type) {
        return this.instance.getIdGenerator(type).newId();
    }
}

