/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.rest.services.test;

import com.tandbergtv.workflow.resourcemanager.DataOperationException;
import com.tandbergtv.workflow.resourcemanager.ResourceManagementException;
import com.tandbergtv.workflow.resourcemanager.ValidationException;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.rest.services.internal.ResourcesResource;
import com.tandbergtv.workflow.rest.services.test.MockRequestType;
import com.tandbergtv.workflow.rest.services.test.RESTServiceMockTestBase;
import com.tandbergtv.workflow.rest.services.test.RESTUtil;
import com.tandbergtv.workflow.test.util.ResourceUtils;
import com.tandbergtv.workflow.test.util.TestUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.jboss.resteasy.mock.MockHttpResponse;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"sequential"})
public class ResourcesGetListTest
extends RESTServiceMockTestBase {
    private static final String BASE_API_PATH = "/resources";
    private static final String PREFIX = "ResourcesREST_";
    private static final String RESOURCE_TYPE_SYSTEM_ID = "27";
    private static final String RESOURCES_FIELD_NAME = "resources";
    private static final String RESOURCEGROUP_FIELD_NAME = "resourceGroups";
    private static final String PARAM_DETAILS_FULL = "?detail=full";
    private static final String PARAM_DETAILS_SUMMARY = "?detail=summary";
    private static final String CONNECTION_STRING_BASE = "http://localhost:8080/";
    private static final long HEARTBEAT_FREQUENCY = 10L;
    private static final int LIST_SIZE = 2;
    private static final boolean IGNORE_TIMEOUT = false;
    private static int totalInDB = 0;
    private static int totalInDBWithSystemId = 0;
    private static List<Resource> expectedResources;

    public ResourcesGetListTest() {
        super(ResourcesResource.class);
    }

    @BeforeClass
    public void setResources() throws DataOperationException, ValidationException {
        expectedResources = this.initializeResource();
    }

    @AfterTest
    public void cleanupResources() throws ResourceManagementException {
        ResourceUtils.deleteResourcesWithPrefix(RESOURCE_TYPE_SYSTEM_ID, PREFIX);
    }

    @Test
    public void testResourceListGet() throws Exception {
        this.performGetResourceList(BASE_API_PATH, 0, 10, 0, false);
    }

    @Test
    public void testResourceListGetDetailFull() throws Exception {
        String url = "/resources?detail=full";
        this.performGetResourceList(url, 0, 10, 2, false);
    }

    @Test
    public void testResourceListGetDetailSummary() throws Exception {
        String url = "/resources?detail=summary";
        this.performGetResourceList(url, 0, 10, 1, false);
    }

    @Test
    public void testResourceListGetWithSystemID() throws Exception {
        String url = "/resources?systemId=27";
        this.performGetResourceList(url, 0, 10, 0, true);
    }

    @Test
    public void testResourceGroupGetAllWithStartAndCountParam() throws Exception {
        String url = "/resources?count=2&start=0";
        this.performGetResourceList(url, 0, 2, 0, false);
    }

    @Test
    public void testResourceGroupGetAllWithInvalidStartParam() throws Exception {
        String uri = "/resources?start=-1";
        MockHttpResponse response = this.execute(uri, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        ResourcesGetListTest.assertEquals((int)response.getStatus(), (int)400);
    }

    @Test
    public void testResourceGroupGetAllWithInvalidCountParam() throws Exception {
        String uri = "/resources?count=-1";
        MockHttpResponse response = this.execute(uri, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        ResourcesGetListTest.assertEquals((int)response.getStatus(), (int)400);
    }

    @Test
    public void testResourceGroupGetAllWithInvalidDetailParam() throws Exception {
        String uri = "/resources?detail=" + System.currentTimeMillis();
        MockHttpResponse response = this.execute(uri, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        ResourcesGetListTest.assertEquals((int)response.getStatus(), (int)400);
    }

    @Test
    public void testWhenNoVersionHeaderIsSent() throws Exception {
        String uri = BASE_API_PATH;
        MockHttpResponse response = this.execute(uri, new HashMap<String, String>(), MockRequestType.GET);
        ResourcesGetListTest.assertEquals((int)response.getStatus(), (int)412);
    }

    @Test
    public void testInvalidVersionHeader() throws Exception {
        String uri = BASE_API_PATH;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-API-Version", "2");
        MockHttpResponse response = this.execute(uri, headers, MockRequestType.GET);
        ResourcesGetListTest.assertEquals((int)response.getStatus(), (int)412);
    }

    private void performGetResourceList(String url, int start, int count, int detail, boolean withSystemId) throws Exception {
        totalInDB = TestUtil.getResourceManagement().getAllResources().size();
        totalInDBWithSystemId = TestUtil.getResourceManagement().getResourcesBySystemId(RESOURCE_TYPE_SYSTEM_ID).size();
        MockHttpResponse response = this.execute(url, RESTUtil.setDefaultHeaders(), MockRequestType.GET);
        ResourcesGetListTest.assertEquals((int)response.getStatus(), (int)200);
        Map<String, Object> resourceMap = RESTUtil.deserialize(response);
        List resources = (List)resourceMap.get(RESOURCES_FIELD_NAME);
        ArrayList actualResources = new ArrayList();
        actualResources.add(resources.get(1));
        actualResources.add(resources.get(0));
        this.verifyResponse(resourceMap, expectedResources, start, count, detail, url, withSystemId);
    }

    private List<Resource> initializeResource() throws DataOperationException, ValidationException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (int i = 0; i < 2; ++i) {
            resources.add(this.createResource());
        }
        return resources;
    }

    private Resource createResource() throws DataOperationException, ValidationException {
        String uniqueName = PREFIX + System.currentTimeMillis();
        String connectionString = CONNECTION_STRING_BASE + uniqueName;
        Resource resource = ResourceUtils.createResource(ResourceUtils.getResourceBuilderFromSystemId(RESOURCE_TYPE_SYSTEM_ID, PREFIX).name(uniqueName).connectionString(connectionString).heartbeatConnectionString(connectionString).heartbeatFrequency(10L).ignoreTimeout(false));
        return resource;
    }

    private void verifyResponse(Map<String, Object> responseMap, List<Resource> expected, int start, int count, int detail, String uri, boolean withSystemId) throws JsonParseException, JsonMappingException, IOException, ResourceManagementException {
        this.verifyPagingParametersInResponse(responseMap, start, count, uri, withSystemId);
        this.verifyResourcesList(responseMap, expected, start, count, detail);
    }

    private void verifyPagingParametersInResponse(Map<String, Object> responseMap, int start, int count, String uri, boolean withSystemId) throws JsonParseException, JsonMappingException, IOException {
        int total = Integer.valueOf(responseMap.get("total").toString());
        if (withSystemId) {
            ResourcesGetListTest.assertEquals((int)total, (int)totalInDBWithSystemId);
        } else {
            ResourcesGetListTest.assertEquals((int)total, (int)totalInDB);
        }
        ResourcesGetListTest.assertEquals((Object)responseMap.get("start"), (Object)start);
        ResourcesGetListTest.assertEquals((Object)responseMap.get("count"), (Object)count);
        if (total > start + count) {
            ResourcesGetListTest.assertEquals((Object)responseMap.get("next"), (Object)("http://localhost:8081" + RESTUtil.getExpectedUrl(uri, start, start + count)));
        } else {
            ResourcesGetListTest.assertFalse((boolean)responseMap.containsKey("next"));
        }
        if (start > 0) {
            if (start - count < 0) {
                ResourcesGetListTest.assertEquals((Object)responseMap.get("prev"), (Object)("http://localhost:8081" + RESTUtil.getExpectedUrl(uri, start, 0)));
            } else {
                ResourcesGetListTest.assertEquals((Object)responseMap.get("prev"), (Object)("http://localhost:8081" + RESTUtil.getExpectedUrl(uri, start, start - count)));
            }
            ResourcesGetListTest.assertEquals((Object)responseMap.get("first"), (Object)("http://localhost:8081" + RESTUtil.getExpectedUrl(uri, start, 0)));
        } else {
            ResourcesGetListTest.assertFalse((boolean)responseMap.containsKey("prev"));
            ResourcesGetListTest.assertFalse((boolean)responseMap.containsKey("first"));
        }
    }

    private void verifyResourcesList(Map<String, Object> responseMap, List<Resource> expected, int start, int count, int detail) throws JsonParseException, JsonMappingException, IOException, ResourceManagementException {
        List actual = (List)responseMap.get(RESOURCES_FIELD_NAME);
        actual = actual.subList(0, 2);
        int endIndex = Math.min(expected.size(), start + count);
        List<Object> resources = start < endIndex ? expected.subList(start, endIndex) : Collections.emptyList();
        ResourcesGetListTest.assertEquals((int)resources.size(), (int)actual.size());
        int i = 1;
        for (Resource resource : resources) {
            this.verifyResponseParametersFull((Map)actual.get(i), resource, detail);
            --i;
        }
    }

    private void verifyListParameters(Map<String, Object> actual, Resource expected) {
        ResourcesGetListTest.assertEquals((String)actual.get("id").toString(), (String)String.valueOf(expected.getId()));
        ResourcesGetListTest.assertEquals((String)actual.get("name").toString(), (String)expected.getName());
        ResourcesGetListTest.assertEquals((Object)actual.get("href"), (Object)("http://localhost:8081/resources/" + String.valueOf(expected.getId())));
        ResourcesGetListTest.assertEquals((String)actual.get("userCount").toString(), (String)String.valueOf(expected.getUserCount()));
    }

    private void verifySummaryParameters(Map<String, Object> actual, Resource expected) {
        ResourcesGetListTest.assertEquals((String)actual.get("adminState").toString(), (String)expected.getAdministrationState().toString());
        ResourcesGetListTest.assertEquals((String)actual.get("operationalState").toString(), (String)expected.getOperationalState().toString());
    }

    private void verifyResponseParametersFull(Map<String, Object> actual, Resource expected, int detail) throws JsonParseException, JsonMappingException, IOException, ResourceManagementException {
        this.verifyListParameters(actual, expected);
        if (detail >= 1) {
            this.verifySummaryParameters(actual, expected);
        }
        if (detail >= 2) {
            ResourcesGetListTest.assertEquals((String)actual.get("resourceTypeName").toString(), (String)expected.getResourceType().getName());
            ResourcesGetListTest.assertEquals((String)actual.get("connectionString").toString(), (String)expected.getConnectionString());
            ResourcesGetListTest.assertEquals((String)actual.get("maxConcurrentUsage").toString(), (String)String.valueOf(expected.getMaxConcurrentUsers()));
            ResourcesGetListTest.assertEquals((String)actual.get("ignoreTimeOut").toString(), (String)String.valueOf(expected.getIgnoreTimeout()));
            List resourceGroupsFromResponse = (List)actual.get(RESOURCEGROUP_FIELD_NAME);
            this.verifyResourceGroups(resourceGroupsFromResponse, this.buildExpectedResourceGroups(expected.getResourceGroups(), BASE_API_PATH));
        }
    }

    private List<Map<String, String>> buildExpectedResourceGroups(Set<ResourceGroup> resourceGroups, String resourcePath) {
        ArrayList<Map<String, String>> stringsList = new ArrayList<Map<String, String>>();
        for (ResourceGroup group : resourceGroups) {
            HashMap<String, String> strings = new HashMap<String, String>();
            strings.put("id", String.valueOf(group.getId()));
            strings.put("name", group.getName());
            strings.put("href", "http://localhost:8081/resourceGroups/" + group.getId());
            strings.put("queueSize", String.valueOf(group.getQueue().size()));
            stringsList.add(strings);
        }
        return stringsList;
    }

    private void verifyResourceGroups(List<Map<String, Object>> responseGroups, List<Map<String, String>> expectedGroups) throws JsonParseException, JsonMappingException, IOException {
        for (Map<String, String> expected : expectedGroups) {
            boolean foundMatch = false;
            for (Map<String, Object> response : responseGroups) {
                if (!expected.get("id").equals(response.get("id").toString())) continue;
                foundMatch = true;
                ResourcesGetListTest.assertEquals((String)expected.get("name"), (String)response.get("name").toString());
                ResourcesGetListTest.assertEquals((String)expected.get("href"), (String)response.get("href").toString());
                ResourcesGetListTest.assertEquals((String)expected.get("queueSize"), (String)response.get("queueSize").toString());
            }
            if (foundMatch) continue;
            ResourcesGetListTest.fail((String)("The Response was missing a resourceGroup entry for resource group id: " + expected.get("id")));
        }
    }
}

