/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.unit.test;

import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.resourcemanager.DataOperationException;
import com.tandbergtv.workflow.resourcemanager.FinderException;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ValidationException;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceState;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.rest.services.internal.ResourcesResource;
import com.tandbergtv.workflow.rest.services.test.RESTUtil;
import com.tandbergtv.workflow.unit.test.RESTMockUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ServiceRegistry.class})
public class ResourcesResourceUnitTest {
    private static final String BASE_API_PATH = "/resources/";
    private static final String NAME_API_PATH = "/resources/name/";
    private static final String CONNECTION_STRING_BASE = "testConnectionString";
    private static final String RESOURCE_NAME = "testResource";
    private static final long HEARTBEAT_FREQUENCY = 10L;
    private static final boolean IGNORE_TIMEOUT = false;
    private static final String RESOURCE_TYPE = "testResourceType";
    private static final String RESOURCE_GROUP1_NAME = "group1";
    private static final String RESOURCE_GROUP2_NAME = "group2";
    private static final String RESOURCE_GROUP_FIELD_NAME = "resourceGroups";
    private static final int MAX_CONCURRENT_USERS = 3;
    private static ResourceManagement resourceManagement;
    private static ServiceRegistry registry;
    private static RESTMockUtil restUtil;

    public ResourcesResourceUnitTest() {
        restUtil = new RESTMockUtil(ResourcesResource.class);
    }

    @Before
    public void setup() throws Exception {
        registry = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
        resourceManagement = (ResourceManagement)PowerMockito.mock(ResourceManagement.class);
        PowerMockito.mockStatic(ServiceRegistry.class, (Class[])new Class[0]);
        Mockito.when((Object)ServiceRegistry.getDefault()).thenReturn((Object)registry);
        Mockito.when((Object)registry.lookup(ResourceManagement.class)).thenReturn((Object)resourceManagement);
    }

    @Test
    public void testResourceNameGet() throws Exception {
        Resource resource = this.initializeResource();
        Mockito.when((Object)resourceManagement.getResourceByName(RESOURCE_NAME)).thenReturn((Object)resource);
        String uri = NAME_API_PATH + resource.getName();
        Map<String, Object> responseMap = restUtil.getResponseMap(uri);
        Assert.assertEquals((Object)RESOURCE_NAME, (Object)responseMap.get("name").toString());
        Assert.assertEquals((Object)ResourceState.ONLINE.toString(), (Object)responseMap.get("adminState").toString());
        Assert.assertEquals((Object)ResourceState.OFFLINE.toString(), (Object)responseMap.get("operationalState").toString());
        Assert.assertEquals((Object)RESOURCE_TYPE, (Object)responseMap.get("resourceTypeName").toString());
        Assert.assertEquals((Object)CONNECTION_STRING_BASE, (Object)responseMap.get("connectionString").toString());
        Assert.assertEquals((Object)String.valueOf(3), (Object)responseMap.get("maxConcurrentUsage").toString());
        Assert.assertEquals((Object)String.valueOf(false), (Object)responseMap.get("ignoreTimeOut").toString());
        Assert.assertEquals((Object)String.valueOf(0), (Object)responseMap.get("userCount").toString());
        Assert.assertNotNull((Object)responseMap.get("href").toString());
        List groups = (List)responseMap.get(RESOURCE_GROUP_FIELD_NAME);
        Assert.assertEquals((long)2L, (long)groups.size());
        for (Map group : groups) {
            Assert.assertTrue((group.get("name").toString().contains(RESOURCE_GROUP1_NAME) || group.get("name").toString().contains(RESOURCE_GROUP2_NAME) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testResourceNameNotFound() throws Exception {
        Long name = System.currentTimeMillis();
        Mockito.when((Object)resourceManagement.getResourceByName(String.valueOf(name))).thenThrow(new Throwable[]{new FinderException()});
        String uri = NAME_API_PATH + String.valueOf(name);
        Assert.assertEquals((long)404L, (long)restUtil.executeGet(uri, RESTUtil.setDefaultHeaders()).getStatus());
    }

    @Test
    public void testGetResourceByNameThrowsException() throws Exception {
        Long name = System.currentTimeMillis();
        Mockito.when((Object)resourceManagement.getResourceByName(String.valueOf(name))).thenThrow(new Throwable[]{new RuntimeException()});
        String uri = NAME_API_PATH + String.valueOf(name);
        Assert.assertEquals((long)500L, (long)restUtil.executeGet(uri, RESTUtil.setDefaultHeaders()).getStatus());
    }

    @Test
    public void testResourceIsNull() throws Exception {
        Long name = System.currentTimeMillis();
        Mockito.when((Object)resourceManagement.getResourceByName(String.valueOf(name))).thenReturn(null);
        String uri = NAME_API_PATH + String.valueOf(name);
        Assert.assertEquals((long)404L, (long)restUtil.executeGet(uri, RESTUtil.setDefaultHeaders()).getStatus());
    }

    @Test
    public void testWhenNoVersionHeaderIsSent() throws Exception {
        String uri = "/resources/name/testResource";
        Assert.assertEquals((long)412L, (long)restUtil.executeGet(uri, new HashMap<String, String>()).getStatus());
    }

    @Test
    public void testInvalidVersionHeader() throws Exception {
        String uri = "/resources/name/testResource";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-API-Version", "2");
        Assert.assertEquals((long)412L, (long)restUtil.executeGet(uri, headers).getStatus());
    }

    @Test
    public void testResourceIdGet() throws Exception {
        Resource resource = this.initializeResource();
        Mockito.when((Object)resourceManagement.getResource(1L)).thenReturn((Object)resource);
        String uri = "/resources/1";
        Map<String, Object> responseMap = restUtil.getResponseMap(uri);
        Assert.assertEquals((Object)RESOURCE_NAME, (Object)responseMap.get("name").toString());
        Assert.assertEquals((Object)ResourceState.ONLINE.toString(), (Object)responseMap.get("adminState").toString());
        Assert.assertEquals((Object)ResourceState.OFFLINE.toString(), (Object)responseMap.get("operationalState").toString());
        Assert.assertEquals((Object)RESOURCE_TYPE, (Object)responseMap.get("resourceTypeName").toString());
        Assert.assertEquals((Object)CONNECTION_STRING_BASE, (Object)responseMap.get("connectionString").toString());
        Assert.assertEquals((Object)String.valueOf(3), (Object)responseMap.get("maxConcurrentUsage").toString());
        Assert.assertEquals((Object)String.valueOf(false), (Object)responseMap.get("ignoreTimeOut").toString());
        Assert.assertEquals((Object)String.valueOf(0), (Object)responseMap.get("userCount").toString());
        Assert.assertNotNull((Object)responseMap.get("href").toString());
        List groups = (List)responseMap.get(RESOURCE_GROUP_FIELD_NAME);
        Assert.assertEquals((long)2L, (long)groups.size());
        for (Map group : groups) {
            Assert.assertTrue((group.get("name").toString().contains(RESOURCE_GROUP1_NAME) || group.get("name").toString().contains(RESOURCE_GROUP2_NAME) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testResourceNotFound() throws Exception {
        Mockito.when((Object)resourceManagement.getResource(0L)).thenThrow(new Throwable[]{new FinderException()});
        String uri = "/resources/0";
        Assert.assertEquals((long)404L, (long)restUtil.executeGet(uri, RESTUtil.setDefaultHeaders()).getStatus());
    }

    @Test
    public void testGetResourceByIdInvalidVersionHeader() throws Exception {
        String uri = "/resources/1";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-API-Version", "2");
        Assert.assertEquals((long)412L, (long)restUtil.executeGet(uri, headers).getStatus());
    }

    @Test
    public void testGetResourceByIdThrowsException() throws Exception {
        Mockito.when((Object)resourceManagement.getResource(1L)).thenThrow(new Throwable[]{new RuntimeException()});
        String uri = "/resources/1";
        Assert.assertEquals((long)500L, (long)restUtil.executeGet(uri, RESTUtil.setDefaultHeaders()).getStatus());
    }

    @Test
    public void testGetResourceListThrowsException() throws Exception {
        Mockito.when((Object)resourceManagement.getAllResources()).thenThrow(new Throwable[]{new RuntimeException()});
        String uri = BASE_API_PATH;
        Assert.assertEquals((long)500L, (long)restUtil.executeGet(uri, RESTUtil.setDefaultHeaders()).getStatus());
    }

    private Resource initializeResource() throws DataOperationException, ValidationException {
        ResourceType resType = new ResourceType();
        resType.setName(RESOURCE_TYPE);
        ResourceGroup resGrp1 = new ResourceGroup();
        ResourceGroup resGrp2 = new ResourceGroup();
        resGrp1.setName(RESOURCE_GROUP1_NAME);
        resGrp2.setName(RESOURCE_GROUP2_NAME);
        HashSet<ResourceGroup> groups = new HashSet<ResourceGroup>();
        groups.add(resGrp1);
        groups.add(resGrp2);
        Resource resource = new Resource();
        resource.setResourceGroups(groups);
        resource.setName(RESOURCE_NAME);
        resource.setConnectionString(CONNECTION_STRING_BASE);
        resource.setMaxConcurrentUsers(3);
        resource.setHeartbeatFrequency(Long.valueOf(10L));
        resource.setResourceType(resType);
        resource.setIgnoreTimeout(false);
        return resource;
    }
}

