/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.test.util;

import com.ericsson.cms.test.StandardUnitTestEntry;
import com.ericsson.cms.test.client.Command;
import com.ericsson.cms.test.client.RunTestCommand;
import com.ericsson.cms.test.client.TestClientConfig;
import com.ericsson.cms.test.client.TestClientException;
import com.ericsson.cms.test.client.TestResultsCache;
import com.ericsson.cms.test.client.TestRunResults;
import com.ericsson.cms.test.client.report.junit.JunitReportJaxbService;
import com.ericsson.cms.test.util.DateUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MyTestClient {
    private static Logger logger = Logger.getLogger(MyTestClient.class);
    private TestClientConfig config = new TestClientConfig();
    private String testRunId = DateUtil.getUTCTimestamp();
    private String testPackageName;
    private String componentName;
    private File configFile;

    public MyTestClient(String confFile, String testPackageName, String componentName) {
        this.testPackageName = testPackageName;
        this.componentName = componentName;
        this.configFile = new File(confFile);
    }

    public void run() throws TestClientException {
        this.readConfigFile();
        List<Command> commands = this.readCommands();
        this.runCommands(commands);
        this.generateReports();
    }

    private void readConfigFile() throws TestClientException {
        logger.info((Object)("Reading config file " + this.configFile.getAbsolutePath()));
        this.config.load(this.configFile);
    }

    public List<Command> readCommands() {
        ArrayList<Command> list = new ArrayList<Command>();
        try {
            RunTestCommand cmd = new RunTestCommand(StandardUnitTestEntry.class.getSimpleName(), "testNG", this.testPackageName, this.componentName, this.testRunId, this.config);
            list.add((Command)cmd);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        return list;
    }

    private void runCommands(List<Command> commands) {
        int len = commands.size();
        for (int i = 0; i < commands.size(); ++i) {
            logger.info((Object)("Running command " + (i + 1) + " of " + len + "..."));
            try {
                Command cmd = commands.get(i);
                cmd.run();
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void generateReports() {
        logger.info((Object)"Generating reports...");
        TestRunResults results = TestResultsCache.getInstance().getTestRunResults();
        try {
            File reportFile = new File("TestReport.xml");
            FileWriter writer = new FileWriter(reportFile);
            JunitReportJaxbService service = new JunitReportJaxbService();
            service.marshalTestRunResults(results, (Writer)writer);
            writer.close();
            logger.info((Object)"Done");
        }
        catch (Exception ex) {
            logger.error((Object)"Could not generate report", (Throwable)ex);
        }
    }
}

