/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.test;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.search.elasticsearch.IWFSElasticSearchPersistanceHelper;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;

public class WorkflowTestBase
extends Assert {
    protected Set<WorkflowProcess> createdProcesses = new HashSet<WorkflowProcess>();
    protected static final long PROCESS_START_TIMEOUT = 5000L;

    @AfterMethod
    public void afterMethod() throws Exception {
        for (WorkflowProcess p : this.createdProcesses) {
            p = ProcessUtils.get(p.getId());
            ProcessUtils.getProcessManager().cancel(p.getRootToken()).get();
            ProcessUtils.getProcessManager().delete(p).get();
            this.deleteProcess(p);
        }
        this.createdProcesses.clear();
    }

    private void deleteProcess(WorkflowProcess p) throws Exception {
        if (p.getSubProcessInstances() != null) {
            for (WorkflowProcess sub : p.getSubProcessInstances()) {
                this.deleteProcess(sub);
            }
        }
        this.getWFSElasticSearchPersistanceHelper().delete(p.getId());
    }

    protected Set<WorkflowProcess> getCreatedProcesses() {
        return this.createdProcesses;
    }

    protected WorkflowProcess run(String template, Map<String, Object> params) throws DriverException {
        WorkflowProcess wp = ProcessUtils.create(template, params);
        this.getCreatedProcesses().add(wp);
        return wp;
    }

    protected WorkflowProcess run(String template) throws DriverException {
        WorkflowProcess wp = ProcessUtils.create(template, new HashMap<String, Object>());
        this.getCreatedProcesses().add(wp);
        return wp;
    }

    protected List<WorkflowProcess> runMultiple(String template, Map<String, Object> params, int numberToRun) throws DriverException {
        ArrayList<WorkflowProcess> processes = new ArrayList<WorkflowProcess>();
        for (int i = 0; i < numberToRun; ++i) {
            WorkflowProcess wp = this.run(template, params);
            processes.add(wp);
        }
        return processes;
    }

    protected List<WorkflowProcess> runMultiple(String template, int numberToRun) throws DriverException {
        return this.runMultiple(template, new HashMap<String, Object>(), numberToRun);
    }

    protected int numberOfProcessesOfStatus(final ProcessStatus status) {
        Collection filtered = Collections2.filter(this.createdProcesses, (Predicate)new Predicate<WorkflowProcess>(){

            public boolean apply(WorkflowProcess p) {
                return ProcessUtils.get(p.getId()).getRootToken().getStatus().equals((Object)status);
            }
        });
        return filtered.size();
    }

    protected IWFSElasticSearchPersistanceHelper getWFSElasticSearchPersistanceHelper() {
        return (IWFSElasticSearchPersistanceHelper)ServiceRegistry.getDefault().lookup(IWFSElasticSearchPersistanceHelper.class);
    }
}

