/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.watchfolder.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;

public class WatchfolderProperties
extends Properties {
    private static final long serialVersionUID = -2440412148987996833L;
    private static WatchfolderProperties m_Instance;
    public final String PROPERTIES_FILE_PATH = "/watchfolder.properties";

    private WatchfolderProperties() {
    }

    public static synchronized WatchfolderProperties getInstance() throws InvalidPropertiesFormatException, IOException {
        if (m_Instance == null) {
            m_Instance = new WatchfolderProperties();
            m_Instance.loadProperties();
        }
        return m_Instance;
    }

    private void loadProperties() throws InvalidPropertiesFormatException, IOException {
        InputStream inStream = this.getClass().getResourceAsStream("/watchfolder.properties");
        this.loadFromXML(inStream);
        this.updateURLProperties();
    }

    private void updateURLProperties() {
        String[] urlProperties;
        for (String urlProperty : urlProperties = new String[]{"ConnectionString", "SourceURL"}) {
            String urlValue = this.getProperty(urlProperty);
            try {
                URL url = new URL(urlValue);
                String ipAddress = InetAddress.getByName(url.getHost()).getHostAddress();
                URL updatedUrl = new URL(url.getProtocol(), ipAddress, url.getPort(), url.getFile());
                this.setProperty(urlProperty, updatedUrl.toExternalForm());
            }
            catch (Exception e) {
                String msg = "Failed to replace host name with IP Address for URL Property: " + urlProperty + " with value: " + urlValue;
                throw new RuntimeException(msg, e);
            }
        }
    }
}

