/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import java.io.IOException;
import jodd.lagarto.Tag;
import jodd.lagarto.dom.Document;
import jodd.lagarto.dom.Node;

public class Element
extends Node {
    protected final boolean voidElement;
    protected final boolean selfClosed;

    public Element(Document ownerNode, Tag tag, boolean voidElement, boolean selfClosed) {
        super(ownerNode, Node.NodeType.ELEMENT, tag.getName());
        this.voidElement = voidElement;
        this.selfClosed = selfClosed;
        int attrCount = tag.getAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            String key = tag.getAttributeName(i);
            String value = tag.getAttributeValue(i);
            this.setAttribute(key, value);
        }
    }

    public Element(Document ownerDocument, String name) {
        this(ownerDocument, name, false, false);
    }

    public Element(Document ownerDocument, String name, boolean voidElement, boolean selfClosed) {
        super(ownerDocument, Node.NodeType.ELEMENT, name);
        this.voidElement = voidElement;
        this.selfClosed = selfClosed;
    }

    public Element clone() {
        return this.cloneTo(new Element(this.ownerDocument, this.nodeName, this.voidElement, this.selfClosed));
    }

    public boolean isVoidElement() {
        return this.voidElement;
    }

    public boolean isSelfClosed() {
        return this.selfClosed;
    }

    public void toHtml(Appendable appendable) throws IOException {
        this.ownerDocument.getRenderer().renderElement(this, appendable);
    }

    public String toString() {
        return '<' + this.nodeName + '>';
    }
}

