/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeIterator<T>
implements Iterator<T> {
    protected final List<Iterator<T>> allIterators = new ArrayList<Iterator<T>>();
    protected int currentIterator = -1;

    public CompositeIterator() {
    }

    public CompositeIterator(Iterator<T> ... iterators) {
        for (Iterator<T> iterator : iterators) {
            this.add(iterator);
        }
    }

    public void add(Iterator<T> iterator) {
        if (this.allIterators.contains(iterator)) {
            throw new IllegalArgumentException("Duplicate iterator");
        }
        this.allIterators.add(iterator);
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator == -1) {
            this.currentIterator = 0;
        }
        for (int i = this.currentIterator; i < this.allIterators.size(); ++i) {
            Iterator<T> iterator = this.allIterators.get(i);
            if (!iterator.hasNext()) continue;
            this.currentIterator = i;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.allIterators.get(this.currentIterator).next();
    }

    @Override
    public void remove() {
        if (this.currentIterator == -1) {
            throw new IllegalStateException("The next() has not yet been called");
        }
        this.allIterators.get(this.currentIterator).remove();
    }
}

