/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.save;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JComponent;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.xmlgraphics.image.codec.png.PNGEncodeParam;
import org.apache.xmlgraphics.image.codec.png.PNGImageEncoder;
import org.apache.xmlgraphics.image.codec.tiff.TIFFEncodeParam;
import org.apache.xmlgraphics.image.codec.tiff.TIFFImageEncoder;
import org.apache.xmlgraphics.image.codec.util.ImageEncodeParam;

public class SaveGraphicsService {
    public static final int PNG = 0;
    public static final int TIFF = 1;
    public static final String PNG_EXTENSION = ".png";
    public static final String TIFF_EXTENSION = ".tif";
    public static final String JPEG_EXTENSION = ".jpg";

    public void saveJComponent(String filename, int type, JComponent component) {
        Dimension size = component.getSize();
        BufferedImage image = new BufferedImage(size.width, size.height, 13);
        Graphics2D grp = image.createGraphics();
        component.paint(grp);
        if (type == 0) {
            filename = filename + PNG_EXTENSION;
            this.savePNGWithBatik(filename, image);
        } else if (type == 1) {
            filename = filename + TIFF_EXTENSION;
            this.saveTIFFWithBatik(filename, image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePNGWithBatik(String filename, BufferedImage image) {
        File outfile = new File(filename);
        FileOutputStream fos = this.createFile(outfile);
        if (fos == null) {
            return;
        }
        PNGEncodeParam param = PNGEncodeParam.getDefaultEncodeParam((RenderedImage)image);
        PNGImageEncoder encoder = new PNGImageEncoder((OutputStream)fos, param);
        try {
            encoder.encode((RenderedImage)image);
        }
        catch (IOException e) {
            JMeterUtils.reportErrorToUser("PNGImageEncoder reported: " + e.getMessage(), "Problem creating image file");
        }
        finally {
            JOrphanUtils.closeQuietly((Closeable)fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTIFFWithBatik(String filename, BufferedImage image) {
        File outfile = new File(filename);
        FileOutputStream fos = this.createFile(outfile);
        if (fos == null) {
            return;
        }
        TIFFEncodeParam param = new TIFFEncodeParam();
        TIFFImageEncoder encoder = new TIFFImageEncoder((OutputStream)fos, (ImageEncodeParam)param);
        try {
            encoder.encode((RenderedImage)image);
        }
        catch (IOException e) {
            JMeterUtils.reportErrorToUser("TIFFImageEncoder reported: " + e.getMessage(), "Problem creating image file");
        }
        catch (Error e) {
            JMeterUtils.reportErrorToUser("TIFFImageEncoder reported: " + e.getMessage(), "Problem creating image file");
            if (e.getClass() != Error.class) {
                throw e;
            }
        }
        finally {
            JOrphanUtils.closeQuietly((Closeable)fos);
        }
    }

    private FileOutputStream createFile(File filename) {
        try {
            return new FileOutputStream(filename);
        }
        catch (FileNotFoundException e) {
            JMeterUtils.reportErrorToUser("Could not create file: " + e.getMessage(), "Problem creating image file");
            return null;
        }
    }
}

