/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testbeans.gui.GenericTestBeanCustomizer;
import org.apache.jmeter.testbeans.gui.TypeEditor;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class BeanInfoSupport
extends SimpleBeanInfo {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String TAGS = "tags";
    public static final String NOT_UNDEFINED = "notUndefined";
    public static final String NOT_EXPRESSION = "notExpression";
    public static final String NOT_OTHER = "notOther";
    public static final String MULTILINE = "multiline";
    public static final String DEFAULT = "default";
    public static final String RESOURCE_BUNDLE = "resourceBundle";
    public static final String TEXT_LANGUAGE = "textLanguage";
    private final BeanInfo rootBeanInfo;
    private final BeanDescriptor beanDescriptor;
    private final Image[] icons = new Image[5];
    private final Class<?> beanClass;
    private int numCreatedGroups = 0;

    protected BeanInfoSupport(Class<? extends TestBean> beanClass) {
        this.beanClass = beanClass;
        try {
            this.rootBeanInfo = Introspector.getBeanInfo(beanClass, 2);
        }
        catch (IntrospectionException e) {
            throw new Error("Can't introspect " + beanClass, e);
        }
        this.beanDescriptor = this.rootBeanInfo.getBeanDescriptor();
        try {
            PropertyDescriptor[] properties;
            ResourceBundle resourceBundle = ResourceBundle.getBundle(beanClass.getName() + "Resources", JMeterUtils.getLocale());
            this.getBeanDescriptor().setValue(RESOURCE_BUNDLE, resourceBundle);
            if (resourceBundle.containsKey("displayName")) {
                this.getBeanDescriptor().setDisplayName(resourceBundle.getString("displayName"));
            } else {
                log.debug("Localized display name not available for bean " + beanClass);
            }
            for (PropertyDescriptor property : properties = this.getPropertyDescriptors()) {
                String name = property.getName();
                try {
                    property.setDisplayName(resourceBundle.getString(name + ".displayName"));
                }
                catch (MissingResourceException e) {
                    log.debug("Localized display name not available for property " + name + " in " + beanClass);
                }
                try {
                    property.setShortDescription(resourceBundle.getString(name + ".shortDescription"));
                }
                catch (MissingResourceException e) {
                    log.debug("Localized short description not available for property " + name + " in " + beanClass);
                }
            }
        }
        catch (MissingResourceException e) {
            log.warn("Localized strings not available for bean " + beanClass, (Throwable)e);
        }
        catch (Exception e) {
            log.warn("Something bad happened when loading bean info for bean " + beanClass, (Throwable)e);
        }
    }

    protected PropertyDescriptor property(String name) {
        for (PropertyDescriptor propdesc : this.getPropertyDescriptors()) {
            if (!propdesc.getName().equals(name)) continue;
            return propdesc;
        }
        log.error("Cannot find property: " + name + " in class " + this.beanClass);
        return null;
    }

    protected PropertyDescriptor property(String name, TypeEditor editor) {
        PropertyDescriptor property = this.property(name);
        if (property != null) {
            property.setValue("guiType", (Object)editor);
        }
        return property;
    }

    protected PropertyDescriptor property(String name, Class<? extends Enum<?>> enumClass) {
        PropertyDescriptor property = this.property(name);
        if (property != null) {
            property.setValue("guiType", enumClass);
            property.setValue(RESOURCE_BUNDLE, this.getBeanDescriptor().getValue(RESOURCE_BUNDLE));
        }
        return property;
    }

    protected void setIcon(String resourceName) {
        this.icons[1] = this.loadImage(resourceName);
    }

    protected void createPropertyGroup(String group, String[] names) {
        for (int i = 0; i < names.length; ++i) {
            log.debug("Getting property for: " + names[i]);
            PropertyDescriptor p = this.property(names[i]);
            p.setValue("group", group);
            p.setValue("order", i);
        }
        ++this.numCreatedGroups;
        this.getBeanDescriptor().setValue(GenericTestBeanCustomizer.ORDER(group), this.numCreatedGroups);
    }

    @Override
    public BeanInfo[] getAdditionalBeanInfo() {
        return this.rootBeanInfo.getAdditionalBeanInfo();
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return this.beanDescriptor;
    }

    @Override
    public int getDefaultEventIndex() {
        return this.rootBeanInfo.getDefaultEventIndex();
    }

    @Override
    public int getDefaultPropertyIndex() {
        return this.rootBeanInfo.getDefaultPropertyIndex();
    }

    @Override
    public EventSetDescriptor[] getEventSetDescriptors() {
        return this.rootBeanInfo.getEventSetDescriptors();
    }

    @Override
    public Image getIcon(int iconKind) {
        return this.icons[iconKind];
    }

    @Override
    public MethodDescriptor[] getMethodDescriptors() {
        return this.rootBeanInfo.getMethodDescriptors();
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.rootBeanInfo.getPropertyDescriptors();
    }
}

