/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.TransactionSampler;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.samplers.Interruptible;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testbeans.TestBeanHelper;
import org.apache.jmeter.testelement.AbstractScopedAssertion;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestIterationListener;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.FindTestElementsUpToRootTraverser;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterThreadMonitor;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jmeter.threads.SamplePackage;
import org.apache.jmeter.threads.TestCompiler;
import org.apache.jmeter.timers.Timer;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.SearchByClass;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterStopTestException;
import org.apache.jorphan.util.JMeterStopTestNowException;
import org.apache.jorphan.util.JMeterStopThreadException;
import org.apache.log.Logger;

public class JMeterThread
implements Runnable,
Interruptible {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String PACKAGE_OBJECT = "JMeterThread.pack";
    public static final String LAST_SAMPLE_OK = "JMeterThread.last_sample_ok";
    private static final String TRUE = Boolean.toString(true);
    private static final int RAMPUP_GRANULARITY = JMeterUtils.getPropDefault("jmeterthread.rampup.granularity", 1000);
    private final Controller controller;
    private final HashTree testTree;
    private final TestCompiler compiler;
    private final JMeterThreadMonitor monitor;
    private final JMeterVariables threadVars;
    private final Collection<TestIterationListener> testIterationStartListeners;
    private final ListenerNotifier notifier;
    private String threadName;
    private int initialDelay = 0;
    private int threadNum = 0;
    private long startTime = 0L;
    private long endTime = 0L;
    private boolean scheduler = false;
    private AbstractThreadGroup threadGroup;
    private StandardJMeterEngine engine = null;
    private volatile boolean running;
    private volatile boolean onErrorStopTest;
    private volatile boolean onErrorStopTestNow;
    private volatile boolean onErrorStopThread;
    private volatile boolean onErrorStartNextLoop;
    private volatile Sampler currentSampler;
    private final ReentrantLock interruptLock = new ReentrantLock();
    private static final boolean startEarlier = JMeterUtils.getPropDefault("jmeterthread.startearlier", true);
    private static final boolean reversePostProcessors = JMeterUtils.getPropDefault("jmeterthread.reversePostProcessors", false);

    public JMeterThread(HashTree test, JMeterThreadMonitor monitor, ListenerNotifier note) {
        this.monitor = monitor;
        this.threadVars = new JMeterVariables();
        this.testTree = test;
        this.compiler = new TestCompiler(this.testTree);
        this.controller = (Controller)this.testTree.getArray()[0];
        SearchByClass threadListenerSearcher = new SearchByClass(TestIterationListener.class);
        test.traverse((HashTreeTraverser)threadListenerSearcher);
        this.testIterationStartListeners = threadListenerSearcher.getSearchResults();
        this.notifier = note;
        this.running = true;
    }

    public void setInitialContext(JMeterContext context) {
        this.threadVars.putAll(context.getVariables());
    }

    public void setScheduled(boolean sche) {
        this.scheduler = sche;
    }

    public void setStartTime(long stime) {
        this.startTime = stime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setEndTime(long etime) {
        this.endTime = etime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    private void stopScheduler() {
        long now = System.currentTimeMillis();
        long delay = now - this.endTime;
        if (delay >= 0L) {
            this.running = false;
        }
    }

    private void startScheduler() {
        long delay = this.startTime - System.currentTimeMillis();
        this.delayBy(delay, "startScheduler");
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        JMeterContext threadContext = JMeterContextService.getContext();
        IterationListener iterationListener = null;
        try {
            iterationListener = this.initRun(threadContext);
            while (this.running) {
                Sampler sam = this.controller.next();
                while (this.running && sam != null) {
                    this.process_sampler(sam, null, threadContext);
                    threadContext.cleanAfterSample();
                    if (this.onErrorStartNextLoop || threadContext.isRestartNextLoop()) {
                        boolean lastSampleFailed;
                        if (threadContext.isRestartNextLoop()) {
                            this.triggerEndOfLoopOnParentControllers(sam, threadContext);
                            sam = null;
                            threadContext.getVariables().put(LAST_SAMPLE_OK, TRUE);
                            threadContext.setRestartNextLoop(false);
                            continue;
                        }
                        boolean bl = lastSampleFailed = !TRUE.equals(threadContext.getVariables().get(LAST_SAMPLE_OK));
                        if (lastSampleFailed) {
                            if (log.isDebugEnabled()) {
                                log.debug("StartNextLoop option is on, Last sample failed, starting next loop");
                            }
                            this.triggerEndOfLoopOnParentControllers(sam, threadContext);
                            sam = null;
                            threadContext.getVariables().put(LAST_SAMPLE_OK, TRUE);
                            continue;
                        }
                        sam = this.controller.next();
                        continue;
                    }
                    sam = this.controller.next();
                }
                if (!this.controller.isDone()) continue;
                this.running = false;
            }
        }
        catch (JMeterStopTestException e) {
            log.info("Stopping Test: " + e.toString());
            this.stopTest();
        }
        catch (JMeterStopTestNowException e) {
            log.info("Stopping Test Now: " + e.toString());
            this.stopTestNow();
        }
        catch (JMeterStopThreadException e) {
            log.info("Stop Thread seen: " + e.toString());
        }
        catch (Exception e) {
            log.error("Test failed!", (Throwable)e);
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Error e) {
            log.error("Test failed!", (Throwable)e);
        }
        finally {
            this.currentSampler = null;
            try {
                this.interruptLock.lock();
                threadContext.clear();
                log.info("Thread finished: " + this.threadName);
                this.threadFinished(iterationListener);
                this.monitor.threadFinished(this);
                JMeterContextService.removeContext();
            }
            finally {
                this.interruptLock.unlock();
            }
        }
    }

    private void triggerEndOfLoopOnParentControllers(Sampler sam, JMeterContext threadContext) {
        FindTestElementsUpToRootTraverser pathToRootTraverser = null;
        TransactionSampler transactionSampler = null;
        if (sam instanceof TransactionSampler) {
            transactionSampler = (TransactionSampler)sam;
            pathToRootTraverser = new FindTestElementsUpToRootTraverser(transactionSampler.getTransactionController());
        } else {
            pathToRootTraverser = new FindTestElementsUpToRootTraverser(sam);
        }
        this.testTree.traverse((HashTreeTraverser)pathToRootTraverser);
        List<Controller> controllersToReinit = pathToRootTraverser.getControllersToRoot();
        for (Controller parentController : controllersToReinit) {
            if (parentController instanceof AbstractThreadGroup) {
                AbstractThreadGroup tg = (AbstractThreadGroup)parentController;
                tg.startNextLoop();
                continue;
            }
            parentController.triggerEndOfLoop();
        }
        if (transactionSampler != null) {
            this.process_sampler(transactionSampler, null, threadContext);
        }
    }

    private SampleResult process_sampler(Sampler current, Sampler parent, JMeterContext threadContext) {
        SampleResult transactionResult = null;
        try {
            TransactionSampler transactionSampler = null;
            if (current instanceof TransactionSampler) {
                transactionSampler = (TransactionSampler)current;
            }
            SamplePackage transactionPack = null;
            if (transactionSampler != null) {
                transactionPack = this.compiler.configureTransactionSampler(transactionSampler);
                if (transactionSampler.isTransactionDone()) {
                    transactionResult = transactionSampler.getTransactionResult();
                    transactionResult.setThreadName(this.threadName);
                    transactionResult.setGroupThreads(this.threadGroup.getNumberOfThreads());
                    transactionResult.setAllThreads(JMeterContextService.getNumberOfThreads());
                    this.checkAssertions(transactionPack.getAssertions(), transactionResult, threadContext);
                    if (!(parent instanceof TransactionSampler)) {
                        this.notifyListeners(transactionPack.getSampleListeners(), transactionResult);
                    }
                    this.compiler.done(transactionPack);
                    current = null;
                } else {
                    Sampler prev = current;
                    current = transactionSampler.getSubSampler();
                    if (current instanceof TransactionSampler) {
                        SampleResult res = this.process_sampler(current, prev, threadContext);
                        threadContext.setCurrentSampler(prev);
                        current = null;
                        if (res != null) {
                            transactionSampler.addSubSamplerResult(res);
                        }
                    }
                }
            }
            if (current != null) {
                threadContext.setCurrentSampler(current);
                SamplePackage pack = this.compiler.configureSampler(current);
                this.runPreProcessors(pack.getPreProcessors());
                this.threadVars.putObject(PACKAGE_OBJECT, pack);
                this.delay(pack.getTimers());
                Sampler sampler = pack.getSampler();
                sampler.setThreadContext(threadContext);
                sampler.setThreadName(this.threadName);
                TestBeanHelper.prepare(sampler);
                this.currentSampler = sampler;
                SampleResult result = sampler.sample(null);
                this.currentSampler = null;
                if (result != null) {
                    result.setGroupThreads(this.threadGroup.getNumberOfThreads());
                    result.setAllThreads(JMeterContextService.getNumberOfThreads());
                    result.setThreadName(this.threadName);
                    threadContext.setPreviousResult(result);
                    this.runPostProcessors(pack.getPostProcessors());
                    this.checkAssertions(pack.getAssertions(), result, threadContext);
                    List<SampleListener> sampleListeners = this.getSampleListeners(pack, transactionPack, transactionSampler);
                    this.notifyListeners(sampleListeners, result);
                    this.compiler.done(pack);
                    if (transactionSampler != null) {
                        transactionSampler.addSubSamplerResult(result);
                    }
                    if (result.isStopThread() || !result.isSuccessful() && this.onErrorStopThread) {
                        this.stopThread();
                    }
                    if (result.isStopTest() || !result.isSuccessful() && this.onErrorStopTest) {
                        this.stopTest();
                    }
                    if (result.isStopTestNow() || !result.isSuccessful() && this.onErrorStopTestNow) {
                        this.stopTestNow();
                    }
                    if (result.isStartNextThreadLoop()) {
                        threadContext.setRestartNextLoop(true);
                    }
                } else {
                    this.compiler.done(pack);
                }
            }
            if (this.scheduler) {
                this.stopScheduler();
            }
        }
        catch (JMeterStopTestException e) {
            log.info("Stopping Test: " + e.toString());
            this.stopTest();
        }
        catch (JMeterStopThreadException e) {
            log.info("Stopping Thread: " + e.toString());
            this.stopThread();
        }
        catch (Exception e) {
            if (current != null) {
                log.error("Error while processing sampler '" + current.getName() + "' :", (Throwable)e);
            }
            log.error("", (Throwable)e);
        }
        return transactionResult;
    }

    private List<SampleListener> getSampleListeners(SamplePackage samplePack, SamplePackage transactionPack, TransactionSampler transactionSampler) {
        List<SampleListener> sampleListeners = samplePack.getSampleListeners();
        if (transactionSampler != null) {
            ArrayList<SampleListener> onlySubSamplerListeners = new ArrayList<SampleListener>();
            List<SampleListener> transListeners = transactionPack.getSampleListeners();
            for (SampleListener listener : sampleListeners) {
                boolean found = false;
                for (SampleListener trans : transListeners) {
                    if (trans != listener) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                onlySubSamplerListeners.add(listener);
            }
            sampleListeners = onlySubSamplerListeners;
        }
        return sampleListeners;
    }

    private IterationListener initRun(JMeterContext threadContext) {
        threadContext.setVariables(this.threadVars);
        threadContext.setThreadNum(this.getThreadNum());
        threadContext.getVariables().put(LAST_SAMPLE_OK, TRUE);
        threadContext.setThread(this);
        threadContext.setThreadGroup(this.threadGroup);
        threadContext.setEngine(this.engine);
        this.testTree.traverse((HashTreeTraverser)this.compiler);
        if (this.scheduler) {
            this.startScheduler();
        }
        this.rampUpDelay();
        log.info("Thread started: " + Thread.currentThread().getName());
        if (startEarlier) {
            threadContext.setSamplingStarted(true);
        }
        this.controller.initialize();
        IterationListener iterationListener = new IterationListener();
        this.controller.addIterationListener(iterationListener);
        if (!startEarlier) {
            threadContext.setSamplingStarted(true);
        }
        this.threadStarted();
        return iterationListener;
    }

    private void threadStarted() {
        JMeterContextService.incrNumberOfThreads();
        this.threadGroup.incrNumberOfThreads();
        GuiPackage gp = GuiPackage.getInstance();
        if (gp != null) {
            gp.getMainFrame().updateCounts();
        }
        ThreadListenerTraverser startup = new ThreadListenerTraverser(true);
        this.testTree.traverse((HashTreeTraverser)startup);
    }

    private void threadFinished(LoopIterationListener iterationListener) {
        ThreadListenerTraverser shut = new ThreadListenerTraverser(false);
        this.testTree.traverse((HashTreeTraverser)shut);
        JMeterContextService.decrNumberOfThreads();
        this.threadGroup.decrNumberOfThreads();
        GuiPackage gp = GuiPackage.getInstance();
        if (gp != null) {
            gp.getMainFrame().updateCounts();
        }
        if (iterationListener != null) {
            this.controller.removeIterationListener(iterationListener);
        }
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void stop() {
        this.running = false;
        log.info("Stopping: " + this.threadName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean interrupt() {
        this.interruptLock.lock();
        Sampler samp = this.currentSampler;
        if (samp instanceof Interruptible) {
            log.warn("Interrupting: " + this.threadName + " sampler: " + samp.getName());
            try {
                boolean found = ((Interruptible)((Object)samp)).interrupt();
                if (!found) {
                    log.warn("No operation pending");
                }
                boolean bl = found;
                return bl;
            }
            catch (Exception e) {
                log.warn("Caught Exception interrupting sampler: " + e.toString());
                return false;
            }
        }
        if (samp == null) return false;
        log.warn("Sampler is not Interruptible: " + samp.getName());
        return false;
        finally {
            this.interruptLock.unlock();
        }
    }

    private void stopTest() {
        this.running = false;
        log.info("Stop Test detected by thread: " + this.threadName);
        if (this.engine != null) {
            this.engine.askThreadsToStop();
        }
    }

    private void stopTestNow() {
        this.running = false;
        log.info("Stop Test Now detected by thread: " + this.threadName);
        if (this.engine != null) {
            this.engine.stopTest();
        }
    }

    private void stopThread() {
        this.running = false;
        log.info("Stop Thread detected by thread: " + this.threadName);
    }

    private void checkAssertions(List<Assertion> assertions, SampleResult parent, JMeterContext threadContext) {
        for (Assertion assertion : assertions) {
            TestBeanHelper.prepare((TestElement)((Object)assertion));
            if (assertion instanceof AbstractScopedAssertion) {
                AbstractScopedAssertion scopedAssertion = (AbstractScopedAssertion)((Object)assertion);
                String scope = scopedAssertion.fetchScope();
                if (scopedAssertion.isScopeParent(scope) || scopedAssertion.isScopeAll(scope) || scopedAssertion.isScopeVariable(scope)) {
                    this.processAssertion(parent, assertion);
                }
                if (!scopedAssertion.isScopeChildren(scope) && !scopedAssertion.isScopeAll(scope)) continue;
                SampleResult[] children = parent.getSubResults();
                boolean childError = false;
                for (int i = 0; i < children.length; ++i) {
                    this.processAssertion(children[i], assertion);
                    if (children[i].isSuccessful()) continue;
                    childError = true;
                }
                if (!childError || !parent.isSuccessful()) continue;
                AssertionResult assertionResult = new AssertionResult(((AbstractTestElement)((Object)assertion)).getName());
                assertionResult.setResultForFailure("One or more sub-samples failed");
                parent.addAssertionResult(assertionResult);
                parent.setSuccessful(false);
                continue;
            }
            this.processAssertion(parent, assertion);
        }
        threadContext.getVariables().put(LAST_SAMPLE_OK, Boolean.toString(parent.isSuccessful()));
    }

    private void processAssertion(SampleResult result, Assertion assertion) {
        AssertionResult assertionResult;
        try {
            assertionResult = assertion.getResult(result);
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Error e) {
            log.error("Error processing Assertion ", (Throwable)e);
            assertionResult = new AssertionResult("Assertion failed! See log file.");
            assertionResult.setError(true);
            assertionResult.setFailureMessage(e.toString());
        }
        catch (Exception e) {
            log.error("Exception processing Assertion ", (Throwable)e);
            assertionResult = new AssertionResult("Assertion failed! See log file.");
            assertionResult.setError(true);
            assertionResult.setFailureMessage(e.toString());
        }
        result.setSuccessful(result.isSuccessful() && !assertionResult.isError() && !assertionResult.isFailure());
        result.addAssertionResult(assertionResult);
    }

    private void runPostProcessors(List<PostProcessor> extractors) {
        if (reversePostProcessors) {
            ListIterator<PostProcessor> iter = extractors.listIterator(extractors.size());
            while (iter.hasPrevious()) {
                PostProcessor ex = iter.previous();
                TestBeanHelper.prepare((TestElement)((Object)ex));
                ex.process();
            }
        } else {
            for (PostProcessor ex : extractors) {
                TestBeanHelper.prepare((TestElement)((Object)ex));
                ex.process();
            }
        }
    }

    private void runPreProcessors(List<PreProcessor> preProcessors) {
        for (PreProcessor ex : preProcessors) {
            if (log.isDebugEnabled()) {
                log.debug("Running preprocessor: " + ((AbstractTestElement)((Object)ex)).getName());
            }
            TestBeanHelper.prepare((TestElement)((Object)ex));
            ex.process();
        }
    }

    private void delay(List<Timer> timers) {
        long sum = 0L;
        for (Timer timer : timers) {
            TestBeanHelper.prepare((TestElement)((Object)timer));
            sum += timer.delay();
        }
        if (sum > 0L) {
            try {
                TimeUnit.MILLISECONDS.sleep(sum);
            }
            catch (InterruptedException e) {
                log.warn("The delay timer was interrupted - probably did not wait as long as intended.");
            }
        }
    }

    void notifyTestListeners() {
        this.threadVars.incIteration();
        for (TestIterationListener listener : this.testIterationStartListeners) {
            if (listener instanceof TestElement) {
                listener.testIterationStart(new LoopIterationEvent(this.controller, this.threadVars.getIteration()));
                ((TestElement)((Object)listener)).recoverRunningVersion();
                continue;
            }
            listener.testIterationStart(new LoopIterationEvent(this.controller, this.threadVars.getIteration()));
        }
    }

    private void notifyListeners(List<SampleListener> listeners, SampleResult result) {
        SampleEvent event = new SampleEvent(result, this.threadGroup.getName(), this.threadVars);
        this.notifier.notifyListeners(event, listeners);
    }

    public void setInitialDelay(int delay) {
        this.initialDelay = delay;
    }

    private void rampUpDelay() {
        this.delayBy(this.initialDelay, "RampUp");
    }

    protected final void delayBy(long delay, String type) {
        if (delay > 0L) {
            long start = System.currentTimeMillis();
            long end = start + delay;
            long now = 0L;
            long pause = RAMPUP_GRANULARITY;
            while (this.running && (now = System.currentTimeMillis()) < end) {
                long togo = end - now;
                if (togo < pause) {
                    pause = togo;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(pause);
                }
                catch (InterruptedException e) {
                    if (!this.running) break;
                    log.warn(type + " delay for " + this.threadName + " was interrupted. Waited " + (now - start) + " milli-seconds out of " + delay);
                    break;
                }
            }
        }
    }

    public int getThreadNum() {
        return this.threadNum;
    }

    public void setThreadNum(int threadNum) {
        this.threadNum = threadNum;
    }

    public void setEngine(StandardJMeterEngine engine) {
        this.engine = engine;
    }

    public void setOnErrorStopTest(boolean b) {
        this.onErrorStopTest = b;
    }

    public void setOnErrorStopTestNow(boolean b) {
        this.onErrorStopTestNow = b;
    }

    public void setOnErrorStopThread(boolean b) {
        this.onErrorStopThread = b;
    }

    public void setOnErrorStartNextLoop(boolean b) {
        this.onErrorStartNextLoop = b;
    }

    public void setThreadGroup(AbstractThreadGroup group) {
        this.threadGroup = group;
    }

    static {
        if (startEarlier) {
            log.info("jmeterthread.startearlier=true (see jmeter.properties)");
        } else {
            log.info("jmeterthread.startearlier=false (see jmeter.properties)");
        }
        if (reversePostProcessors) {
            log.info("Running PostProcessors in reverse order");
        } else {
            log.info("Running PostProcessors in forward order");
        }
    }

    private class IterationListener
    implements LoopIterationListener {
        private IterationListener() {
        }

        @Override
        public void iterationStart(LoopIterationEvent iterEvent) {
            JMeterThread.this.notifyTestListeners();
        }
    }

    private static class ThreadListenerTraverser
    implements HashTreeTraverser {
        private final boolean isStart;

        private ThreadListenerTraverser(boolean start) {
            this.isStart = start;
        }

        public void addNode(Object node, HashTree subTree) {
            if (node instanceof ThreadListener) {
                ThreadListener tl = (ThreadListener)node;
                if (this.isStart) {
                    tl.threadStarted();
                } else {
                    tl.threadFinished();
                }
            }
        }

        public void subtractNode() {
        }

        public void processPath() {
        }
    }
}

