/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.exec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.jorphan.exec.SystemCommand;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class KeyToolUtils {
    private static final Logger log;
    private static final String DEFAULT_DNAME = "cn=JMeter Proxy (DO NOT TRUST)";
    private static final String DNAME_ROOT_CA_KEY;
    private static final String KEYTOOL = "keytool";
    private static final String KEYTOOL_DIRECTORY = "keytool.directory";
    private static final String KEYTOOL_PATH;
    private static final String DNAME_INTERMEDIATE_CA_KEY = "cn=DO NOT INSTALL THIS CERTIFICATE (JMeter Intermediate CA)";
    public static final String ROOT_CACERT_CRT_PFX = "ApacheJMeterTemporaryRootCA";
    private static final String ROOT_CACERT_CRT = "ApacheJMeterTemporaryRootCA.crt";
    private static final String ROOT_CACERT_USR = "ApacheJMeterTemporaryRootCA.usr";
    private static final String ROOTCA_ALIAS = ":root_ca:";
    private static final String INTERMEDIATE_CA_ALIAS = ":intermediate_ca:";
    public static final boolean SUPPORTS_HOST_CERT;

    private static void addElement(StringBuilder sb, String prefix, String value) {
        if (value != null) {
            sb.append(", ");
            sb.append(prefix);
            sb.append(value);
        }
    }

    private KeyToolUtils() {
    }

    public static void genkeypair(File keystore, String alias, String password, int validity, String dname, String ext) throws IOException {
        File workingDir = keystore.getParentFile();
        SystemCommand nativeCommand = new SystemCommand(workingDir, null);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(KeyToolUtils.getKeyToolPath());
        arguments.add("-genkeypair");
        arguments.add("-alias");
        arguments.add(alias);
        arguments.add("-dname");
        arguments.add(dname == null ? DEFAULT_DNAME : dname);
        arguments.add("-keyalg");
        arguments.add("RSA");
        arguments.add("-keystore");
        arguments.add(keystore.getName());
        arguments.add("-storepass");
        arguments.add(password);
        arguments.add("-keypass");
        arguments.add(password);
        arguments.add("-validity");
        arguments.add(Integer.toString(validity));
        if (ext != null) {
            arguments.add("-ext");
            arguments.add(ext);
        }
        try {
            int exitVal = nativeCommand.run(arguments);
            if (exitVal != 0) {
                throw new IOException("Command :'" + KeyToolUtils.formatCommand(arguments) + "' failed, code: " + exitVal + "\n" + nativeCommand.getOutResult());
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Command was interrupted\n" + nativeCommand.getOutResult(), e);
        }
    }

    private static String formatCommand(List<String> arguments) {
        StringBuilder builder = new StringBuilder();
        boolean redact = false;
        for (String string : arguments) {
            boolean quote = string.contains(" ");
            if (quote) {
                builder.append("\"");
            }
            builder.append(redact ? "{redacted)" : string);
            if (quote) {
                builder.append("\"");
            }
            builder.append(" ");
            redact = string.equals("-storepass") || string.equals("-keypass");
        }
        if (arguments.size() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    public static void generateProxyCA(File keystore, String password, int validity) throws IOException {
        File caCert_crt = new File(ROOT_CACERT_CRT);
        File caCert_usr = new File(ROOT_CACERT_USR);
        boolean fileExists = false;
        if (!keystore.delete() && keystore.exists()) {
            log.warn("Problem deleting the keystore '" + keystore + "'");
            fileExists = true;
        }
        if (!caCert_crt.delete() && caCert_crt.exists()) {
            log.warn("Problem deleting the certificate file '" + caCert_crt + "'");
            fileExists = true;
        }
        if (!caCert_usr.delete() && caCert_usr.exists()) {
            log.warn("Problem deleting the certificate file '" + caCert_usr + "'");
            fileExists = true;
        }
        if (fileExists) {
            log.warn("If problems occur when recording SSL, delete the files manually and retry.");
        }
        KeyToolUtils.genkeypair(keystore, ROOTCA_ALIAS, password, validity, DNAME_ROOT_CA_KEY, "bc:c");
        KeyToolUtils.genkeypair(keystore, INTERMEDIATE_CA_ALIAS, password, validity, DNAME_INTERMEDIATE_CA_KEY, "bc:c");
        ByteArrayOutputStream certReqOut = new ByteArrayOutputStream();
        KeyToolUtils.keytool("-certreq", keystore, password, INTERMEDIATE_CA_ALIAS, null, certReqOut, new String[0]);
        ByteArrayInputStream certReqIn = new ByteArrayInputStream(certReqOut.toByteArray());
        ByteArrayOutputStream genCertOut = new ByteArrayOutputStream();
        KeyToolUtils.keytool("-gencert", keystore, password, ROOTCA_ALIAS, certReqIn, genCertOut, "-ext", "BC:0");
        ByteArrayInputStream genCertIn = new ByteArrayInputStream(genCertOut.toByteArray());
        KeyToolUtils.keytool("-importcert", keystore, password, INTERMEDIATE_CA_ALIAS, genCertIn, null, new String[0]);
        KeyToolUtils.keytool("-exportcert", keystore, password, ROOTCA_ALIAS, null, null, "-rfc", "-file", ROOT_CACERT_CRT);
        FileUtils.copyFile((File)caCert_crt, (File)caCert_usr);
    }

    public static void generateHostCert(File keystore, String password, String host, int validity) throws IOException {
        KeyToolUtils.generateSignedCert(keystore, password, validity, host, host);
    }

    private static void generateSignedCert(File keystore, String password, int validity, String alias, String subject) throws IOException {
        String dname = "cn=" + subject + ", o=JMeter Proxy (TEMPORARY TRUST ONLY)";
        KeyToolUtils.genkeypair(keystore, alias, password, validity, dname, null);
        ByteArrayOutputStream certReqOut = new ByteArrayOutputStream();
        KeyToolUtils.keytool("-certreq", keystore, password, alias, null, certReqOut, new String[0]);
        ByteArrayInputStream certReqIn = new ByteArrayInputStream(certReqOut.toByteArray());
        ByteArrayOutputStream certOut = new ByteArrayOutputStream();
        KeyToolUtils.keytool("-gencert", keystore, password, INTERMEDIATE_CA_ALIAS, certReqIn, certOut, "-ext", "ku:c=dig,keyE");
        ByteArrayInputStream certIn = new ByteArrayInputStream(certOut.toByteArray());
        KeyToolUtils.keytool("-importcert", keystore, password, alias, certIn, null, "-noprompt");
    }

    public static String list(File keystore, String storePass) throws IOException {
        File workingDir = keystore.getParentFile();
        SystemCommand nativeCommand = new SystemCommand(workingDir, null);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(KeyToolUtils.getKeyToolPath());
        arguments.add("-list");
        arguments.add("-v");
        arguments.add("-keystore");
        arguments.add(keystore.getName());
        arguments.add("-storepass");
        arguments.add(storePass);
        try {
            int exitVal = nativeCommand.run(arguments);
            if (exitVal != 0) {
                throw new IOException("Command failed, code: " + exitVal + "\n" + nativeCommand.getOutResult());
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Command was interrupted\n" + nativeCommand.getOutResult(), e);
        }
        return nativeCommand.getOutResult();
    }

    public static String[] getCAaliases() {
        return new String[]{ROOTCA_ALIAS, INTERMEDIATE_CA_ALIAS};
    }

    public static String getRootCAalias() {
        return ROOTCA_ALIAS;
    }

    private static void keytool(String command, File keystore, String password, String alias, InputStream input, OutputStream output, String ... parameters) throws IOException {
        File workingDir = keystore.getParentFile();
        SystemCommand nativeCommand = new SystemCommand(workingDir, 0L, 0, null, input, output, null);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(KeyToolUtils.getKeyToolPath());
        arguments.add(command);
        arguments.add("-keystore");
        arguments.add(keystore.getName());
        arguments.add("-storepass");
        arguments.add(password);
        arguments.add("-keypass");
        arguments.add(password);
        arguments.add("-alias");
        arguments.add(alias);
        for (String parameter : parameters) {
            arguments.add(parameter);
        }
        try {
            int exitVal = nativeCommand.run(arguments);
            if (exitVal != 0) {
                throw new IOException("Command failed, code: " + exitVal + "\n" + nativeCommand.getOutResult());
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Command was interrupted\n" + nativeCommand.getOutResult(), e);
        }
    }

    public static boolean haveKeytool() {
        return KEYTOOL_PATH != null;
    }

    private static String getKeyToolPath() throws IOException {
        if (KEYTOOL_PATH == null) {
            throw new IOException("keytool application cannot be found");
        }
        return KEYTOOL_PATH;
    }

    private static boolean checkKeytool(String keytoolPath) {
        SystemCommand nativeCommand = new SystemCommand(null, null);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(keytoolPath);
        arguments.add("-help");
        try {
            int status = nativeCommand.run(arguments);
            if (log.isDebugEnabled()) {
                log.debug("checkKeyTool:status=" + status);
                log.debug(nativeCommand.getOutResult());
            }
            return status == 0 || status == 1;
        }
        catch (IOException ioe) {
            return false;
        }
        catch (InterruptedException e) {
            log.error("Command was interrupted\n" + nativeCommand.getOutResult(), (Throwable)e);
            return false;
        }
    }

    static {
        String keytoolPath;
        log = LoggingManager.getLoggerForClass();
        StringBuilder sb = new StringBuilder();
        sb.append("CN=_ DO NOT INSTALL unless this is your certificate (JMeter root CA)");
        KeyToolUtils.addElement(sb, "OU=Username: ", System.getProperty("user.name"));
        KeyToolUtils.addElement(sb, "C=", System.getProperty("user.country"));
        DNAME_ROOT_CA_KEY = sb.toString();
        String keytoolDir = System.getProperty(KEYTOOL_DIRECTORY);
        if (keytoolDir != null) {
            keytoolPath = new File(new File(keytoolDir), KEYTOOL).getPath();
            if (!KeyToolUtils.checkKeytool(keytoolPath)) {
                log.error("Cannot find keytool using property keytool.directory=" + keytoolDir);
                keytoolPath = null;
            }
        } else {
            keytoolPath = KEYTOOL;
            if (!KeyToolUtils.checkKeytool(keytoolPath)) {
                File javaHome = SystemUtils.getJavaHome();
                if (javaHome != null) {
                    keytoolPath = new File(new File(javaHome, "bin"), KEYTOOL).getPath();
                    if (!KeyToolUtils.checkKeytool(keytoolPath)) {
                        keytoolPath = null;
                    }
                } else {
                    keytoolPath = null;
                }
            }
        }
        if (keytoolPath == null) {
            log.error("Unable to find keytool application. Check PATH or define system property keytool.directory");
        } else {
            log.info("keytool found at '" + keytoolPath + "'");
        }
        KEYTOOL_PATH = keytoolPath;
        SUPPORTS_HOST_CERT = SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7);
    }
}

