/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto;

import java.io.IOException;
import jodd.lagarto.LagartoException;
import jodd.lagarto.LagartoLexer;
import jodd.lagarto.LagartoParserContext;
import jodd.lagarto.LagartoParserUtil;
import jodd.lagarto.ParsedTag;
import jodd.lagarto.TagType;
import jodd.lagarto.TagVisitor;
import jodd.lagarto.Token;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LagartoParserEngine {
    private static final Logger log = LoggerFactory.getLogger(LagartoParserEngine.class);
    private static final char[] COMMENT_IF = "[if".toCharArray();
    private static final char[] COMMENT_ENDIF = "<![endif]".toCharArray();
    private char[] input;
    private LagartoLexer lexer;
    private ParsedTag tag;
    private LagartoParserContext ctx;
    private TagVisitor visitor;
    private Token lastToken = Token.UNKNOWN;
    private CharSequence lastText;
    private boolean buffering;
    private int buffTextStart;
    private int buffTextEnd;
    protected boolean enableConditionalComments = true;
    protected boolean calculatePosition;
    protected boolean parseSpecialTagsAsCdata = true;

    protected void initialize(char[] input) {
        this.input = input;
        this.lexer = new LagartoLexer(input);
        this.tag = new ParsedTag(this.lexer);
        this.ctx = new LagartoParserContext();
        this.buffering = false;
        this.buffTextStart = 0;
        this.buffTextEnd = 0;
        this.lastText = null;
        this.lastToken = Token.UNKNOWN;
    }

    public boolean isEnableConditionalComments() {
        return this.enableConditionalComments;
    }

    public void setEnableConditionalComments(boolean enableConditionalComments) {
        this.enableConditionalComments = enableConditionalComments;
    }

    public void setCalculatePosition(boolean calculatePosition) {
        this.calculatePosition = calculatePosition;
    }

    public boolean isCalculatePosition() {
        return this.calculatePosition;
    }

    public void setParseSpecialTagsAsCdata(boolean parseSpecialTagsAsCdata) {
        this.parseSpecialTagsAsCdata = parseSpecialTagsAsCdata;
    }

    public boolean isParseSpecialTagsAsCdata() {
        return this.parseSpecialTagsAsCdata;
    }

    protected void parse(TagVisitor visitor) {
        this.visitor = visitor;
        this.ctx.startTime = System.currentTimeMillis();
        log.debug("parsing started");
        try {
            this.parse();
        }
        catch (IOException ioex) {
            throw new LagartoException(ioex);
        }
        finally {
            this.ctx.endTime = System.currentTimeMillis();
            this.ctx.elapsedTime = this.ctx.endTime - this.ctx.startTime;
            if (log.isDebugEnabled()) {
                log.debug("parsing done in " + this.ctx.elapsedTime + "ms.");
            }
        }
    }

    protected void parse() throws IOException {
        this.lexer.setParseSpecialTagsAsCdata(this.parseSpecialTagsAsCdata);
        this.visitor.start(this.ctx);
        block11: while (true) {
            Token token = this.nextToken();
            switch (token) {
                case EOF: {
                    this.flushText();
                    this.visitor.end();
                    return;
                }
                case COMMENT: {
                    this.parseCommentOrConditionalComment();
                    continue block11;
                }
                case CDATA: {
                    this.parseCDATA();
                    continue block11;
                }
                case DOCTYPE: {
                    this.parseDoctype();
                    continue block11;
                }
                case TEXT: {
                    int start = this.lexer.position();
                    this.parseText(start, start + this.lexer.length());
                    continue block11;
                }
                case LT: {
                    this.parseTag(token, TagType.START);
                    continue block11;
                }
                case XML_LT: {
                    this.parseTag(token, TagType.START);
                    continue block11;
                }
                case CONDITIONAL_COMMENT_START: {
                    this.parseRevealedCCStart();
                    continue block11;
                }
                case CONDITIONAL_COMMENT_END: {
                    this.parseCCEnd();
                    continue block11;
                }
            }
            this.error(new StringBuilder("Unexpected root token: ").append((Object)token));
        }
    }

    protected void flushText() {
        if (this.buffering) {
            this.ctx.offset = this.buffTextStart;
            this.visitor.text(LagartoParserUtil.subSequence(this.input, this.buffTextStart, this.buffTextEnd));
            this.buffering = false;
        }
    }

    protected void parseText(int start, int end) {
        if (!this.buffering) {
            this.buffering = true;
            this.buffTextStart = start;
            this.buffTextEnd = end;
        } else {
            if (this.buffTextEnd != start) {
                throw new LagartoException();
            }
            this.buffTextEnd = end;
        }
    }

    protected void parseCommentOrConditionalComment() throws IOException {
        this.flushText();
        int lexerPosition = this.lexer.position();
        int start = lexerPosition + 4;
        int end = start + this.lexer.length() - 7;
        if (this.enableConditionalComments && LagartoParserUtil.regionStartWith(this.input, start, end, COMMENT_IF)) {
            int expressionEnd = LagartoParserUtil.regionIndexOf(this.input, start + 3, end, ']');
            int ccend = expressionEnd + 2;
            CharSequence additionalComment = null;
            int commentEnd = LagartoParserUtil.regionIndexOf(this.input, ccend, end, COMMENT_ENDIF);
            if (commentEnd == -1) {
                additionalComment = LagartoParserUtil.subSequence(this.input, ccend, end + 3);
            }
            this.ctx.offset = lexerPosition;
            this.visitor.condComment(LagartoParserUtil.subSequence(this.input, start + 1, expressionEnd), true, true, additionalComment);
            if (additionalComment == null) {
                int pushBack = this.lexer.position() + this.lexer.length();
                this.lexer.yypushback(pushBack -= ccend);
            }
            return;
        }
        this.ctx.offset = lexerPosition;
        this.visitor.comment(LagartoParserUtil.subSequence(this.input, start, end));
    }

    protected void parseCDATA() throws IOException {
        this.flushText();
        int position = this.lexer.position();
        int start = position + 9;
        int end = start + this.lexer.length() - 12;
        this.ctx.offset = position;
        this.visitor.cdata(LagartoParserUtil.subSequence(this.input, start, end));
    }

    protected void parseDoctype() throws IOException {
        int start = this.lexer.position();
        this.flushText();
        this.skipWhiteSpace();
        String name = null;
        boolean isPublic = false;
        String publicId = null;
        String uri = null;
        int i = 0;
        while (true) {
            this.skipWhiteSpace();
            Token token = this.nextToken();
            if (token == Token.GT) break;
            switch (i) {
                case 0: {
                    name = this.textString();
                    break;
                }
                case 1: {
                    if (!this.textString().equals("PUBLIC")) break;
                    isPublic = true;
                    break;
                }
                case 2: {
                    if (isPublic) {
                        publicId = this.lexer.yytext(1, 1);
                        break;
                    }
                    uri = this.lexer.yytext(1, 1);
                    break;
                }
                case 3: {
                    uri = this.lexer.yytext(1, 1);
                }
            }
            ++i;
        }
        this.ctx.offset = start;
        this.visitor.doctype(name, publicId, uri);
    }

    protected void parseRevealedCCStart() throws IOException {
        this.flushText();
        if (!this.enableConditionalComments) {
            this.error(new StringBuilder("Conditional comments disabled"));
            return;
        }
        int start = this.lexer.position();
        int end = start + this.lexer.length();
        int textStart = start;
        int textEnd = end;
        int i = start + 2;
        while (i < end) {
            if (this.input[i] == '[') {
                textStart = ++i;
                continue;
            }
            if (this.input[i] == ']') {
                textEnd = i;
                break;
            }
            ++i;
        }
        this.ctx.offset = start;
        this.visitor.condComment(LagartoParserUtil.subSequence(this.input, textStart, textEnd), true, false, null);
    }

    protected void parseCCEnd() throws IOException {
        boolean hasExtra;
        this.flushText();
        int start = this.lexer.position();
        int end = start + this.lexer.length();
        int textStart = start;
        int textEnd = end;
        int i = start + 2;
        while (i < end) {
            if (this.input[i] == '[') {
                textStart = ++i;
                continue;
            }
            if (this.input[i] == ']') {
                textEnd = i;
                break;
            }
            ++i;
        }
        boolean isDownlevelHidden = end - textEnd == 4;
        boolean bl = hasExtra = textStart - start > 3;
        if (!this.enableConditionalComments) {
            if (isDownlevelHidden) {
                this.ctx.offset = start;
                this.visitor.comment(LagartoParserUtil.subSequence(this.input, start + 4, end - 3));
            } else {
                this.error(new StringBuilder("Conditional comments disabled"));
            }
            return;
        }
        CharSequence additionalComment = null;
        if (hasExtra) {
            additionalComment = LagartoParserUtil.subSequence(this.input, start, textStart - 3);
        }
        this.ctx.offset = start;
        this.visitor.condComment(LagartoParserUtil.subSequence(this.input, textStart, textEnd), false, isDownlevelHidden, additionalComment);
    }

    protected void parseTag(Token tagToken, TagType type) throws IOException {
        int start = this.lexer.position();
        try {
            this.skipWhiteSpace();
            Token token = this.nextToken();
            if (this.lexer.nextTagState == -1) {
                this.lexer.nextTagState = -2;
            }
            if (token == Token.SLASH) {
                type = TagType.END;
                token = this.nextToken();
            }
            switch (token) {
                case WORD: {
                    String tagName = this.textString();
                    if (this.acceptTag(tagName)) {
                        this.parseTagAndAttributes(tagToken, tagName, type, start);
                        break;
                    }
                    this.parseAsText(start);
                    break;
                }
                case GT: {
                    this.parseText(start, this.lexer.position() + 1);
                    break;
                }
                case EOF: {
                    this.parseText(start, this.lexer.position());
                    break;
                }
                default: {
                    this.error(new StringBuilder("Invalid token in tag <").append(this.text()).append('>'));
                    this.parseAsText(start);
                    break;
                }
            }
        }
        catch (LagartoException lex) {
            this.error(new StringBuilder(lex.getMessage()));
            this.parseAsText(start);
        }
    }

    protected void parseAsText(int start) throws IOException {
        this.lexer.stateReset();
        this.stepBack(this.lexer.nextToken());
        this.parseText(start, this.lexer.position());
    }

    protected boolean acceptTag(String tagName) {
        return true;
    }

    protected void parseTagAndAttributes(Token tagToken, String tagName, TagType type, int start) throws IOException {
        Token token;
        this.tag.startTag(tagName);
        block12: while (true) {
            this.skipWhiteSpace();
            token = this.nextToken();
            this.stepBack(token);
            switch (token) {
                case GT: {
                    break block12;
                }
                case XML_GT: {
                    break block12;
                }
                case WORD: {
                    this.parseAttribute();
                    continue block12;
                }
                case EOF: {
                    this.parseText(start, this.lexer.position());
                    return;
                }
                case SLASH: {
                    this.nextToken();
                    Token nextToken = this.nextToken();
                    this.stepBack(nextToken);
                    if (nextToken != Token.GT) continue block12;
                    type = TagType.SELF_CLOSING;
                    break block12;
                }
                default: {
                    CharSequence charSequence = this.text();
                    String tokenText = charSequence != null ? charSequence.toString() : this.lexer.yytext();
                    this.error(new StringBuilder("Tag <").append(tagName).append("> invalid token: ").append(tokenText));
                    this.nextToken();
                    if (tokenText.length() <= 1) continue block12;
                    this.lexer.yypushback(tokenText.length() - 1);
                    continue block12;
                }
            }
            break;
        }
        token = this.nextToken();
        if (tagToken == Token.LT && token == Token.XML_GT) {
            token = Token.GT;
            this.error(new StringBuilder("Unmatched tag <").append(tagName).append("?>"));
        } else if (tagToken == Token.XML_LT && token == Token.GT) {
            token = Token.XML_GT;
            this.error(new StringBuilder("Unmatched tag <?").append(tagName).append('>'));
        }
        switch (token) {
            default: {
                this.error(new StringBuilder("Expected end of tag for <").append(tagName).append('>'));
            }
            case GT: {
                int nextTagState;
                this.flushText();
                int len = this.lexer.position() - start + 1;
                if (type.isStartingTag() && (nextTagState = this.lexer.getNextTagState()) > 0) {
                    this.tag.defineTag(type, start, len);
                    this.tag.increaseDeepLevel();
                    this.parseSpecialTag(nextTagState);
                    this.tag.decreaseDeepLevel();
                    break;
                }
                this.tag.defineTag(type, start, len);
                if (type.isStartingTag()) {
                    this.tag.increaseDeepLevel();
                }
                this.ctx.offset = start;
                this.visitor.tag(this.tag);
                if (!type.isEndingTag()) break;
                this.tag.decreaseDeepLevel();
                break;
            }
            case XML_GT: {
                this.flushText();
                int len2 = this.lexer.position() - start + 2;
                this.tag.defineTag(type, start, len2);
                this.tag.setTagMarks("<?", "?>");
                this.tag.increaseDeepLevel();
                this.ctx.offset = start;
                this.visitor.xml(this.tag);
                this.tag.decreaseDeepLevel();
                break;
            }
            case EOF: {
                this.parseText(start, this.lexer.position());
            }
        }
    }

    protected void parseAttribute() throws IOException {
        this.nextToken();
        String attributeName = this.textString();
        this.skipWhiteSpace();
        Token token = this.nextToken();
        if (token == Token.EQUALS) {
            this.skipWhiteSpace();
            token = this.nextToken();
            if (token == Token.QUOTE) {
                CharSequence charSequence = this.text();
                char quote = charSequence.charAt(0);
                charSequence = charSequence.subSequence(1, charSequence.length() - 1);
                String attributeValue = charSequence.toString();
                if (quote == '\'') {
                    attributeValue = StringUtil.replace((String)attributeValue, (String)"\"", (String)"&quot;");
                }
                this.tag.addAttribute(attributeName, attributeValue);
            } else if (token == Token.WORD || token == Token.SLASH) {
                Token next;
                String attributeValue = this.textString();
                while ((next = this.nextToken()) != Token.WHITESPACE && next != Token.GT) {
                    attributeValue = attributeValue + this.text();
                }
                this.stepBack(next);
                this.tag.addAttribute(attributeName, attributeValue);
            } else if (token == Token.GT) {
                this.stepBack(token);
            } else if (token != Token.EOF) {
                this.error(new StringBuilder("Invalid attribute: ").append(attributeName));
            }
        } else if (token == Token.SLASH || token == Token.GT || token == Token.WORD) {
            this.tag.addAttribute(attributeName, null);
            this.stepBack(token);
        } else if (token == Token.QUOTE) {
            this.error(new StringBuilder("Orphan attribute: ").append(this.text()));
            this.tag.addAttribute(attributeName, null);
        } else if (token != Token.EOF) {
            this.error(new StringBuilder("Invalid attribute: ").append(attributeName));
        }
    }

    protected void parseSpecialTag(int state) throws IOException {
        int start = this.lexer.position() + 1;
        this.nextToken();
        int end = start + this.lexer.length();
        switch (state) {
            case 6: {
                this.ctx.offset = this.tag.getTagPosition();
                this.visitor.xmp(this.tag, LagartoParserUtil.subSequence(this.input, start, end - 6));
                break;
            }
            case 8: {
                this.ctx.offset = this.tag.getTagPosition();
                this.visitor.script(this.tag, LagartoParserUtil.subSequence(this.input, start, end - 9));
                break;
            }
            case 10: {
                this.ctx.offset = this.tag.getTagPosition();
                this.visitor.style(this.tag, LagartoParserUtil.subSequence(this.input, start, end - 8));
            }
        }
    }

    private void stepBack(Token next) {
        if (this.lastToken != Token.UNKNOWN) {
            throw new LagartoException("Only one step back allowed.");
        }
        this.lastToken = next;
        this.lastText = next == Token.WORD || next == Token.QUOTE || next == Token.SLASH || next == Token.EQUALS ? this.lexer.xxtext() : null;
    }

    protected Token nextToken() throws IOException {
        Token next;
        if (this.lastToken == Token.UNKNOWN) {
            next = this.lexer.nextToken();
        } else {
            next = this.lastToken;
            this.lastToken = Token.UNKNOWN;
        }
        return next;
    }

    protected void skipWhiteSpace() throws IOException {
        Token next;
        while ((next = this.nextToken()) == Token.WHITESPACE) {
        }
        this.stepBack(next);
    }

    protected CharSequence text() {
        if (this.lastToken == Token.UNKNOWN) {
            return this.lexer.xxtext();
        }
        return this.lastText;
    }

    protected String textString() {
        if (this.lastToken == Token.UNKNOWN) {
            return this.lexer.yytext();
        }
        return this.lastText.toString();
    }

    protected void error(StringBuilder message) {
        int line = this.lexer.line();
        int column = this.lexer.column();
        if (line != -1) {
            message.append(" [").append(line).append(':').append(column).append(']');
        } else {
            int position = this.lexer.position();
            if (this.calculatePosition) {
                LagartoLexer.Position currentPosition = this.lexer.currentPosition();
                message.append(' ').append(currentPosition.toString());
            } else {
                message.append(" [@").append(position).append(']');
            }
        }
        this.visitor.error(message.toString());
    }
}

