/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import jodd.lagarto.LagartoParserContext;
import jodd.lagarto.Tag;
import jodd.lagarto.TagType;
import jodd.lagarto.TagVisitor;
import jodd.lagarto.dom.CData;
import jodd.lagarto.dom.Comment;
import jodd.lagarto.dom.Document;
import jodd.lagarto.dom.DocumentType;
import jodd.lagarto.dom.Element;
import jodd.lagarto.dom.HtmlFosterRules;
import jodd.lagarto.dom.HtmlImplicitClosingRules;
import jodd.lagarto.dom.LagartoDOMBuilder;
import jodd.lagarto.dom.Node;
import jodd.lagarto.dom.Text;
import jodd.lagarto.dom.XmlDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LagartoDOMBuilderTagVisitor
implements TagVisitor {
    private static final Logger log = LoggerFactory.getLogger(LagartoDOMBuilderTagVisitor.class);
    protected final LagartoDOMBuilder domBuilder;
    protected final HtmlImplicitClosingRules implRules = new HtmlImplicitClosingRules();
    protected Document rootNode;
    protected Node parentNode;
    protected boolean enabled;
    protected LagartoParserContext parserContext;

    public LagartoDOMBuilderTagVisitor(LagartoDOMBuilder domBuilder) {
        this.domBuilder = domBuilder;
    }

    public Document getDocument() {
        return this.rootNode;
    }

    public void start(LagartoParserContext parserContext) {
        log.debug("DomTree builder started.");
        this.parserContext = parserContext;
        if (this.rootNode == null) {
            this.rootNode = this.createDocument();
        }
        this.parentNode = this.rootNode;
        this.enabled = true;
    }

    public void end() {
        if (this.parentNode != this.rootNode) {
            Node thisNode = this.parentNode;
            while (thisNode != this.rootNode) {
                if (this.domBuilder.isImpliedEndTags() && this.implRules.implicitlyCloseTagOnEOF(thisNode.getNodeName())) {
                    thisNode = thisNode.getParentNode();
                    continue;
                }
                this.error("Unclosed tag closed: <" + thisNode.getNodeName() + "> " + thisNode.getPositionString());
                thisNode = thisNode.getParentNode();
            }
        }
        if (this.domBuilder.isIgnoreWhitespacesBetweenTags()) {
            this.removeLastChildNodeIfEmptyText(this.parentNode, true);
        }
        if (this.domBuilder.isUseFosterRules()) {
            HtmlFosterRules fosterRules = new HtmlFosterRules();
            fosterRules.fixFosterElements(this.rootNode);
        }
        this.rootNode.end();
        if (log.isDebugEnabled()) {
            log.debug("LagartoDom tree created in " + this.rootNode.getElapsedTime() + " ms.");
        }
    }

    protected Element createElementNode(Tag tag) {
        boolean isVoid = this.domBuilder.isVoidTag(tag.getName());
        boolean selfClosed = false;
        if (this.domBuilder.hasVoidTags()) {
            if (isVoid) {
                selfClosed = this.domBuilder.isSelfCloseVoidTags();
            }
        } else {
            selfClosed = this.domBuilder.isSelfCloseVoidTags();
        }
        return this.createElement(tag, isVoid, selfClosed);
    }

    public void tag(Tag tag) {
        if (!this.enabled) {
            return;
        }
        TagType tagType = tag.getType();
        switch (tagType) {
            case START: {
                if (this.domBuilder.isIgnoreWhitespacesBetweenTags()) {
                    this.removeLastChildNodeIfEmptyText(this.parentNode, false);
                }
                Element node = this.createElementNode(tag);
                if (this.domBuilder.isImpliedEndTags()) {
                    String parentNodeName;
                    while (this.implRules.implicitlyCloseParentTagOnNewTag(parentNodeName = this.parentNode.getNodeName(), node.getNodeName())) {
                        this.parentNode = this.parentNode.getParentNode();
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Implicitly closed tag <" + node.getNodeName() + "> " + this.parentNode.getPositionString());
                    }
                }
                this.parentNode.addChild((Node)node);
                if (node.isVoidElement()) break;
                this.parentNode = node;
                break;
            }
            case END: {
                String tagName;
                Node matchingParent;
                if (this.domBuilder.isIgnoreWhitespacesBetweenTags()) {
                    this.removeLastChildNodeIfEmptyText(this.parentNode, true);
                }
                if ((matchingParent = this.findMatchingParentOpenTag(tagName = tag.getName())) == this.parentNode) {
                    this.parentNode = this.parentNode.getParentNode();
                    break;
                }
                if (matchingParent == null) {
                    String positionString = "";
                    if (this.domBuilder.isCalculatePosition()) {
                        positionString = tag.calculateTagPosition().toString();
                    }
                    this.error("Orphan closed tag ignored: </" + tagName + "> " + positionString);
                    break;
                }
                if (this.domBuilder.isImpliedEndTags()) {
                    boolean fixed = false;
                    while (this.implRules.implicitlyCloseParentTagOnTagEnd(this.parentNode.getNodeName(), tagName)) {
                        this.parentNode = this.parentNode.getParentNode();
                        if (log.isDebugEnabled()) {
                            log.debug("Implicitly closed tag <" + tagName + "> " + this.parentNode.getPositionString());
                        }
                        if (this.parentNode != matchingParent) continue;
                        this.parentNode = matchingParent.parentNode;
                        fixed = true;
                        break;
                    }
                    if (fixed) break;
                }
                this.fixUnclosedTagsUpToMatchingParent(tag, matchingParent);
                break;
            }
            case SELF_CLOSING: {
                if (this.domBuilder.isIgnoreWhitespacesBetweenTags()) {
                    this.removeLastChildNodeIfEmptyText(this.parentNode, false);
                }
                Element node = this.createElementNode(tag);
                this.parentNode.addChild((Node)node);
            }
        }
    }

    protected void removeLastChildNodeIfEmptyText(Node parentNode, boolean closedTag) {
        if (parentNode == null) {
            return;
        }
        Node lastChild = parentNode.getLastChild();
        if (lastChild == null) {
            return;
        }
        if (lastChild.getNodeType() != Node.NodeType.TEXT) {
            return;
        }
        if (closedTag && parentNode.getChildNodesCount() == 1) {
            return;
        }
        Text text = (Text)lastChild;
        if (text.isBlank()) {
            lastChild.detachFromParent();
        }
    }

    protected Node findMatchingParentOpenTag(String tagName) {
        Node parent = this.parentNode;
        if (this.rootNode.isLowercase()) {
            tagName = tagName.toLowerCase();
        }
        while (parent != null) {
            String parentNodeName = parent.getNodeName();
            if (parentNodeName != null && this.rootNode.isLowercase()) {
                parentNodeName = parentNodeName.toLowerCase();
            }
            if (tagName.equals(parentNodeName)) {
                return parent;
            }
            parent = parent.getParentNode();
        }
        return null;
    }

    protected void fixUnclosedTagsUpToMatchingParent(Tag tag, Node matchingParent) {
        if (this.domBuilder.isUnclosedTagAsOrphanCheck()) {
            if (!tag.getName().equals("table")) {
                for (Node thisNode = this.parentNode; thisNode != matchingParent; thisNode = thisNode.getParentNode()) {
                    String thisNodeName = thisNode.getNodeName().toLowerCase();
                    if (!thisNodeName.equals("table") && !thisNodeName.equals("ul") && !thisNodeName.equals("ol")) continue;
                    String positionString = "";
                    if (this.domBuilder.isCalculatePosition()) {
                        positionString = tag.calculateTagPosition().toString();
                    }
                    this.error("Orphan closed tag ignored: </" + tag.getName() + "> " + positionString);
                    return;
                }
            }
        }
        while (true) {
            if (this.parentNode == matchingParent) break;
            Node parentParentNode = this.parentNode.getParentNode();
            if (this.domBuilder.isImpliedEndTags() && this.implRules.implicitlyCloseParentTagOnNewTag(parentParentNode.getNodeName(), this.parentNode.getNodeName())) {
                this.parentNode.detachFromParent();
                parentParentNode.getParentNode().addChild(this.parentNode);
            }
            this.error("Unclosed tag closed: <" + this.parentNode.getNodeName() + "> " + this.parentNode.getPositionString());
            this.parentNode = parentParentNode;
        }
        this.parentNode = this.parentNode.getParentNode();
    }

    public void xmp(Tag tag, CharSequence body) {
        if (!this.enabled) {
            return;
        }
        Element node = this.createElementNode(tag);
        this.parentNode.addChild((Node)node);
        if (body.length() != 0) {
            Text text = this.createText(body.toString());
            node.addChild((Node)text);
        }
    }

    public void style(Tag tag, CharSequence body) {
        if (!this.enabled) {
            return;
        }
        Element node = this.createElementNode(tag);
        this.parentNode.addChild((Node)node);
        if (body.length() != 0) {
            Text text = this.createText(body.toString());
            node.addChild((Node)text);
        }
    }

    public void script(Tag tag, CharSequence body) {
        if (!this.enabled) {
            return;
        }
        Element node = this.createElementNode(tag);
        this.parentNode.addChild((Node)node);
        if (body.length() != 0) {
            Text text = this.createText(body.toString());
            node.addChild((Node)text);
        }
    }

    public void comment(CharSequence comment) {
        if (!this.enabled) {
            return;
        }
        if (this.domBuilder.isIgnoreWhitespacesBetweenTags()) {
            this.removeLastChildNodeIfEmptyText(this.parentNode, false);
        }
        if (this.domBuilder.isIgnoreComments()) {
            return;
        }
        Comment node = this.createComment(comment.toString());
        this.parentNode.addChild((Node)node);
    }

    public void text(CharSequence text) {
        if (!this.enabled) {
            return;
        }
        String textValue = text.toString();
        Text node = this.createText(textValue);
        this.parentNode.addChild((Node)node);
    }

    public void cdata(CharSequence cdata) {
        if (!this.enabled) {
            return;
        }
        CData cdataNode = this.createCData(cdata.toString());
        this.parentNode.addChild((Node)cdataNode);
    }

    public void xml(Tag tag) {
        if (!this.enabled) {
            return;
        }
        XmlDeclaration xmlDeclaration = this.createXmlDeclaration(tag);
        this.parentNode.addChild((Node)xmlDeclaration);
    }

    public void doctype(String name, String publicId, String baseUri) {
        if (!this.enabled) {
            return;
        }
        DocumentType documentType = this.createDocumentType(name, publicId, baseUri);
        this.parentNode.addChild((Node)documentType);
    }

    public void condComment(CharSequence expression, boolean isStartingTag, boolean isHidden, CharSequence comment) {
        String defaultExpression = this.domBuilder.getConditionalCommentExpression();
        if (defaultExpression != null) {
            String expressionString = expression.toString().trim();
            if (!expressionString.equals(defaultExpression)) {
                this.enabled = expressionString.equals("endif");
            }
        } else {
            if (!this.enabled) {
                return;
            }
            String additionalComment = comment != null ? comment.toString() : null;
            Comment commentNode = this.createConditionalComment(expression.toString(), isStartingTag, isHidden, additionalComment);
            this.parentNode.addChild((Node)commentNode);
        }
    }

    public void error(String message) {
        this.rootNode.addError(message);
        switch (this.domBuilder.getParsingErrorLogLevel()) {
            case 5: {
                log.error(message);
                break;
            }
            case 4: {
                log.warn(message);
                break;
            }
            case 3: {
                log.info(message);
                break;
            }
            case 2: {
                log.debug(message);
                break;
            }
            case 1: {
                log.trace(message);
            }
        }
    }

    protected Document createDocument() {
        return new Document(!this.domBuilder.isCaseSensitive(), this.domBuilder.isCollectErrors(), this.domBuilder.getRenderer(), this.parserContext);
    }

    protected CData createCData(String cdata) {
        return new CData(this.rootNode, cdata);
    }

    protected Comment createComment(String comment) {
        return new Comment(this.rootNode, comment);
    }

    protected Comment createConditionalComment(String comment, boolean isStartingTag, boolean conditionalDownlevelHidden, String additionalComment) {
        return new Comment(this.rootNode, comment, isStartingTag, conditionalDownlevelHidden, additionalComment);
    }

    protected Element createElement(Tag tag, boolean voidElement, boolean selfClosed) {
        Element element = new Element(this.rootNode, tag, voidElement, selfClosed);
        if (this.domBuilder.isCalculatePosition()) {
            element.position = tag.calculateTagPosition();
        }
        return element;
    }

    protected Element createElement(String name) {
        return new Element(this.rootNode, name, false, false);
    }

    protected Element createElement(String tagName, boolean voidElement, boolean selfClosed) {
        return new Element(this.rootNode, tagName, voidElement, selfClosed);
    }

    protected Text createText(String text) {
        return new Text(this.rootNode, text);
    }

    protected DocumentType createDocumentType(String value, String publicId, String baseUri) {
        return new DocumentType(this.rootNode, value, publicId, baseUri);
    }

    protected XmlDeclaration createXmlDeclaration(Tag tag) {
        return new XmlDeclaration(this.rootNode, tag);
    }
}

