/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.gui.action;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.ReportGuiPackage;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.gui.util.ReportFileDialoger;
import org.apache.jmeter.save.SaveGraphicsService;
import org.apache.jmeter.visualizers.Printable;

public class ReportSaveGraphics
implements Command {
    public static final String SAVE_GRAPHICS = "save_graphics";
    private static final Set<String> commands = new HashSet<String>();
    private static final String[] extensions;

    public Set<String> getActionNames() {
        return commands;
    }

    public void doAction(ActionEvent e) throws IllegalUserActionException {
        JMeterGUIComponent component = null;
        JComponent comp = null;
        if (!commands.contains(e.getActionCommand())) {
            throw new IllegalUserActionException("Invalid user command:" + e.getActionCommand());
        }
        if (e.getActionCommand().equals(SAVE_GRAPHICS) && (component = ReportGuiPackage.getInstance().getCurrentGui()) instanceof Printable) {
            comp = ((Printable)component).getPrintableComponent();
            JFileChooser chooser = ReportFileDialoger.promptToSaveFile(ReportGuiPackage.getInstance().getTreeListener().getCurrentNode().getName(), extensions);
            if (chooser == null) {
                return;
            }
            String filename = chooser.getSelectedFile().getAbsolutePath();
            if (filename != null) {
                SaveGraphicsService save = new SaveGraphicsService();
                String ext = filename.substring(filename.length() - 4);
                String name = filename.substring(0, filename.length() - 4);
                if (ext.equals(".png")) {
                    save.saveJComponent(name, 0, comp);
                } else if (ext.equals(".tif")) {
                    save.saveJComponent(name, 1, comp);
                } else {
                    save.saveJComponent(filename, 0, comp);
                }
            }
        }
    }

    static {
        commands.add(SAVE_GRAPHICS);
        extensions = new String[]{".tif", ".png"};
    }
}

