/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jdbc.config;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.excalibur.datasource.ResourceLimitingJdbcDataSource;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.protocol.jdbc.config.DataSourceElementBeanInfo;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testbeans.TestBeanHelper;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class DataSourceElement
extends AbstractTestElement
implements ConfigElement,
TestStateListener,
TestBean {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 233L;
    private transient String dataSource;
    private transient String driver;
    private transient String dbUrl;
    private transient String username;
    private transient String password;
    private transient String checkQuery;
    private transient String poolMax;
    private transient String connectionAge;
    private transient String timeout;
    private transient String trimInterval;
    private transient String transactionIsolation;
    private transient boolean keepAlive;
    private transient boolean autocommit;
    private transient ResourceLimitingJdbcDataSource excaliburSource;
    private transient Set<ResourceLimitingJdbcDataSource> perThreadPoolSet;
    private static final ThreadLocal<Map<String, ResourceLimitingJdbcDataSource>> perThreadPoolMap = new ThreadLocal<Map<String, ResourceLimitingJdbcDataSource>>(){

        @Override
        protected Map<String, ResourceLimitingJdbcDataSource> initialValue() {
            return new HashMap<String, ResourceLimitingJdbcDataSource>();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnded() {
        DataSourceElement dataSourceElement = this;
        synchronized (dataSourceElement) {
            if (this.excaliburSource != null) {
                this.excaliburSource.dispose();
            }
            this.excaliburSource = null;
        }
        if (this.perThreadPoolSet != null) {
            for (ResourceLimitingJdbcDataSource dsc : this.perThreadPoolSet) {
                log.debug("Disposing pool: " + dsc.getInstrumentableName() + " @" + System.identityHashCode(dsc));
                dsc.dispose();
            }
            this.perThreadPoolSet = null;
        }
    }

    public void testEnded(String host) {
        this.testEnded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStarted() {
        this.setRunningVersion(true);
        TestBeanHelper.prepare((TestElement)this);
        JMeterVariables variables = this.getThreadContext().getVariables();
        String poolName = this.getDataSource();
        if (JOrphanUtils.isBlank((String)poolName)) {
            throw new IllegalArgumentException("Variable Name must not be empty for element:" + this.getName());
        }
        if (variables.getObject(poolName) != null) {
            log.error("JDBC data source already defined for: " + poolName);
        } else {
            String maxPool = this.getPoolMax();
            this.perThreadPoolSet = Collections.synchronizedSet(new HashSet());
            if (maxPool.equals("0")) {
                variables.putObject(poolName, (Object)new DataSourceComponentImpl());
            } else {
                ResourceLimitingJdbcDataSource src = this.initPool(maxPool);
                DataSourceElement dataSourceElement = this;
                synchronized (dataSourceElement) {
                    this.excaliburSource = src;
                    variables.putObject(poolName, (Object)new DataSourceComponentImpl(this.excaliburSource));
                }
            }
        }
    }

    public void testStarted(String host) {
        this.testStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        DataSourceElement el = (DataSourceElement)((Object)super.clone());
        DataSourceElement dataSourceElement = this;
        synchronized (dataSourceElement) {
            el.excaliburSource = this.excaliburSource;
            el.perThreadPoolSet = this.perThreadPoolSet;
        }
        return el;
    }

    public static Connection getConnection(String poolName) throws SQLException {
        Object poolObject = JMeterContextService.getContext().getVariables().getObject(poolName);
        if (poolObject == null) {
            throw new SQLException("No pool found named: '" + poolName + "', ensure Variable Name matches Variable Name of JDBC Connection Configuration");
        }
        if (poolObject instanceof DataSourceComponent) {
            DataSourceComponent pool = (DataSourceComponent)poolObject;
            return pool.getConnection();
        }
        String errorMsg = "Found object stored under variable:'" + poolName + "' with class:" + poolObject.getClass().getName() + " and value: '" + poolObject + " but it's not a DataSourceComponent, check you're not already using this name as another variable";
        log.error(errorMsg);
        throw new SQLException(errorMsg);
    }

    private ResourceLimitingJdbcDataSource initPool(String maxPool) {
        ResourceLimitingJdbcDataSource source = null;
        source = new ResourceLimitingJdbcDataSource();
        DefaultConfiguration config = new DefaultConfiguration("rl-jdbc");
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(40);
            sb.append("MaxPool: ");
            sb.append(maxPool);
            sb.append(" Timeout: ");
            sb.append(this.getTimeout());
            sb.append(" TrimInt: ");
            sb.append(this.getTrimInterval());
            sb.append(" Auto-Commit: ");
            sb.append(this.isAutocommit());
            log.debug(sb.toString());
        }
        DefaultConfiguration poolController = new DefaultConfiguration("pool-controller");
        poolController.setAttribute("max", maxPool);
        poolController.setAttribute("max-strict", "true");
        poolController.setAttribute("blocking", "true");
        poolController.setAttribute("timeout", this.getTimeout());
        poolController.setAttribute("trim-interval", this.getTrimInterval());
        config.addChild((Configuration)poolController);
        DefaultConfiguration autoCommit = new DefaultConfiguration("auto-commit");
        autoCommit.setValue(String.valueOf(this.isAutocommit()));
        config.addChild((Configuration)autoCommit);
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(40);
            sb.append("KeepAlive: ");
            sb.append(this.isKeepAlive());
            sb.append(" Age: ");
            sb.append(this.getConnectionAge());
            sb.append(" CheckQuery: ");
            sb.append(this.getCheckQuery());
            log.debug(sb.toString());
        }
        DefaultConfiguration cfgKeepAlive = new DefaultConfiguration("keep-alive");
        cfgKeepAlive.setAttribute("disable", String.valueOf(!this.isKeepAlive()));
        cfgKeepAlive.setAttribute("age", this.getConnectionAge());
        cfgKeepAlive.setValue(this.getCheckQuery());
        poolController.addChild((Configuration)cfgKeepAlive);
        String _username = this.getUsername();
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(40);
            sb.append("Driver: ");
            sb.append(this.getDriver());
            sb.append(" DbUrl: ");
            sb.append(this.getDbUrl());
            sb.append(" User: ");
            sb.append(_username);
            log.debug(sb.toString());
        }
        DefaultConfiguration cfgDriver = new DefaultConfiguration("driver");
        cfgDriver.setValue(this.getDriver());
        config.addChild((Configuration)cfgDriver);
        DefaultConfiguration cfgDbUrl = new DefaultConfiguration("dburl");
        cfgDbUrl.setValue(this.getDbUrl());
        config.addChild((Configuration)cfgDbUrl);
        if (_username.length() > 0) {
            DefaultConfiguration cfgUsername = new DefaultConfiguration("user");
            cfgUsername.setValue(_username);
            config.addChild((Configuration)cfgUsername);
            DefaultConfiguration cfgPassword = new DefaultConfiguration("password");
            cfgPassword.setValue(this.getPassword());
            config.addChild((Configuration)cfgPassword);
        }
        source.enableLogging((org.apache.avalon.framework.logger.Logger)new LogKitLogger(log));
        try {
            source.configure((Configuration)config);
            source.setInstrumentableName(this.getDataSource());
        }
        catch (ConfigurationException e) {
            log.error("Could not configure datasource for pool: " + this.getDataSource(), (Throwable)e);
        }
        return source;
    }

    public void addConfigElement(ConfigElement config) {
    }

    public boolean expectsModification() {
        return false;
    }

    public String getCheckQuery() {
        return this.checkQuery;
    }

    public void setCheckQuery(String checkQuery) {
        this.checkQuery = checkQuery;
    }

    public String getConnectionAge() {
        return this.connectionAge;
    }

    public void setConnectionAge(String connectionAge) {
        this.connectionAge = connectionAge;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPoolMax() {
        return this.poolMax;
    }

    public void setPoolMax(String poolMax) {
        this.poolMax = poolMax;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getTrimInterval() {
        return this.trimInterval;
    }

    public void setTrimInterval(String trimInterval) {
        this.trimInterval = trimInterval;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isAutocommit() {
        return this.autocommit;
    }

    public void setAutocommit(boolean autocommit) {
        this.autocommit = autocommit;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public String getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(String transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
    }

    private class DataSourceComponentImpl
    implements DataSourceComponent {
        private final ResourceLimitingJdbcDataSource sharedDSC;

        DataSourceComponentImpl() {
            this.sharedDSC = null;
        }

        DataSourceComponentImpl(ResourceLimitingJdbcDataSource p_dsc) {
            this.sharedDSC = p_dsc;
        }

        public Connection getConnection() throws SQLException {
            Connection conn = null;
            ResourceLimitingJdbcDataSource dsc = null;
            if (this.sharedDSC != null) {
                dsc = this.sharedDSC;
            } else {
                Map poolMap = (Map)perThreadPoolMap.get();
                dsc = (ResourceLimitingJdbcDataSource)poolMap.get(DataSourceElement.this.getDataSource());
                if (dsc == null) {
                    dsc = DataSourceElement.this.initPool("1");
                    poolMap.put(DataSourceElement.this.getDataSource(), dsc);
                    log.debug("Storing pool: " + dsc.getInstrumentableName() + " @" + System.identityHashCode(dsc));
                    DataSourceElement.this.perThreadPoolSet.add(dsc);
                }
            }
            if (dsc != null) {
                conn = dsc.getConnection();
                int transactionIsolation = DataSourceElementBeanInfo.getTransactionIsolationMode(DataSourceElement.this.getTransactionIsolation());
                if (transactionIsolation >= 0 && conn.getTransactionIsolation() != transactionIsolation) {
                    try {
                        conn.setTransactionIsolation(transactionIsolation);
                        log.debug("Setting transaction isolation: " + transactionIsolation + " @" + System.identityHashCode(dsc));
                    }
                    catch (SQLException ex) {
                        log.error("Could not set transaction isolation: " + transactionIsolation + " @" + System.identityHashCode(dsc));
                    }
                }
            }
            return conn;
        }

        public void configure(Configuration arg0) throws ConfigurationException {
        }
    }
}

