/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement.property;

import java.util.Collection;
import java.util.Map;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.DoubleProperty;
import org.apache.jmeter.testelement.property.FloatProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.LongProperty;
import org.apache.jmeter.testelement.property.MapProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.PropertyIteratorImpl;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class AbstractProperty
implements JMeterProperty {
    private static final long serialVersionUID = 240L;
    protected static final Logger log = LoggingManager.getLoggerForClass();
    private String name;
    private transient boolean runningVersion = false;

    public AbstractProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.name = name;
    }

    public AbstractProperty() {
        this("");
    }

    protected boolean isEqualType(JMeterProperty prop) {
        return this.getClass().equals(prop.getClass());
    }

    @Override
    public boolean isRunningVersion() {
        return this.runningVersion;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.name = name;
    }

    @Override
    public void setRunningVersion(boolean runningVersion) {
        this.runningVersion = runningVersion;
    }

    protected PropertyIterator getIterator(Collection<JMeterProperty> values) {
        return new PropertyIteratorImpl(values);
    }

    @Override
    public AbstractProperty clone() {
        try {
            AbstractProperty prop = (AbstractProperty)super.clone();
            prop.name = this.name;
            prop.runningVersion = this.runningVersion;
            return prop;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public int getIntValue() {
        String val = this.getStringValue();
        if (val == null || val.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public long getLongValue() {
        String val = this.getStringValue();
        if (val == null || val.length() == 0) {
            return 0L;
        }
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Override
    public double getDoubleValue() {
        String val = this.getStringValue();
        if (val == null || val.length() == 0) {
            return 0.0;
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException e) {
            log.error("Tried to parse a non-number string to an integer", (Throwable)e);
            return 0.0;
        }
    }

    @Override
    public float getFloatValue() {
        String val = this.getStringValue();
        if (val == null || val.length() == 0) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(val);
        }
        catch (NumberFormatException e) {
            log.error("Tried to parse a non-number string to an integer", (Throwable)e);
            return 0.0f;
        }
    }

    @Override
    public boolean getBooleanValue() {
        String val = this.getStringValue();
        if (val == null || val.length() == 0) {
            return false;
        }
        return Boolean.parseBoolean(val);
    }

    public boolean equals(Object o) {
        if (!(o instanceof JMeterProperty)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        JMeterProperty jpo = (JMeterProperty)o;
        if (!this.name.equals(jpo.getName())) {
            return false;
        }
        Object o1 = this.getObjectValue();
        Object o2 = jpo.getObjectValue();
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + this.name.hashCode();
        Object o = this.getObjectValue();
        result = result * 37 + (o == null ? 0 : o.hashCode());
        return result;
    }

    @Override
    public int compareTo(JMeterProperty arg0) {
        String val = this.getStringValue();
        String val2 = arg0.getStringValue();
        if (val == null) {
            log.warn("Warning: Unexpected null value for property: " + this.name);
            if (val2 == null) {
                return 0;
            }
            return -1;
        }
        return val.compareTo(val2);
    }

    protected Class<? extends JMeterProperty> getPropertyType() {
        return this.getClass();
    }

    protected JMeterProperty getBlankProperty() {
        try {
            JMeterProperty prop = this.getPropertyType().newInstance();
            if (prop instanceof NullProperty) {
                return new StringProperty();
            }
            return prop;
        }
        catch (Exception e) {
            return new StringProperty();
        }
    }

    protected static JMeterProperty getBlankProperty(Object item) {
        if (item == null) {
            return new NullProperty();
        }
        if (item instanceof String) {
            return new StringProperty("", item.toString());
        }
        if (item instanceof Boolean) {
            return new BooleanProperty("", (Boolean)item);
        }
        if (item instanceof Float) {
            return new FloatProperty("", ((Float)item).floatValue());
        }
        if (item instanceof Double) {
            return new DoubleProperty("", (Double)item);
        }
        if (item instanceof Integer) {
            return new IntegerProperty("", (Integer)item);
        }
        if (item instanceof Long) {
            return new LongProperty("", (Long)item);
        }
        if (item instanceof Long) {
            return new LongProperty("", (Long)item);
        }
        return new StringProperty("", item.toString());
    }

    protected Collection<JMeterProperty> normalizeList(Collection<?> coll) {
        if (coll.isEmpty()) {
            Collection<JMeterProperty> okColl = coll;
            return okColl;
        }
        try {
            Collection newColl = (Collection)coll.getClass().newInstance();
            for (JMeterProperty item : coll) {
                newColl.add(this.convertObject(item));
            }
            return newColl;
        }
        catch (Exception e) {
            log.error("Cannot create copy of " + coll.getClass().getName(), (Throwable)e);
            return null;
        }
    }

    protected Map<String, JMeterProperty> normalizeMap(Map<?, ?> coll) {
        if (coll.isEmpty()) {
            Map<String, JMeterProperty> emptyColl = coll;
            return emptyColl;
        }
        try {
            Map newColl = (Map)coll.getClass().newInstance();
            for (Map.Entry<String, JMeterProperty> entry : coll.entrySet()) {
                String key = entry.getKey();
                JMeterProperty prop = entry.getValue();
                String item = null;
                if (key instanceof String) {
                    item = key;
                } else if (key != null) {
                    log.error("Expected key type String, found: " + key.getClass().getName());
                    item = key.toString();
                }
                newColl.put(item, this.convertObject(prop));
            }
            return newColl;
        }
        catch (Exception e) {
            log.error("Cannot create copy of " + coll.getClass().getName(), (Throwable)e);
            return null;
        }
    }

    public static JMeterProperty createProperty(Object item) {
        JMeterProperty prop = AbstractProperty.makeProperty(item);
        if (prop == null) {
            prop = AbstractProperty.getBlankProperty(item);
        }
        return prop;
    }

    protected static JMeterProperty makeProperty(Object item) {
        if (item instanceof JMeterProperty) {
            return (JMeterProperty)item;
        }
        if (item instanceof TestElement) {
            return new TestElementProperty(((TestElement)item).getName(), (TestElement)item);
        }
        if (item instanceof Collection) {
            return new CollectionProperty(Integer.toString(item.hashCode()), (Collection)item);
        }
        if (item instanceof Map) {
            return new MapProperty(Integer.toString(item.hashCode()), (Map)item);
        }
        return null;
    }

    protected JMeterProperty convertObject(Object item) {
        JMeterProperty prop = AbstractProperty.makeProperty(item);
        if (prop == null) {
            prop = this.getBlankProperty();
            prop.setName(Integer.toString(item.hashCode()));
            prop.setObjectValue(item);
        }
        return prop;
    }

    public String toString() {
        return this.getStringValue();
    }

    @Override
    public void mergeIn(JMeterProperty prop) {
    }
}

