/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement.property;

import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.MultiProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;

public class TestElementProperty
extends MultiProperty {
    private static final long serialVersionUID = 233L;
    private TestElement value;
    private transient TestElement savedValue = null;

    public TestElementProperty(String name, TestElement value) {
        super(name);
        this.value = value;
    }

    public TestElementProperty() {
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof TestElementProperty) {
            if (this == o) {
                return true;
            }
            if (this.value != null) {
                return this.value.equals(((JMeterProperty)o).getObjectValue());
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    @Override
    public String getStringValue() {
        return this.value.toString();
    }

    @Override
    public void setObjectValue(Object v) {
        if (v instanceof TestElement) {
            this.value = (TestElement)v;
        }
    }

    @Override
    public Object getObjectValue() {
        return this.value;
    }

    public TestElement getElement() {
        return this.value;
    }

    public void setElement(TestElement el) {
        this.value = el;
    }

    @Override
    public TestElementProperty clone() {
        TestElementProperty prop = (TestElementProperty)super.clone();
        prop.value = (TestElement)this.value.clone();
        return prop;
    }

    @Override
    public void mergeIn(JMeterProperty prop) {
        if (this.isEqualType(prop)) {
            this.value.addTestElement((TestElement)prop.getObjectValue());
        }
    }

    @Override
    public void recoverRunningVersion(TestElement owner) {
        if (this.savedValue != null) {
            this.value = this.savedValue;
        }
        this.value.recoverRunningVersion();
    }

    @Override
    public void setRunningVersion(boolean runningVersion) {
        super.setRunningVersion(runningVersion);
        this.value.setRunningVersion(runningVersion);
        this.savedValue = runningVersion ? this.value : null;
    }

    @Override
    public void addProperty(JMeterProperty prop) {
        this.value.setProperty(prop);
    }

    @Override
    public void clear() {
        this.value.clear();
    }

    @Override
    public PropertyIterator iterator() {
        return this.value.propertyIterator();
    }
}

