/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.chartText;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jCharts.test.HTMLGenerator;
import org.jCharts.test.HTMLTestable;

public class TextTag
implements HTMLTestable,
Serializable {
    private float xPosition = 0.0f;
    private float yPosition = 0.0f;
    private TextLayout textLayout = null;
    private Hashtable attributes = null;
    private boolean isHidden = false;
    private float width = 0.0f;
    private float height = 0.0f;
    private float fontAscent = 0.0f;
    private float fontDescent = 0.0f;
    private boolean isDerived = false;
    private Font derivedFont = null;
    private String text;
    private Font font;

    public TextTag(String string, Font font, FontRenderContext fontRenderContext) {
        this(string, font, null, fontRenderContext);
    }

    public TextTag(String string, Font font, Font font2, FontRenderContext fontRenderContext) {
        this.textLayout = new TextLayout(string, font, fontRenderContext);
        this.isDerived = font2 != null;
        this.derivedFont = font2;
        this.width = this.textLayout.getAdvance();
        this.height = this.textLayout.getAscent() + this.textLayout.getDescent();
        this.fontAscent = this.textLayout.getAscent();
        this.fontDescent = this.textLayout.getDescent();
        this.font = this.isDerived ? font2 : font;
        this.text = string;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getFontAscent() {
        return this.fontAscent;
    }

    public float getFontDescent() {
        return this.fontDescent;
    }

    public void setPosition(float f, float f2) {
        this.xPosition = f;
        this.yPosition = f2;
    }

    public void setXPosition(float f) {
        this.xPosition = f;
    }

    public void setYPosition(float f) {
        this.yPosition = f;
    }

    public float getXPosition() {
        return this.xPosition;
    }

    public float getYPosition() {
        return this.yPosition;
    }

    public float getRightSide() {
        return this.xPosition + this.width;
    }

    public float getBottomSide() {
        return this.yPosition + this.height;
    }

    public Rectangle2D.Float getRectangle() {
        return new Rectangle2D.Float(this.xPosition, this.yPosition, this.width, this.height);
    }

    public void setHidden(boolean bl) {
        this.isHidden = bl;
    }

    public boolean getHidden() {
        return this.isHidden;
    }

    public String getText() {
        return this.text;
    }

    public void addAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(string, object);
    }

    public Object getAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(string);
    }

    public void render(Graphics2D graphics2D, Paint paint) {
        if (paint != null) {
            graphics2D.setPaint(paint);
        }
        if (!this.isHidden) {
            if (this.isDerived) {
                graphics2D.setFont(this.derivedFont);
                graphics2D.drawString(this.text, this.xPosition, this.yPosition);
            } else {
                this.textLayout.draw(graphics2D, this.xPosition, this.yPosition);
            }
        }
    }

    public void render(Graphics2D graphics2D, float f, float f2) {
        this.textLayout.draw(graphics2D, f, f2);
    }

    public void toHTML(HTMLGenerator hTMLGenerator) {
        hTMLGenerator.propertiesTableStart(this.getClass().getName());
        Field[] fieldArray = this.getClass().getDeclaredFields();
        int n = 0;
        while (n < fieldArray.length) {
            try {
                hTMLGenerator.addField(fieldArray[n].getName(), fieldArray[n].get(this));
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            ++n;
        }
        hTMLGenerator.propertiesTableEnd();
    }

    public String toString() {
        String string = "TextTag: '" + this.text + "',x=" + this.xPosition + ",y=" + this.yPosition;
        string = string + "width=" + this.width + ",height=" + this.height;
        string = string + ",font=" + this.font.getName() + "," + this.font.getSize();
        if (this.attributes != null && this.attributes.size() > 0) {
            Enumeration enumeration = this.attributes.keys();
            string = string + "\nAttributes:";
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                string = string + "    [" + k.toString() + "]=[" + this.attributes.get(k).toString() + "]\n";
            }
        }
        return string;
    }
}

