/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpConnection;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;
import org.apache.jmeter.protocol.http.control.AuthManager;
import org.apache.jmeter.protocol.http.control.CacheManager;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.protocol.http.control.DNSCacheManager;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.sampler.HTTPHCAbstractImpl;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.sampler.HttpClientDefaultParameters;
import org.apache.jmeter.protocol.http.sampler.HttpWebdav;
import org.apache.jmeter.protocol.http.util.HC4TrustAllSSLSocketFactory;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.protocol.http.util.HTTPFileArg;
import org.apache.jmeter.protocol.http.util.SlowHC4SSLSocketFactory;
import org.apache.jmeter.protocol.http.util.SlowHC4SocketFactory;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.JsseSSLManager;
import org.apache.jmeter.util.SSLManager;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class HTTPHC4Impl
extends HTTPHCAbstractImpl {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final int RETRY_COUNT = JMeterUtils.getPropDefault((String)"httpclient4.retrycount", (int)0);
    private static final int IDLE_TIMEOUT = JMeterUtils.getPropDefault((String)"httpclient4.idletimeout", (int)0);
    private static final String CONTEXT_METRICS = "jmeter_metrics";
    private static final ConnectionKeepAliveStrategy IDLE_STRATEGY = new DefaultConnectionKeepAliveStrategy(){

        public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
            long duration = super.getKeepAliveDuration(response, context);
            if (duration <= 0L) {
                log.debug("Setting keepalive to " + IDLE_TIMEOUT);
                return IDLE_TIMEOUT;
            }
            return duration;
        }
    };
    private static final HttpResponseInterceptor METRICS_SAVER = new HttpResponseInterceptor(){

        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            HttpConnection conn = (HttpConnection)context.getAttribute("http.connection");
            HttpConnectionMetrics metrics = conn.getMetrics();
            context.setAttribute(HTTPHC4Impl.CONTEXT_METRICS, (Object)metrics);
        }
    };
    private static final HttpRequestInterceptor METRICS_RESETTER = new HttpRequestInterceptor(){

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            HttpConnection conn = (HttpConnection)context.getAttribute("http.connection");
            HttpConnectionMetrics metrics = conn.getMetrics();
            metrics.reset();
        }
    };
    private static final ThreadLocal<Map<HttpClientKey, HttpClient>> HTTPCLIENTS = new ThreadLocal<Map<HttpClientKey, HttpClient>>(){

        @Override
        protected Map<HttpClientKey, HttpClient> initialValue() {
            return new HashMap<HttpClientKey, HttpClient>();
        }
    };
    private static final Scheme SLOW_HTTP;
    private static final Scheme HTTPS_SCHEME;
    private static final HttpParams DEFAULT_HTTP_PARAMS;
    private volatile HttpUriRequest currentRequest;
    private volatile boolean resetSSLContext;

    protected HTTPHC4Impl(HTTPSamplerBase testElement) {
        super(testElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HTTPSampleResult sample(URL url, String method, boolean areFollowingRedirect, int frameDepth) {
        if (log.isDebugEnabled()) {
            log.debug("Start : sample " + url.toString());
            log.debug("method " + method + " followingRedirect " + areFollowingRedirect + " depth " + frameDepth);
        }
        HTTPSampleResult res = this.createSampleResult(url, method);
        HttpClient httpClient = this.setupClient(url);
        Object httpRequest = null;
        try {
            URI uri = url.toURI();
            if (method.equals("POST")) {
                httpRequest = new HttpPost(uri);
            } else if (method.equals("PUT")) {
                httpRequest = new HttpPut(uri);
            } else if (method.equals("HEAD")) {
                httpRequest = new HttpHead(uri);
            } else if (method.equals("TRACE")) {
                httpRequest = new HttpTrace(uri);
            } else if (method.equals("OPTIONS")) {
                httpRequest = new HttpOptions(uri);
            } else if (method.equals("DELETE")) {
                httpRequest = new HttpDelete(uri);
            } else if (method.equals("GET")) {
                httpRequest = new HttpGet(uri);
            } else if (method.equals("PATCH")) {
                httpRequest = new HttpPatch(uri);
            } else if (HttpWebdav.isWebdavMethod(method)) {
                httpRequest = new HttpWebdav(method, uri);
            } else {
                throw new IllegalArgumentException("Unexpected method: '" + method + "'");
            }
            this.setupRequest(url, (HttpRequestBase)httpRequest, res);
        }
        catch (Exception e) {
            res.sampleStart();
            res.sampleEnd();
            this.errorResult(e, res);
            return res;
        }
        BasicHttpContext localContext = new BasicHttpContext();
        res.sampleStart();
        CacheManager cacheManager = this.getCacheManager();
        if (cacheManager != null && "GET".equalsIgnoreCase(method) && cacheManager.inCache(url)) {
            return this.updateSampleResultForResourceInCache(res);
        }
        try {
            HttpEntity entity;
            this.currentRequest = httpRequest;
            this.handleMethod(method, res, (HttpRequestBase)httpRequest, (HttpContext)localContext);
            HttpResponse httpResponse = this.executeRequest(httpClient, (HttpRequestBase)httpRequest, (HttpContext)localContext, url);
            HttpRequest request = (HttpRequest)localContext.getAttribute("http.request");
            InetAddress localAddr = (InetAddress)httpRequest.getParams().getParameter("http.route.local-address");
            if (localAddr != null) {
                request.addHeader("X-LocalAddress", localAddr.toString());
            }
            res.setRequestHeaders(this.getConnectionHeaders(request));
            org.apache.http.Header contentType = httpResponse.getLastHeader("Content-Type");
            if (contentType != null) {
                String ct = contentType.getValue();
                res.setContentType(ct);
                res.setEncodingAndType(ct);
            }
            if ((entity = httpResponse.getEntity()) != null) {
                InputStream instream = entity.getContent();
                res.setResponseData(this.readResponse((SampleResult)res, instream, (int)entity.getContentLength()));
            }
            res.sampleEnd();
            this.currentRequest = null;
            StatusLine statusLine = httpResponse.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            res.setResponseCode(Integer.toString(statusCode));
            res.setResponseMessage(statusLine.getReasonPhrase());
            res.setSuccessful(this.isSuccessCode(statusCode));
            res.setResponseHeaders(this.getResponseHeaders(httpResponse));
            if (res.isRedirect()) {
                org.apache.http.Header headerLocation = httpResponse.getLastHeader("Location");
                if (headerLocation == null) {
                    throw new IllegalArgumentException("Missing location header in redirect for " + httpRequest.getRequestLine());
                }
                String redirectLocation = headerLocation.getValue();
                res.setRedirectLocation(redirectLocation);
            }
            HttpConnectionMetrics metrics = (HttpConnectionMetrics)localContext.getAttribute(CONTEXT_METRICS);
            long headerBytes = res.getResponseHeaders().length() + httpResponse.getAllHeaders().length + 1 + 2;
            long totalBytes = metrics.getReceivedBytesCount();
            res.setHeadersSize((int)headerBytes);
            res.setBodySize((int)(totalBytes - headerBytes));
            if (log.isDebugEnabled()) {
                log.debug("ResponseHeadersSize=" + res.getHeadersSize() + " Content-Length=" + res.getBodySize() + " Total=" + (res.getHeadersSize() + res.getBodySize()));
            }
            if (this.getAutoRedirects()) {
                HttpUriRequest req = (HttpUriRequest)localContext.getAttribute("http.request");
                HttpHost target = (HttpHost)localContext.getAttribute("http.target_host");
                URI redirectURI = req.getURI();
                if (redirectURI.isAbsolute()) {
                    res.setURL(redirectURI.toURL());
                } else {
                    res.setURL(new URL(new URL(target.toURI()), redirectURI.toString()));
                }
            }
            this.saveConnectionCookies(httpResponse, res.getURL(), this.getCookieManager());
            if (cacheManager != null) {
                cacheManager.saveDetails(httpResponse, res);
            }
            res = this.resultProcessing(areFollowingRedirect, frameDepth, res);
        }
        catch (IOException e) {
            res.sampleEnd();
            log.debug("IOException", (Throwable)e);
            res.setRequestHeaders(this.getConnectionHeaders((HttpRequest)localContext.getAttribute("http.request")));
            this.errorResult(e, res);
            HTTPSampleResult hTTPSampleResult = res;
            return hTTPSampleResult;
        }
        catch (RuntimeException e) {
            res.sampleEnd();
            log.debug("RuntimeException", (Throwable)e);
            this.errorResult(e, res);
            HTTPSampleResult hTTPSampleResult = res;
            return hTTPSampleResult;
        }
        finally {
            this.currentRequest = null;
        }
        return res;
    }

    protected void handleMethod(String method, HTTPSampleResult result, HttpRequestBase httpRequest, HttpContext localContext) throws IOException {
        if (method.equals("POST")) {
            String postBody = this.sendPostData((HttpPost)httpRequest);
            result.setQueryString(postBody);
        } else if (method.equals("PUT") || method.equals("PATCH") || HttpWebdav.isWebdavMethod(method) || method.equals("DELETE")) {
            String entityBody = this.sendEntityData((HttpEntityEnclosingRequestBase)httpRequest);
            result.setQueryString(entityBody);
        }
    }

    protected HTTPSampleResult createSampleResult(URL url, String method) {
        HTTPSampleResult res = new HTTPSampleResult();
        res.setMonitor(this.isMonitor());
        res.setSampleLabel(url.toString());
        res.setHTTPMethod(method);
        res.setURL(url);
        return res;
    }

    private HttpResponse executeRequest(final HttpClient httpClient, final HttpRequestBase httpRequest, final HttpContext localContext, URL url) throws IOException, ClientProtocolException {
        Subject subject;
        AuthManager authManager = this.getAuthManager();
        if (authManager != null && (subject = authManager.getSubjectForUrl(url)) != null) {
            try {
                return Subject.doAs(subject, new PrivilegedExceptionAction<HttpResponse>(){

                    @Override
                    public HttpResponse run() throws Exception {
                        return httpClient.execute((HttpUriRequest)httpRequest, localContext);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                log.error("Can't execute httpRequest with subject:" + subject, (Throwable)e);
                throw new RuntimeException("Can't execute httpRequest with subject:" + subject, e);
            }
        }
        return httpClient.execute((HttpUriRequest)httpRequest, localContext);
    }

    private HttpClient setupClient(URL url) {
        boolean useDynamicProxy;
        Map<HttpClientKey, HttpClient> map = HTTPCLIENTS.get();
        String host = url.getHost();
        String proxyHost = this.getProxyHost();
        int proxyPort = this.getProxyPortInt();
        boolean useStaticProxy = HTTPHC4Impl.isStaticProxy(host);
        HttpClientKey key = new HttpClientKey(url, useStaticProxy || useDynamicProxy, (useDynamicProxy = this.isDynamicProxy(proxyHost, proxyPort)) ? proxyHost : PROXY_HOST, useDynamicProxy ? proxyPort : PROXY_PORT, useDynamicProxy ? this.getProxyUser() : PROXY_USER, useDynamicProxy ? this.getProxyPass() : PROXY_PASS);
        Object httpClient = map.get(key);
        if (httpClient != null && this.resetSSLContext && "https".equalsIgnoreCase(url.getProtocol())) {
            ((AbstractHttpClient)httpClient).clearRequestInterceptors();
            ((AbstractHttpClient)httpClient).clearResponseInterceptors();
            httpClient.getConnectionManager().shutdown();
            httpClient = null;
            JsseSSLManager sslMgr = (JsseSSLManager)SSLManager.getInstance();
            sslMgr.resetContext();
            this.resetSSLContext = false;
        }
        if (httpClient == null) {
            DefaultedHttpParams clientParams = new DefaultedHttpParams((HttpParams)new BasicHttpParams(), DEFAULT_HTTP_PARAMS);
            DNSCacheManager resolver = this.testElement.getDNSResolver();
            if (resolver == null) {
                resolver = new SystemDefaultDnsResolver();
            }
            PoolingClientConnectionManager poolingClientConnectionManager = new PoolingClientConnectionManager(SchemeRegistryFactory.createDefault(), (DnsResolver)resolver);
            httpClient = new DefaultHttpClient((ClientConnectionManager)poolingClientConnectionManager, (HttpParams)clientParams){

                protected HttpRequestRetryHandler createHttpRequestRetryHandler() {
                    return new DefaultHttpRequestRetryHandler(RETRY_COUNT, false);
                }
            };
            if (IDLE_TIMEOUT > 0) {
                ((AbstractHttpClient)httpClient).setKeepAliveStrategy(IDLE_STRATEGY);
            }
            ((AbstractHttpClient)httpClient).addResponseInterceptor((HttpResponseInterceptor)new ResponseContentEncoding());
            ((AbstractHttpClient)httpClient).addResponseInterceptor(METRICS_SAVER);
            ((AbstractHttpClient)httpClient).addRequestInterceptor(METRICS_RESETTER);
            SchemeRegistry schemeRegistry = httpClient.getConnectionManager().getSchemeRegistry();
            if (SLOW_HTTP != null) {
                schemeRegistry.register(SLOW_HTTP);
            }
            if (HTTPS_SCHEME != null) {
                schemeRegistry.register(HTTPS_SCHEME);
            }
            if (useDynamicProxy) {
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                clientParams.setParameter("http.route.default-proxy", (Object)proxy);
                String proxyUser = this.getProxyUser();
                if (proxyUser.length() > 0) {
                    ((AbstractHttpClient)httpClient).getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new NTCredentials(proxyUser, this.getProxyPass(), localHost, PROXY_DOMAIN));
                }
            } else if (useStaticProxy) {
                HttpHost proxy = new HttpHost(PROXY_HOST, PROXY_PORT);
                clientParams.setParameter("http.route.default-proxy", (Object)proxy);
                if (PROXY_USER.length() > 0) {
                    ((AbstractHttpClient)httpClient).getCredentialsProvider().setCredentials(new AuthScope(PROXY_HOST, PROXY_PORT), (Credentials)new NTCredentials(PROXY_USER, PROXY_PASS, localHost, PROXY_DOMAIN));
                }
            }
            clientParams.setParameter("http.protocol.cookie-policy", (Object)"ignoreCookies");
            if (log.isDebugEnabled()) {
                log.debug("Created new HttpClient: @" + System.identityHashCode(httpClient) + " " + key.toString());
            }
            map.put(key, (HttpClient)httpClient);
        } else if (log.isDebugEnabled()) {
            log.debug("Reusing the HttpClient: @" + System.identityHashCode(httpClient) + " " + key.toString());
        }
        this.setConnectionAuthorization((HttpClient)httpClient, url, this.getAuthManager(), key);
        return httpClient;
    }

    protected void setupRequest(URL url, HttpRequestBase httpRequest, HTTPSampleResult res) throws IOException {
        int cto;
        HttpParams requestParams = httpRequest.getParams();
        InetAddress inetAddr = this.getIpSourceAddress();
        if (inetAddr != null) {
            requestParams.setParameter("http.route.local-address", (Object)inetAddr);
        } else if (localAddress != null) {
            requestParams.setParameter("http.route.local-address", (Object)localAddress);
        } else {
            requestParams.removeParameter("http.route.local-address");
        }
        int rto = this.getResponseTimeout();
        if (rto > 0) {
            requestParams.setIntParameter("http.socket.timeout", rto);
        }
        if ((cto = this.getConnectTimeout()) > 0) {
            requestParams.setIntParameter("http.connection.timeout", cto);
        }
        requestParams.setBooleanParameter("http.protocol.handle-redirects", this.getAutoRedirects());
        if (this.getUseKeepAlive()) {
            httpRequest.setHeader("Connection", "keep-alive");
        } else {
            httpRequest.setHeader("Connection", "close");
        }
        this.setConnectionHeaders(httpRequest, url, this.getHeaderManager(), this.getCacheManager());
        String cookies = this.setConnectionCookie((HttpRequest)httpRequest, url, this.getCookieManager());
        if (res != null) {
            res.setCookies(cookies);
        }
    }

    protected void setDefaultRequestHeaders(HttpRequest request) {
    }

    private String getResponseHeaders(HttpResponse response) {
        StringBuilder headerBuf = new StringBuilder();
        org.apache.http.Header[] rh = response.getAllHeaders();
        headerBuf.append(response.getStatusLine());
        headerBuf.append("\n");
        for (int i = 0; i < rh.length; ++i) {
            headerBuf.append(rh[i].getName());
            headerBuf.append(": ");
            headerBuf.append(rh[i].getValue());
            headerBuf.append("\n");
        }
        return headerBuf.toString();
    }

    protected String setConnectionCookie(HttpRequest request, URL url, CookieManager cookieManager) {
        String cookieHeader = null;
        if (cookieManager != null && (cookieHeader = cookieManager.getCookieHeaderForURL(url)) != null) {
            request.setHeader("Cookie", cookieHeader);
        }
        return cookieHeader;
    }

    protected void setConnectionHeaders(HttpRequestBase request, URL url, HeaderManager headerManager, CacheManager cacheManager) {
        CollectionProperty headers;
        if (headerManager != null && (headers = headerManager.getHeaders()) != null) {
            PropertyIterator i = headers.iterator();
            while (i.hasNext()) {
                Header header = (Header)i.next().getObjectValue();
                String n = header.getName();
                if ("Content-Length".equalsIgnoreCase(n)) continue;
                String v = header.getValue();
                if ("Host".equalsIgnoreCase(n)) {
                    int port = url.getPort();
                    v = v.replaceFirst(":\\d+$", "");
                    if (port != -1 && port == url.getDefaultPort()) {
                        port = -1;
                    }
                    request.getParams().setParameter("http.virtual-host", (Object)new HttpHost(v, port));
                    continue;
                }
                request.addHeader(n, v);
            }
        }
        if (cacheManager != null) {
            cacheManager.setHeaders(url, request);
        }
    }

    private String getConnectionHeaders(HttpRequest method) {
        if (method != null) {
            StringBuilder hdrs = new StringBuilder(100);
            org.apache.http.Header[] requestHeaders = method.getAllHeaders();
            for (int i = 0; i < requestHeaders.length; ++i) {
                if ("Cookie".equalsIgnoreCase(requestHeaders[i].getName())) continue;
                hdrs.append(requestHeaders[i].getName());
                hdrs.append(": ");
                hdrs.append(requestHeaders[i].getValue());
                hdrs.append("\n");
            }
            return hdrs.toString();
        }
        return "";
    }

    private void setConnectionAuthorization(HttpClient client, URL url, AuthManager authManager, HttpClientKey key) {
        CredentialsProvider credentialsProvider = ((AbstractHttpClient)client).getCredentialsProvider();
        if (authManager != null) {
            if (authManager.hasAuthForURL(url)) {
                authManager.setupCredentials(client, url, credentialsProvider, localHost);
            } else {
                credentialsProvider.clear();
            }
        } else {
            Credentials credentials = null;
            AuthScope authScope = null;
            if (key.hasProxy && !StringUtils.isEmpty((CharSequence)key.proxyUser)) {
                authScope = new AuthScope(key.proxyHost, key.proxyPort);
                credentials = credentialsProvider.getCredentials(authScope);
            }
            credentialsProvider.clear();
            if (credentials != null) {
                credentialsProvider.setCredentials(authScope, credentials);
            }
        }
    }

    protected String sendPostData(HttpPost post) throws IOException {
        boolean haveContentEncoding;
        StringBuilder postedBody = new StringBuilder(1000);
        HTTPFileArg[] files = this.getHTTPFiles();
        String contentEncoding = this.getContentEncodingOrNull();
        boolean bl = haveContentEncoding = contentEncoding != null;
        if (this.getUseMultipartForPost()) {
            Charset charset = null;
            if (haveContentEncoding) {
                charset = Charset.forName(contentEncoding);
            }
            MultipartEntity multiPart = new MultipartEntity(this.getDoBrowserCompatibleMultipart() ? HttpMultipartMode.BROWSER_COMPATIBLE : HttpMultipartMode.STRICT, null, charset);
            PropertyIterator args = this.getArguments().iterator();
            while (args.hasNext()) {
                String parameterName;
                HTTPArgument arg = (HTTPArgument)args.next().getObjectValue();
                if (arg.isSkippable(parameterName = arg.getName())) continue;
                StringBody stringBody = new StringBody(arg.getValue(), charset);
                FormBodyPart formPart = new FormBodyPart(arg.getName(), (ContentBody)stringBody);
                multiPart.addPart(formPart);
            }
            ViewableFileBody[] fileBodies = new ViewableFileBody[files.length];
            for (int i = 0; i < files.length; ++i) {
                HTTPFileArg file = files[i];
                fileBodies[i] = new ViewableFileBody(new File(file.getPath()), file.getMimeType());
                multiPart.addPart(file.getParamName(), (ContentBody)fileBodies[i]);
            }
            post.setEntity((HttpEntity)multiPart);
            if (multiPart.isRepeatable()) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                for (ViewableFileBody fileBody : fileBodies) {
                    fileBody.hideFileData = true;
                }
                multiPart.writeTo((OutputStream)bos);
                for (ViewableFileBody fileBody : fileBodies) {
                    fileBody.hideFileData = false;
                }
                bos.flush();
                postedBody.append(new String(bos.toByteArray(), contentEncoding == null ? "US-ASCII" : contentEncoding));
                bos.close();
            } else {
                postedBody.append("<Multipart was not repeatable, cannot view what was sent>");
            }
        } else {
            boolean hasContentTypeHeader;
            org.apache.http.Header contentTypeHeader = post.getFirstHeader("Content-Type");
            boolean bl2 = hasContentTypeHeader = contentTypeHeader != null && contentTypeHeader.getValue() != null && contentTypeHeader.getValue().length() > 0;
            if (!this.hasArguments() && this.getSendFileAsPostBody()) {
                HTTPFileArg file = files[0];
                if (!hasContentTypeHeader) {
                    if (file.getMimeType() != null && file.getMimeType().length() > 0) {
                        post.setHeader("Content-Type", file.getMimeType());
                    } else {
                        post.setHeader("Content-Type", "application/x-www-form-urlencoded");
                    }
                }
                FileEntity fileRequestEntity = new FileEntity(new File(file.getPath()), (ContentType)null);
                post.setEntity((HttpEntity)fileRequestEntity);
                postedBody.append("<actual file content, not shown here>");
            } else {
                if (haveContentEncoding) {
                    post.getParams().setParameter("http.protocol.content-charset", (Object)contentEncoding);
                }
                if (this.getSendParameterValuesAsPostBody()) {
                    if (!hasContentTypeHeader) {
                        HTTPFileArg file;
                        HTTPFileArg hTTPFileArg = file = files.length > 0 ? files[0] : null;
                        if (file != null && file.getMimeType() != null && file.getMimeType().length() > 0) {
                            post.setHeader("Content-Type", file.getMimeType());
                        } else {
                            post.setHeader("Content-Type", "application/x-www-form-urlencoded");
                        }
                    }
                    StringBuilder postBody = new StringBuilder();
                    PropertyIterator args = this.getArguments().iterator();
                    while (args.hasNext()) {
                        HTTPArgument arg = (HTTPArgument)args.next().getObjectValue();
                        if (haveContentEncoding) {
                            postBody.append(arg.getEncodedValue(contentEncoding));
                            continue;
                        }
                        postBody.append(arg.getEncodedValue());
                    }
                    StringEntity requestEntity = new StringEntity(postBody.toString(), contentEncoding);
                    post.setEntity((HttpEntity)requestEntity);
                    postedBody.append(postBody.toString());
                } else {
                    if (!hasContentTypeHeader) {
                        post.setHeader("Content-Type", "application/x-www-form-urlencoded");
                    }
                    PropertyIterator args = this.getArguments().iterator();
                    ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                    String urlContentEncoding = contentEncoding;
                    if (urlContentEncoding == null || urlContentEncoding.length() == 0) {
                        urlContentEncoding = "UTF-8";
                    }
                    while (args.hasNext()) {
                        String parameterName;
                        HTTPArgument arg = (HTTPArgument)args.next().getObjectValue();
                        if (arg.isSkippable(parameterName = arg.getName())) continue;
                        String parameterValue = arg.getValue();
                        if (!arg.isAlwaysEncoded()) {
                            parameterName = URLDecoder.decode(parameterName, urlContentEncoding);
                            parameterValue = URLDecoder.decode(parameterValue, urlContentEncoding);
                        }
                        nvps.add(new BasicNameValuePair(parameterName, parameterValue));
                    }
                    UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nvps, urlContentEncoding);
                    post.setEntity((HttpEntity)entity);
                    if (entity.isRepeatable()) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        post.getEntity().writeTo((OutputStream)bos);
                        bos.flush();
                        if (contentEncoding != null) {
                            postedBody.append(new String(bos.toByteArray(), contentEncoding));
                        } else {
                            postedBody.append(new String(bos.toByteArray(), "ISO-8859-1"));
                        }
                        bos.close();
                    } else {
                        postedBody.append("<RequestEntity was not repeatable, cannot view what was sent>");
                    }
                }
            }
        }
        return postedBody.toString();
    }

    protected String sendEntityData(HttpEntityEnclosingRequestBase entity) throws IOException {
        StringBuilder entityBody = new StringBuilder(1000);
        boolean hasEntityBody = false;
        HTTPFileArg[] files = this.getHTTPFiles();
        HTTPFileArg file = files.length > 0 ? files[0] : null;
        String contentTypeValue = null;
        if (file != null && file.getMimeType() != null && file.getMimeType().length() > 0) {
            contentTypeValue = file.getMimeType();
            entity.setHeader("Content-Type", contentTypeValue);
        }
        String charset = this.getContentEncoding(HTTP.DEF_CONTENT_CHARSET.name());
        if (!this.hasArguments() && this.getSendFileAsPostBody()) {
            hasEntityBody = true;
            FileEntity fileRequestEntity = new FileEntity(new File(files[0].getPath()));
            entity.setEntity((HttpEntity)fileRequestEntity);
        } else if (this.getSendParameterValuesAsPostBody()) {
            hasEntityBody = true;
            StringBuilder entityBodyContent = new StringBuilder();
            PropertyIterator args = this.getArguments().iterator();
            while (args.hasNext()) {
                HTTPArgument arg = (HTTPArgument)args.next().getObjectValue();
                if (charset != null) {
                    entityBodyContent.append(arg.getEncodedValue(charset));
                    continue;
                }
                entityBodyContent.append(arg.getEncodedValue());
            }
            StringEntity requestEntity = new StringEntity(entityBodyContent.toString(), charset);
            entity.setEntity((HttpEntity)requestEntity);
        }
        if (hasEntityBody) {
            HttpEntity entityEntry = entity.getEntity();
            if (entityEntry.isRepeatable()) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                entityEntry.writeTo((OutputStream)bos);
                bos.flush();
                entityBody.append(new String(bos.toByteArray(), charset));
                bos.close();
            } else {
                entityBody.append("<RequestEntity was not repeatable, cannot view what was sent>");
            }
        }
        return entityBody.toString();
    }

    private String getContentEncodingOrNull() {
        return this.getContentEncoding(null);
    }

    private String getContentEncoding(String dflt) {
        String ce = this.getContentEncoding();
        if (HTTPHC4Impl.isNullOrEmptyTrimmed(ce)) {
            return dflt;
        }
        return ce;
    }

    protected String getCharsetWithDefault(HttpParams putParams) {
        String charset = (String)putParams.getParameter("http.protocol.content-charset");
        if (StringUtils.isEmpty((CharSequence)charset)) {
            charset = Charset.defaultCharset().name();
        }
        return charset;
    }

    private void saveConnectionCookies(HttpResponse method, URL u, CookieManager cookieManager) {
        if (cookieManager != null) {
            org.apache.http.Header[] hdrs;
            for (org.apache.http.Header hdr : hdrs = method.getHeaders("set-cookie")) {
                cookieManager.addCookieFromHeader(hdr.getValue(), u);
            }
        }
    }

    @Override
    protected void notifyFirstSampleAfterLoopRestart() {
        log.debug("notifyFirstSampleAfterLoopRestart");
        this.resetSSLContext = !USE_CACHED_SSL_CONTEXT;
    }

    @Override
    protected void threadFinished() {
        log.debug("Thread Finished");
        this.closeThreadLocalConnections();
    }

    private void closeThreadLocalConnections() {
        Map<HttpClientKey, HttpClient> map = HTTPCLIENTS.get();
        if (map != null) {
            for (HttpClient cl : map.values()) {
                ((AbstractHttpClient)cl).clearRequestInterceptors();
                ((AbstractHttpClient)cl).clearResponseInterceptors();
                cl.getConnectionManager().shutdown();
            }
            map.clear();
        }
    }

    public boolean interrupt() {
        HttpUriRequest request = this.currentRequest;
        if (request != null) {
            this.currentRequest = null;
            try {
                request.abort();
            }
            catch (UnsupportedOperationException e) {
                log.warn("Could not abort pending request", (Throwable)e);
            }
        }
        return request != null;
    }

    static {
        log.info("HTTP request retry count = " + RETRY_COUNT);
        DEFAULT_HTTP_PARAMS = new SyncBasicHttpParams();
        DEFAULT_HTTP_PARAMS.setBooleanParameter("http.connection.stalecheck", false);
        DefaultHttpClient.setDefaultHttpParams((HttpParams)DEFAULT_HTTP_PARAMS);
        String file = JMeterUtils.getProperty((String)"hc.parameters.file");
        if (file != null) {
            HttpClientDefaultParameters.load(file, DEFAULT_HTTP_PARAMS);
        }
        if (CPS_HTTP > 0) {
            log.info("Setting up HTTP SlowProtocol, cps=" + CPS_HTTP);
            SLOW_HTTP = new Scheme("http", 80, (SchemeSocketFactory)new SlowHC4SocketFactory(CPS_HTTP));
        } else {
            SLOW_HTTP = null;
        }
        Scheme https = null;
        if (CPS_HTTPS > 0) {
            log.info("Setting up HTTPS SlowProtocol, cps=" + CPS_HTTPS);
            try {
                https = new Scheme("https", 443, (SchemeSocketFactory)new SlowHC4SSLSocketFactory(CPS_HTTPS));
            }
            catch (GeneralSecurityException e) {
                log.warn("Failed to initialise SLOW_HTTPS scheme, cps=" + CPS_HTTPS, (Throwable)e);
            }
        } else {
            log.info("Setting up HTTPS TrustAll scheme");
            try {
                https = new Scheme("https", 443, (SchemeSocketFactory)new HC4TrustAllSSLSocketFactory());
            }
            catch (GeneralSecurityException e) {
                log.warn("Failed to initialise HTTPS TrustAll scheme", (Throwable)e);
            }
        }
        HTTPS_SCHEME = https;
        if (localAddress != null) {
            DEFAULT_HTTP_PARAMS.setParameter("http.route.local-address", (Object)localAddress);
        }
    }

    private static class ViewableFileBody
    extends FileBody {
        private boolean hideFileData = false;

        public ViewableFileBody(File file, String mimeType) {
            super(file, mimeType);
        }

        public void writeTo(OutputStream out) throws IOException {
            if (this.hideFileData) {
                out.write("<actual file content, not shown here>".getBytes());
            } else {
                super.writeTo(out);
            }
        }
    }

    private static final class HttpClientKey {
        private final String target;
        private final boolean hasProxy;
        private final String proxyHost;
        private final int proxyPort;
        private final String proxyUser;
        private final String proxyPass;
        private final int hashCode;

        public HttpClientKey(URL url, boolean hasProxy, String proxyHost, int proxyPort, String proxyUser, String proxyPass) {
            this.target = url.getProtocol() + "://" + url.getAuthority();
            this.hasProxy = hasProxy;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.proxyUser = proxyUser;
            this.proxyPass = proxyPass;
            this.hashCode = this.getHash();
        }

        private int getHash() {
            int hash = 17;
            hash = hash * 31 + (this.hasProxy ? 1 : 0);
            if (this.hasProxy) {
                hash = hash * 31 + this.getHash(this.proxyHost);
                hash = hash * 31 + this.proxyPort;
                hash = hash * 31 + this.getHash(this.proxyUser);
                hash = hash * 31 + this.getHash(this.proxyPass);
            }
            hash = hash * 31 + this.target.hashCode();
            return hash;
        }

        private int getHash(String s) {
            return s == null ? 0 : s.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof HttpClientKey)) {
                return false;
            }
            HttpClientKey other = (HttpClientKey)obj;
            if (this.hasProxy) {
                return this.hasProxy == other.hasProxy && this.proxyPort == other.proxyPort && this.proxyHost.equals(other.proxyHost) && this.proxyUser.equals(other.proxyUser) && this.proxyPass.equals(other.proxyPass) && this.target.equals(other.target);
            }
            return this.hasProxy == other.hasProxy && this.target.equals(other.target);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.target);
            if (this.hasProxy) {
                sb.append(" via ");
                sb.append(this.proxyUser);
                sb.append("@");
                sb.append(this.proxyHost);
                sb.append(":");
                sb.append(this.proxyPort);
            }
            return sb.toString();
        }
    }

    public static final class HttpDelete
    extends HttpEntityEnclosingRequestBase {
        public HttpDelete(URI uri) {
            this.setURI(uri);
        }

        public String getMethod() {
            return "DELETE";
        }
    }
}

