/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.io.IOUtils;
import org.apache.jmeter.protocol.http.control.CacheManager;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler2;
import org.apache.jmeter.samplers.Interruptible;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class SoapSampler
extends HTTPSampler2
implements Interruptible {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 240L;
    public static final String XML_DATA = "HTTPSamper.xml_data";
    public static final String URL_DATA = "SoapSampler.URL_DATA";
    public static final String SOAP_ACTION = "SoapSampler.SOAP_ACTION";
    public static final String SEND_SOAP_ACTION = "SoapSampler.SEND_SOAP_ACTION";
    public static final String XML_DATA_FILE = "SoapSampler.xml_data_file";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String SOAPACTION = "SOAPAction";
    private static final String ENCODING = "utf-8";
    private static final String DEFAULT_CONTENT_TYPE = "text/xml";

    public void setXmlData(String data) {
        this.setProperty(XML_DATA, data);
    }

    public String getXmlData() {
        return this.getPropertyAsString(XML_DATA);
    }

    public void setXmlFile(String filename) {
        this.setProperty(XML_DATA_FILE, filename);
    }

    public String getXmlFile() {
        return this.getPropertyAsString(XML_DATA_FILE);
    }

    public String getURLData() {
        return this.getPropertyAsString(URL_DATA);
    }

    public void setURLData(String url) {
        this.setProperty(URL_DATA, url);
    }

    public String getSOAPAction() {
        return this.getPropertyAsString(SOAP_ACTION);
    }

    public String getSOAPActionQuoted() {
        String action = this.getSOAPAction();
        StringBuilder sb = new StringBuilder(action.length() + 2);
        sb.append(DOUBLE_QUOTE);
        sb.append(action);
        sb.append(DOUBLE_QUOTE);
        return sb.toString();
    }

    public void setSOAPAction(String action) {
        this.setProperty(SOAP_ACTION, action);
    }

    public boolean getSendSOAPAction() {
        return this.getPropertyAsBoolean(SEND_SOAP_ACTION);
    }

    public void setSendSOAPAction(boolean action) {
        this.setProperty(SEND_SOAP_ACTION, String.valueOf(action));
    }

    protected int setPostHeaders(PostMethod post) {
        int length = 0;
        if (this.getHeaderManager() != null) {
            HeaderManager mngr = this.getHeaderManager();
            int headerSize = mngr.size();
            for (int idx = 0; idx < headerSize; ++idx) {
                Header hd = mngr.getHeader(idx);
                if (!"Content-Length".equalsIgnoreCase(hd.getName())) continue;
                length = Integer.parseInt(hd.getValue());
                break;
            }
        } else {
            post.setRequestHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        if (this.getSendSOAPAction()) {
            post.setRequestHeader(SOAPACTION, this.getSOAPActionQuoted());
        }
        return length;
    }

    private String sendPostData(PostMethod post, final int length) {
        StringBuilder postedBody = new StringBuilder(1000);
        final String xmlFile = this.getXmlFile();
        if (xmlFile != null && xmlFile.length() > 0) {
            File xmlFileAsFile = new File(xmlFile);
            if (!xmlFileAsFile.exists() || !xmlFileAsFile.canRead()) {
                throw new IllegalArgumentException(JMeterUtils.getResString((String)"soap_sampler_file_invalid") + xmlFileAsFile.getAbsolutePath());
            }
            postedBody.append("Filename: ").append(xmlFile).append("\n");
            postedBody.append("<actual file content, not shown here>");
            post.setRequestEntity(new RequestEntity(){

                public boolean isRepeatable() {
                    return true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void writeRequest(OutputStream out) throws IOException {
                    BufferedInputStream in = null;
                    try {
                        in = new BufferedInputStream(new FileInputStream(xmlFile));
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                        out.flush();
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)in);
                }

                public long getContentLength() {
                    switch (length) {
                        case -1: {
                            return -1L;
                        }
                        case 0: {
                            return new File(xmlFile).length();
                        }
                    }
                    return length;
                }

                public String getContentType() {
                    return SoapSampler.DEFAULT_CONTENT_TYPE;
                }
            });
        } else {
            postedBody.append(this.getXmlData());
            post.setRequestEntity(new RequestEntity(){

                public boolean isRepeatable() {
                    return true;
                }

                public void writeRequest(OutputStream out) throws IOException {
                    IOUtils.write((String)SoapSampler.this.getXmlData(), (OutputStream)out, (String)SoapSampler.ENCODING);
                    out.flush();
                }

                public long getContentLength() {
                    try {
                        return SoapSampler.this.getXmlData().getBytes(SoapSampler.ENCODING).length;
                    }
                    catch (UnsupportedEncodingException e) {
                        log.warn(e.getLocalizedMessage());
                        return -1L;
                    }
                }

                public String getContentType() {
                    return "text/xml; charset=utf-8";
                }
            });
        }
        return postedBody.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected HTTPSampleResult sample(URL url, String method, boolean areFollowingRedirect, int frameDepth) {
        HTTPSampleResult hTTPSampleResult;
        String urlStr = url.toString();
        log.debug("Start : sample " + urlStr);
        PostMethod httpMethod = new PostMethod(urlStr);
        HTTPSampleResult res = new HTTPSampleResult();
        res.setMonitor(false);
        res.setSampleLabel(urlStr);
        res.setHTTPMethod("POST");
        res.setURL(url);
        res.sampleStart();
        HttpClient client = null;
        InputStream instream = null;
        try {
            int content_len = this.setPostHeaders(httpMethod);
            client = this.setupConnection(url, (HttpMethodBase)httpMethod, res);
            this.setSavedClient(client);
            res.setQueryString(this.sendPostData(httpMethod, content_len));
            int statusCode = client.executeMethod((HttpMethod)httpMethod);
            res.setRequestHeaders(this.getConnectionHeaders((HttpMethod)httpMethod));
            instream = httpMethod.getResponseBodyAsStream();
            if (instream != null) {
                int len;
                org.apache.commons.httpclient.Header responseHeader = httpMethod.getResponseHeader("content-encoding");
                if (responseHeader != null && "gzip".equals(responseHeader.getValue())) {
                    instream = new GZIPInputStream(instream);
                }
                ByteArrayOutputStream outstream = new ByteArrayOutputStream(4096);
                byte[] buffer = new byte[4096];
                boolean first = true;
                while ((len = instream.read(buffer)) > 0) {
                    if (first) {
                        res.latencyEnd();
                        first = false;
                    }
                    outstream.write(buffer, 0, len);
                }
                res.setResponseData(outstream.toByteArray());
                outstream.close();
            }
            res.sampleEnd();
            res.setSampleLabel(httpMethod.getURI().toString());
            res.setResponseCode(Integer.toString(statusCode));
            res.setSuccessful(this.isSuccessCode(statusCode));
            res.setResponseMessage(httpMethod.getStatusText());
            res.setDataEncoding(ENCODING);
            res.setContentType(DEFAULT_CONTENT_TYPE);
            String ct = null;
            org.apache.commons.httpclient.Header h = httpMethod.getResponseHeader("Content-Type");
            if (h != null) {
                ct = h.getValue();
                res.setContentType(ct);
                res.setEncodingAndType(ct);
            }
            res.setResponseHeaders(this.getResponseHeaders((HttpMethod)httpMethod));
            if (res.isRedirect()) {
                res.setRedirectLocation(httpMethod.getResponseHeader("Location").getValue());
            }
            if (this.getAutoRedirects()) {
                res.setURL(new URL(httpMethod.getURI().toString()));
            }
            this.saveConnectionCookies((HttpMethod)httpMethod, res.getURL(), this.getCookieManager());
            CacheManager cacheManager = this.getCacheManager();
            if (cacheManager != null) {
                cacheManager.saveDetails((HttpMethod)httpMethod, res);
            }
            res = this.resultProcessing(areFollowingRedirect, frameDepth, res);
            log.debug("End : sample");
            httpMethod.releaseConnection();
            hTTPSampleResult = res;
            JOrphanUtils.closeQuietly((Closeable)instream);
        }
        catch (IllegalArgumentException e) {
            res.sampleEnd();
            this.errorResult(e, res);
            HTTPSampleResult hTTPSampleResult2 = res;
            return hTTPSampleResult2;
        }
        catch (IOException e2) {
            res.sampleEnd();
            this.errorResult(e2, res);
            HTTPSampleResult hTTPSampleResult3 = res;
            return hTTPSampleResult3;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            JOrphanUtils.closeQuietly(instream);
            this.setSavedClient(null);
            httpMethod.releaseConnection();
        }
        this.setSavedClient(null);
        httpMethod.releaseConnection();
        return hTTPSampleResult;
    }

    @Override
    public URL getUrl() throws MalformedURLException {
        return new URL(this.getURLData());
    }
}

