/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine;

import java.rmi.RemoteException;
import org.apache.jmeter.samplers.RemoteListenerWrapper;
import org.apache.jmeter.samplers.RemoteSampleListenerImpl;
import org.apache.jmeter.samplers.RemoteSampleListenerWrapper;
import org.apache.jmeter.samplers.RemoteTestListenerWrapper;
import org.apache.jmeter.samplers.Remoteable;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.RemoteThreadsListenerImpl;
import org.apache.jmeter.threads.RemoteThreadsListenerTestElement;
import org.apache.jmeter.threads.RemoteThreadsListenerWrapper;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ConvertListeners
implements HashTreeTraverser {
    private static final Logger log = LoggingManager.getLoggerForClass();

    public void addNode(Object node, HashTree subTree) {
        for (Object item : subTree.list()) {
            if (item instanceof AbstractThreadGroup) {
                log.debug("num threads = " + ((AbstractThreadGroup)item).getNumThreads());
            }
            if (!(item instanceof Remoteable)) continue;
            if (item instanceof RemoteThreadsListenerTestElement) {
                try {
                    RemoteThreadsListenerWrapper wrapper = new RemoteThreadsListenerWrapper(new RemoteThreadsListenerImpl());
                    subTree.replaceKey(item, (Object)wrapper);
                }
                catch (RemoteException e) {
                    log.error("Error replacing " + RemoteThreadsListenerTestElement.class.getName() + " by wrapper:" + RemoteThreadsListenerWrapper.class.getName(), (Throwable)e);
                }
                continue;
            }
            if (item instanceof ThreadListener) {
                log.error("Cannot handle ThreadListener Remotable item " + item.getClass().getName());
                continue;
            }
            try {
                AbstractTestElement wrap;
                RemoteSampleListenerImpl rtl = new RemoteSampleListenerImpl(item);
                if (item instanceof TestStateListener && item instanceof SampleListener) {
                    wrap = new RemoteListenerWrapper(rtl);
                    subTree.replaceKey(item, (Object)wrap);
                    continue;
                }
                if (item instanceof TestStateListener) {
                    wrap = new RemoteTestListenerWrapper(rtl);
                    subTree.replaceKey(item, (Object)wrap);
                    continue;
                }
                if (item instanceof SampleListener) {
                    wrap = new RemoteSampleListenerWrapper(rtl);
                    subTree.replaceKey(item, (Object)wrap);
                    continue;
                }
                log.warn("Could not replace Remotable item " + item.getClass().getName());
            }
            catch (RemoteException e) {
                log.error("", (Throwable)e);
            }
        }
    }

    public void subtractNode() {
    }

    public void processPath() {
    }
}

