/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.log.LogEvent;
import org.apache.log.LogTarget;
import org.apache.log.format.PatternFormatter;

public class LoggerPanel
extends JPanel
implements LogTarget {
    private static final long serialVersionUID = 6911128494402594429L;
    private JSyntaxTextArea textArea;
    private final PatternFormatter format;
    private static final int LOGGER_PANEL_MAX_LENGTH = JMeterUtils.getPropDefault("jmeter.loggerpanel.maxlength", 80000);
    private static final int LOGGER_PANEL_MAX_LINES_COUNT = LOGGER_PANEL_MAX_LENGTH / 80;
    private static final boolean LOGGER_PANEL_RECEIVE_WHEN_CLOSED = JMeterUtils.getPropDefault("jmeter.loggerpanel.enable_when_closed", true);

    public LoggerPanel() {
        this.init();
        this.format = new PatternFormatter("%{time:yyyy/MM/dd HH:mm:ss} %5.5{priority} - %{category}: %{message} %{throwable}\n");
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.textArea = new JSyntaxTextArea(15, 80, true);
        this.textArea.setSyntaxEditingStyle("text/plain");
        this.textArea.setCodeFoldingEnabled(false);
        this.textArea.setAntiAliasingEnabled(false);
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(false);
        this.textArea.setLanguage("text");
        this.textArea.setMargin(new Insets(2, 2, 2, 2));
        JTextScrollPane areaScrollPane = new JTextScrollPane(this.textArea);
        ((JScrollPane)((Object)areaScrollPane)).setVerticalScrollBarPolicy(22);
        ((JScrollPane)((Object)areaScrollPane)).setHorizontalScrollBarPolicy(30);
        this.add((Component)((Object)areaScrollPane), "Center");
    }

    public void processEvent(final LogEvent logEvent) {
        if (!LOGGER_PANEL_RECEIVE_WHEN_CLOSED && !GuiPackage.getInstance().getMenuItemLoggerPanel().getModel().isSelected()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JSyntaxTextArea jSyntaxTextArea = LoggerPanel.this.textArea;
                synchronized (jSyntaxTextArea) {
                    try {
                        Document doc = LoggerPanel.this.textArea.getDocument();
                        Element root = doc.getDefaultRootElement();
                        int lineCount = root.getElementCount();
                        if (lineCount > LOGGER_PANEL_MAX_LINES_COUNT) {
                            int end = root.getElement(lineCount - LOGGER_PANEL_MAX_LINES_COUNT - 1).getEndOffset();
                            doc.remove(0, end);
                        }
                        doc.insertString(doc.getLength(), LoggerPanel.this.format.format(logEvent), null);
                        LoggerPanel.this.textArea.setCaretPosition(doc.getLength() - 1);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void clear() {
        this.textArea.setText("");
    }
}

