/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.reporters;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.reporters.AbstractListenerElement;
import org.apache.jmeter.reporters.Summariser;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.Remoteable;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.save.CSVSaveService;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.ObjectProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ResultCollector
extends AbstractListenerElement
implements SampleListener,
Clearable,
Serializable,
TestStateListener,
Remoteable,
NoThreadClone {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 233L;
    private static final String TEST_IS_LOCAL = "*local*";
    private static final String TESTRESULTS_START = "<testResults>";
    private static final String TESTRESULTS_START_V1_1_PREVER = "<testResults version=\"";
    private static final String TESTRESULTS_START_V1_1_POSTVER = "\">";
    private static final String TESTRESULTS_END = "</testResults>";
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final int MIN_XML_FILE_LEN = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>".length() + "<testResults>".length() + "</testResults>".length();
    public static final String FILENAME = "filename";
    private static final String SAVE_CONFIG = "saveConfig";
    private static final String ERROR_LOGGING = "ResultCollector.error_logging";
    private static final String SUCCESS_ONLY_LOGGING = "ResultCollector.success_only_logging";
    private static final boolean SAVING_AUTOFLUSH = JMeterUtils.getPropDefault("jmeter.save.saveservice.autoflush", false);
    private static final Object LOCK = new Object();
    private static final Map<String, FileEntry> files = new HashMap<String, FileEntry>();
    private static Thread shutdownHook;
    private static int instanceCount;
    private volatile transient PrintWriter out;
    private volatile boolean inTest = false;
    private volatile boolean isStats = false;
    private volatile Summariser summariser;

    public ResultCollector() {
        this(null);
    }

    public ResultCollector(Summariser summer) {
        this.setErrorLogging(false);
        this.setSuccessOnlyLogging(false);
        this.setProperty(new ObjectProperty(SAVE_CONFIG, new SampleSaveConfiguration()));
        this.summariser = summer;
    }

    @Override
    public Object clone() {
        ResultCollector clone = (ResultCollector)super.clone();
        clone.setSaveConfig((SampleSaveConfiguration)clone.getSaveConfig().clone());
        clone.summariser = this.summariser;
        return clone;
    }

    private void setFilenameProperty(String f) {
        this.setProperty(FILENAME, f);
    }

    public String getFilename() {
        return this.getPropertyAsString(FILENAME);
    }

    public boolean isErrorLogging() {
        return this.getPropertyAsBoolean(ERROR_LOGGING);
    }

    public final void setErrorLogging(boolean errorLogging) {
        this.setProperty(new BooleanProperty(ERROR_LOGGING, errorLogging));
    }

    public final void setSuccessOnlyLogging(boolean value) {
        if (value) {
            this.setProperty(new BooleanProperty(SUCCESS_ONLY_LOGGING, true));
        } else {
            this.removeProperty(SUCCESS_ONLY_LOGGING);
        }
    }

    public boolean isSuccessOnlyLogging() {
        return this.getPropertyAsBoolean(SUCCESS_ONLY_LOGGING, false);
    }

    public boolean isSampleWanted(boolean success) {
        boolean errorOnly = this.isErrorLogging();
        boolean successOnly = this.isSuccessOnlyLogging();
        return ResultCollector.isSampleWanted(success, errorOnly, successOnly);
    }

    public static boolean isSampleWanted(boolean success, boolean errorOnly, boolean successOnly) {
        return !errorOnly && !successOnly || success && successOnly || !success && errorOnly;
    }

    public void setFilename(String f) {
        if (this.inTest) {
            return;
        }
        this.setFilenameProperty(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testEnded(String host) {
        Object object = LOCK;
        synchronized (object) {
            if (--instanceCount <= 0) {
                if (shutdownHook != null) {
                    Runtime.getRuntime().removeShutdownHook(shutdownHook);
                } else {
                    log.warn("Should not happen: shutdownHook==null, instanceCount=" + instanceCount);
                }
                this.finalizeFileOutput();
                this.inTest = false;
            }
        }
        if (this.summariser != null) {
            this.summariser.testEnded(host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testStarted(String host) {
        Object object = LOCK;
        synchronized (object) {
            if (instanceCount == 0) {
                shutdownHook = new Thread(new ShutdownHook());
                Runtime.getRuntime().addShutdownHook(shutdownHook);
            }
            ++instanceCount;
            try {
                this.initializeFileOutput();
                if (this.getVisualizer() != null) {
                    this.isStats = this.getVisualizer().isStats();
                }
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        this.inTest = true;
        if (this.summariser != null) {
            this.summariser.testStarted(host);
        }
    }

    @Override
    public void testEnded() {
        this.testEnded(TEST_IS_LOCAL);
    }

    @Override
    public void testStarted() {
        this.testStarted(TEST_IS_LOCAL);
    }

    /*
     * Exception decompiling
     */
    public void loadExistingFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void writeFileStart(PrintWriter writer, SampleSaveConfiguration saveConfig) {
        if (saveConfig.saveAsXml()) {
            writer.print(XML_HEADER);
            writer.print("\n");
            String pi = saveConfig.getXmlPi();
            if (pi.length() > 0) {
                writer.println(pi);
            }
            writer.print(TESTRESULTS_START_V1_1_PREVER);
            writer.print(SaveService.getVERSION());
            writer.print(TESTRESULTS_START_V1_1_POSTVER);
            writer.print("\n");
        } else if (saveConfig.saveFieldNames()) {
            writer.println(CSVSaveService.printableFieldNamesToString(saveConfig));
        }
    }

    private static void writeFileEnd(PrintWriter pw, SampleSaveConfiguration saveConfig) {
        if (saveConfig.saveAsXml()) {
            pw.print("\n");
            pw.print(TESTRESULTS_END);
            pw.print("\n");
        }
    }

    private static PrintWriter getFileWriter(String filename, SampleSaveConfiguration saveConfig) throws IOException {
        if (filename == null || filename.length() == 0) {
            return null;
        }
        filename = FileServer.resolveBaseRelativeName(filename);
        FileEntry fe = files.get(filename);
        PrintWriter writer = null;
        boolean trimmed = true;
        if (fe == null) {
            trimmed = saveConfig.saveAsXml() ? ResultCollector.trimLastLine(filename) : new File(filename).exists();
            File pdir = new File(filename).getParentFile();
            if (pdir != null) {
                if (pdir.mkdirs()) {
                    log.info("Folder " + pdir.getAbsolutePath() + " was created");
                }
                if (!pdir.exists()) {
                    log.warn("Error creating directories for " + pdir.toString());
                }
            }
            writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(filename, trimmed)), SaveService.getFileEncoding("UTF-8")), SAVING_AUTOFLUSH);
            log.debug("Opened file: " + filename);
            files.put(filename, new FileEntry(writer, saveConfig));
        } else {
            writer = fe.pw;
        }
        if (!trimmed) {
            ResultCollector.writeFileStart(writer, saveConfig);
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean trimLastLine(String filename) {
        RandomAccessFile raf = null;
        try {
            String line;
            raf = new RandomAccessFile(filename, "rw");
            long len = raf.length();
            if (len < (long)MIN_XML_FILE_LEN) {
                boolean bl = false;
                return bl;
            }
            raf.seek(len - (long)TESTRESULTS_END.length() - 10L);
            long pos = raf.getFilePointer();
            int end = 0;
            while ((line = raf.readLine()) != null && (end = line.indexOf(TESTRESULTS_END)) < 0) {
                pos = raf.getFilePointer();
            }
            if (line == null) {
                log.warn("Unexpected EOF trying to find XML end marker in " + filename);
                raf.close();
                boolean bl = false;
                return bl;
            }
            raf.setLength(pos + (long)end);
            raf.close();
            raf = null;
        }
        catch (FileNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            log.warn("Error trying to find XML terminator " + e.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (IOException e1) {
                log.info("Could not close " + filename + " " + e1.getLocalizedMessage());
            }
        }
        return true;
    }

    @Override
    public void sampleStarted(SampleEvent e) {
    }

    @Override
    public void sampleStopped(SampleEvent e) {
    }

    @Override
    public void sampleOccurred(SampleEvent event) {
        SampleResult result = event.getResult();
        if (this.isSampleWanted(result.isSuccessful())) {
            this.sendToVisualizer(result);
            if (this.out != null && !this.isResultMarked(result) && !this.isStats) {
                SampleSaveConfiguration config = this.getSaveConfig();
                result.setSaveConfig(config);
                try {
                    if (config.saveAsXml()) {
                        SaveService.saveSampleResult(event, this.out);
                    } else {
                        String savee = CSVSaveService.resultToDelimitedString(event);
                        this.out.println(savee);
                    }
                }
                catch (Exception err) {
                    log.error("Error trying to record a sample", (Throwable)err);
                }
            }
        }
        if (this.summariser != null) {
            this.summariser.sampleOccurred(event);
        }
    }

    protected final void sendToVisualizer(SampleResult r) {
        if (this.getVisualizer() != null) {
            this.getVisualizer().add(r);
        }
    }

    public void recordStats(TestElement e) throws IOException {
        if (this.out != null) {
            SaveService.saveTestElement(e, this.out);
        }
    }

    private boolean isResultMarked(SampleResult res) {
        String filename = this.getFilename();
        return res.markFile(filename);
    }

    private void initializeFileOutput() throws IOException {
        String filename = this.getFilename();
        if (filename != null && this.out == null) {
            try {
                this.out = ResultCollector.getFileWriter(filename, this.getSaveConfig());
            }
            catch (FileNotFoundException e) {
                this.out = null;
            }
        }
    }

    protected void flushFile() {
        if (this.out != null) {
            log.info("forced flush through ResultCollecto#flushFile");
            this.out.flush();
        }
    }

    private static void flushFileOutput() {
        for (Map.Entry<String, FileEntry> me : files.entrySet()) {
            log.debug("Flushing: " + me.getKey());
            FileEntry fe = me.getValue();
            fe.pw.flush();
            if (!fe.pw.checkError()) continue;
            log.warn("Problem detected during use of " + me.getKey());
        }
    }

    private void finalizeFileOutput() {
        for (Map.Entry<String, FileEntry> me : files.entrySet()) {
            log.debug("Closing: " + me.getKey());
            FileEntry fe = me.getValue();
            ResultCollector.writeFileEnd(fe.pw, fe.config);
            fe.pw.close();
            if (!fe.pw.checkError()) continue;
            log.warn("Problem detected during use of " + me.getKey());
        }
        files.clear();
    }

    public SampleSaveConfiguration getSaveConfig() {
        try {
            return (SampleSaveConfiguration)this.getProperty(SAVE_CONFIG).getObjectValue();
        }
        catch (ClassCastException e) {
            this.setSaveConfig(new SampleSaveConfiguration());
            return this.getSaveConfig();
        }
    }

    public void setSaveConfig(SampleSaveConfiguration saveConfig) {
        this.getProperty(SAVE_CONFIG).setObjectValue(saveConfig);
    }

    @Override
    public void clearData() {
    }

    private static final class ShutdownHook
    implements Runnable {
        private ShutdownHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.info("Shutdown hook started");
            Object object = LOCK;
            synchronized (object) {
                ResultCollector.flushFileOutput();
            }
            log.info("Shutdown hook ended");
        }
    }

    private static class FileEntry {
        final PrintWriter pw;
        final SampleSaveConfiguration config;

        FileEntry(PrintWriter _pw, SampleSaveConfiguration _config) {
            this.pw = _pw;
            this.config = _config;
        }
    }
}

