/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import junit.framework.TestCase;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.java.control.gui.ClassFilter;
import org.apache.jmeter.protocol.java.sampler.JUnitSampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextField;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class JUnitTestSamplerGui
extends AbstractSamplerGui
implements ChangeListener,
ActionListener,
ItemListener {
    private static final long serialVersionUID = 240L;
    private static final Logger log;
    private static final String TESTMETHOD_PREFIX = "test";
    private static final String ONETIMESETUP = "oneTimeSetUp";
    private static final String ONETIMETEARDOWN = "oneTimeTearDown";
    private static final String SUITE = "suite";
    private static final String[] SPATHS;
    private JLabeledTextField constructorLabel = new JLabeledTextField(JMeterUtils.getResString((String)"junit_constructor_string"));
    private JLabel methodLabel = new JLabel(JMeterUtils.getResString((String)"junit_test_method"));
    private JLabeledTextField successMsg = new JLabeledTextField(JMeterUtils.getResString((String)"junit_success_msg"));
    private JLabeledTextField failureMsg = new JLabeledTextField(JMeterUtils.getResString((String)"junit_failure_msg"));
    private JLabeledTextField errorMsg = new JLabeledTextField(JMeterUtils.getResString((String)"junit_error_msg"));
    private JLabeledTextField successCode = new JLabeledTextField(JMeterUtils.getResString((String)"junit_success_code"));
    private JLabeledTextField failureCode = new JLabeledTextField(JMeterUtils.getResString((String)"junit_failure_code"));
    private JLabeledTextField errorCode = new JLabeledTextField(JMeterUtils.getResString((String)"junit_error_code"));
    private JLabeledTextField filterpkg = new JLabeledTextField(JMeterUtils.getResString((String)"junit_pkg_filter"));
    private JCheckBox doSetup = new JCheckBox(JMeterUtils.getResString((String)"junit_do_setup_teardown"));
    private JCheckBox appendError = new JCheckBox(JMeterUtils.getResString((String)"junit_append_error"));
    private JCheckBox appendExc = new JCheckBox(JMeterUtils.getResString((String)"junit_append_exception"));
    private JCheckBox junit4 = new JCheckBox(JMeterUtils.getResString((String)"junit_junit4"));
    private JCheckBox createInstancePerSample = new JCheckBox(JMeterUtils.getResString((String)"junit_create_instance_per_sample"));
    private JComboBox classnameCombo;
    private JComboBox methodName;
    private final transient ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();

    public JUnitTestSamplerGui() {
        this.init();
    }

    public String getLabelResource() {
        return "junit_request";
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        this.add(this.createClassPanel(), "Center");
    }

    private void setupClasslist() {
        this.classnameCombo.removeAllItems();
        this.methodName.removeAllItems();
        try {
            List classList = this.junit4.isSelected() ? ClassFinder.findAnnotatedClasses((String[])SPATHS, (Class[])new Class[]{Test.class}, (boolean)false) : ClassFinder.findClassesThatExtend((String[])SPATHS, (Class[])new Class[]{TestCase.class});
            ClassFilter filter = new ClassFilter();
            filter.setPackges(JOrphanUtils.split((String)this.filterpkg.getText(), (String)","));
            Object[] clist = filter.filterArray(classList);
            for (int idx = 0; idx < clist.length; ++idx) {
                this.classnameCombo.addItem(clist[idx]);
            }
        }
        catch (IOException e) {
            log.error("Exception getting interfaces.", (Throwable)e);
        }
    }

    private JPanel createClassPanel() {
        JLabel label = new JLabel(JMeterUtils.getResString((String)"protocol_java_classname"));
        this.classnameCombo = new JComboBox();
        this.classnameCombo.addActionListener(this);
        this.classnameCombo.setEditable(false);
        label.setLabelFor(this.classnameCombo);
        this.methodName = new JComboBox();
        this.methodName.addActionListener(this);
        this.methodLabel.setLabelFor(this.methodName);
        this.setupClasslist();
        VerticalPanel panel = new VerticalPanel();
        panel.add((Component)this.junit4);
        this.junit4.addItemListener(this);
        panel.add((Component)this.filterpkg);
        this.filterpkg.addChangeListener((ChangeListener)this);
        panel.add((Component)label);
        panel.add((Component)this.classnameCombo);
        this.constructorLabel.setText("");
        panel.add((Component)this.constructorLabel);
        panel.add((Component)this.methodLabel);
        panel.add((Component)this.methodName);
        panel.add((Component)this.successMsg);
        panel.add((Component)this.successCode);
        panel.add((Component)this.failureMsg);
        panel.add((Component)this.failureCode);
        panel.add((Component)this.errorMsg);
        panel.add((Component)this.errorCode);
        panel.add((Component)this.doSetup);
        panel.add((Component)this.appendError);
        panel.add((Component)this.appendExc);
        panel.add((Component)this.createInstancePerSample);
        return panel;
    }

    private void initGui() {
        this.appendError.setSelected(false);
        this.appendExc.setSelected(false);
        this.createInstancePerSample.setSelected(false);
        this.doSetup.setSelected(false);
        this.junit4.setSelected(false);
        this.filterpkg.setText("");
        this.constructorLabel.setText("");
        this.successCode.setText(JMeterUtils.getResString((String)"junit_success_default_code"));
        this.successMsg.setText(JMeterUtils.getResString((String)"junit_success_default_msg"));
        this.failureCode.setText(JMeterUtils.getResString((String)"junit_failure_default_code"));
        this.failureMsg.setText(JMeterUtils.getResString((String)"junit_failure_default_msg"));
        this.errorMsg.setText(JMeterUtils.getResString((String)"junit_error_default_msg"));
        this.errorCode.setText(JMeterUtils.getResString((String)"junit_error_default_code"));
    }

    public void clearGui() {
        super.clearGui();
        this.initGui();
    }

    public TestElement createTestElement() {
        JUnitSampler sampler = new JUnitSampler();
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement el) {
        JUnitSampler sampler = (JUnitSampler)el;
        this.configureTestElement((TestElement)sampler);
        if (this.classnameCombo.getSelectedItem() != null && this.classnameCombo.getSelectedItem() instanceof String) {
            sampler.setClassname((String)this.classnameCombo.getSelectedItem());
        } else {
            sampler.setClassname(null);
        }
        sampler.setConstructorString(this.constructorLabel.getText());
        if (this.methodName.getSelectedItem() != null) {
            Object mobj = this.methodName.getSelectedItem();
            sampler.setMethod((String)mobj);
        } else {
            sampler.setMethod(null);
        }
        sampler.setFilterString(this.filterpkg.getText());
        sampler.setSuccess(this.successMsg.getText());
        sampler.setSuccessCode(this.successCode.getText());
        sampler.setFailure(this.failureMsg.getText());
        sampler.setFailureCode(this.failureCode.getText());
        sampler.setError(this.errorMsg.getText());
        sampler.setErrorCode(this.errorCode.getText());
        sampler.setDoNotSetUpTearDown(this.doSetup.isSelected());
        sampler.setAppendError(this.appendError.isSelected());
        sampler.setAppendException(this.appendExc.isSelected());
        sampler.setCreateOneInstancePerSample(this.createInstancePerSample.isSelected());
        sampler.setJunit4(this.junit4.isSelected());
    }

    public void configure(TestElement el) {
        super.configure(el);
        JUnitSampler sampler = (JUnitSampler)el;
        this.junit4.setSelected(sampler.getJunit4());
        this.filterpkg.setText(sampler.getFilterString());
        this.classnameCombo.setSelectedItem(sampler.getClassname());
        this.setupMethods();
        this.methodName.setSelectedItem(sampler.getMethod());
        this.constructorLabel.setText(sampler.getConstructorString());
        if (sampler.getSuccessCode().length() > 0) {
            this.successCode.setText(sampler.getSuccessCode());
        } else {
            this.successCode.setText(JMeterUtils.getResString((String)"junit_success_default_code"));
        }
        if (sampler.getSuccess().length() > 0) {
            this.successMsg.setText(sampler.getSuccess());
        } else {
            this.successMsg.setText(JMeterUtils.getResString((String)"junit_success_default_msg"));
        }
        if (sampler.getFailureCode().length() > 0) {
            this.failureCode.setText(sampler.getFailureCode());
        } else {
            this.failureCode.setText(JMeterUtils.getResString((String)"junit_failure_default_code"));
        }
        if (sampler.getFailure().length() > 0) {
            this.failureMsg.setText(sampler.getFailure());
        } else {
            this.failureMsg.setText(JMeterUtils.getResString((String)"junit_failure_default_msg"));
        }
        if (sampler.getError().length() > 0) {
            this.errorMsg.setText(sampler.getError());
        } else {
            this.errorMsg.setText(JMeterUtils.getResString((String)"junit_error_default_msg"));
        }
        if (sampler.getErrorCode().length() > 0) {
            this.errorCode.setText(sampler.getErrorCode());
        } else {
            this.errorCode.setText(JMeterUtils.getResString((String)"junit_error_default_code"));
        }
        this.doSetup.setSelected(sampler.getDoNotSetUpTearDown());
        this.appendError.setSelected(sampler.getAppendError());
        this.appendExc.setSelected(sampler.getAppendException());
        this.createInstancePerSample.setSelected(sampler.getCreateOneInstancePerSample());
    }

    private void setupMethods() {
        String className = (String)this.classnameCombo.getSelectedItem();
        this.methodName.removeAllItems();
        if (className != null) {
            try {
                Class<?> testClass = Class.forName(className, false, this.contextClassLoader);
                String[] names = this.getMethodNames(testClass);
                for (int idx = 0; idx < names.length; ++idx) {
                    this.methodName.addItem(names[idx]);
                }
                this.methodName.repaint();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private String[] getMethodNames(Class<?> clazz) {
        Method[] meths = clazz.getMethods();
        ArrayList<String> list = new ArrayList<String>();
        for (int idx = 0; idx < meths.length; ++idx) {
            Method method = meths[idx];
            String name = method.getName();
            if (this.junit4.isSelected()) {
                if (!method.isAnnotationPresent(Test.class) && !method.isAnnotationPresent(BeforeClass.class) && !method.isAnnotationPresent(AfterClass.class)) continue;
                list.add(name);
                continue;
            }
            if (!name.startsWith(TESTMETHOD_PREFIX) && !name.equals(ONETIMESETUP) && !name.equals(ONETIMETEARDOWN) && !name.equals(SUITE)) continue;
            list.add(name);
        }
        if (list.size() > 0) {
            return list.toArray(new String[list.size()]);
        }
        return new String[0];
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.classnameCombo) {
            this.setupMethods();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getItem() == this.junit4) {
            this.setupClasslist();
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (event.getSource() == this.filterpkg) {
            this.setupClasslist();
        }
    }

    static {
        String[] paths;
        log = LoggingManager.getLoggerForClass();
        String ucp = JMeterUtils.getProperty((String)"user.classpath");
        if (ucp != null) {
            String[] parts = ucp.split(File.pathSeparator);
            paths = new String[parts.length + 1];
            paths[0] = JMeterUtils.getJMeterHome() + "/lib/junit/";
            System.arraycopy(parts, 0, paths, 1, parts.length);
        } else {
            paths = new String[]{JMeterUtils.getJMeterHome() + "/lib/junit/"};
        }
        SPATHS = paths;
    }
}

