/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.protocol.http.util.HTTPFileArg;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.TestElementProperty;

public class HTTPFileArgs
extends ConfigTestElement
implements Serializable {
    private static final long serialVersionUID = 240L;
    private static final String HTTP_FILE_ARGS = "HTTPFileArgs.files";

    public HTTPFileArgs() {
        this.setProperty((JMeterProperty)new CollectionProperty(HTTP_FILE_ARGS, new ArrayList()));
    }

    public CollectionProperty getHTTPFileArgsCollection() {
        return (CollectionProperty)this.getProperty(HTTP_FILE_ARGS);
    }

    public void clear() {
        super.clear();
        this.setProperty((JMeterProperty)new CollectionProperty(HTTP_FILE_ARGS, new ArrayList()));
    }

    public void setHTTPFileArgs(List<HTTPFileArg> files) {
        this.setProperty((JMeterProperty)new CollectionProperty(HTTP_FILE_ARGS, files));
    }

    public void addHTTPFileArg(String path) {
        this.addHTTPFileArg(new HTTPFileArg(path));
    }

    public void addHTTPFileArg(HTTPFileArg file) {
        TestElementProperty newHTTPFileArg = new TestElementProperty(file.getPath(), (TestElement)file);
        if (this.isRunningVersion()) {
            this.setTemporary((JMeterProperty)newHTTPFileArg);
        }
        this.getHTTPFileArgsCollection().addItem((Object)newHTTPFileArg);
    }

    public void addHTTPFileArg(String path, String param, String mime) {
        this.addHTTPFileArg(new HTTPFileArg(path, param, mime));
    }

    public PropertyIterator iterator() {
        return this.getHTTPFileArgsCollection().iterator();
    }

    public HTTPFileArg[] asArray() {
        CollectionProperty props = this.getHTTPFileArgsCollection();
        int size = props.size();
        HTTPFileArg[] args = new HTTPFileArg[size];
        for (int i = 0; i < size; ++i) {
            args[i] = (HTTPFileArg)props.get(i).getObjectValue();
        }
        return args;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        PropertyIterator iter = this.getHTTPFileArgsCollection().iterator();
        while (iter.hasNext()) {
            HTTPFileArg file = (HTTPFileArg)iter.next().getObjectValue();
            str.append(file.toString());
            if (!iter.hasNext()) continue;
            str.append("\n");
        }
        return str.toString();
    }

    public void removeHTTPFileArg(int row) {
        if (row < this.getHTTPFileArgCount()) {
            this.getHTTPFileArgsCollection().remove(row);
        }
    }

    public void removeHTTPFileArg(HTTPFileArg file) {
        PropertyIterator iter = this.getHTTPFileArgsCollection().iterator();
        while (iter.hasNext()) {
            HTTPFileArg item = (HTTPFileArg)iter.next().getObjectValue();
            if (!file.equals(item)) continue;
            iter.remove();
        }
    }

    public void removeHTTPFileArg(String filePath) {
        PropertyIterator iter = this.getHTTPFileArgsCollection().iterator();
        while (iter.hasNext()) {
            HTTPFileArg file = (HTTPFileArg)iter.next().getObjectValue();
            if (!file.getPath().equals(filePath)) continue;
            iter.remove();
        }
    }

    public void removeAllHTTPFileArgs() {
        this.getHTTPFileArgsCollection().clear();
    }

    public void addEmptyHTTPFileArg() {
        this.addHTTPFileArg(new HTTPFileArg(""));
    }

    public int getHTTPFileArgCount() {
        return this.getHTTPFileArgsCollection().size();
    }

    public HTTPFileArg getHTTPFileArg(int row) {
        HTTPFileArg file = null;
        if (row < this.getHTTPFileArgCount()) {
            file = (HTTPFileArg)this.getHTTPFileArgsCollection().get(row).getObjectValue();
        }
        return file;
    }
}

